/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.formplugin.treelist;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.IPageCache;
import kd.epm.epbs.common.util.function.ThreeConsumer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public interface ICommonSelectedF7Cache<T> {
    default public void cacheSelectMember(@NotNull IPageCache pageCache, T t) {
        if (t == null || t instanceof Collection && ((Collection)t).isEmpty() || t instanceof Map && ((Map)t).isEmpty()) {
            pageCache.remove("LIST_MEMBER_CACHE_SELECT");
        } else {
            pageCache.put("LIST_MEMBER_CACHE_SELECT", SerializationUtils.serializeToBase64(t));
        }
    }

    default public T getSelectedIdsFromCache(@NotNull IPageCache pageCache) {
        return this.getSelectedIdsFromCacheWithDefault(pageCache, null);
    }

    default public T getSelectedIdsFromCacheWithDefault(@NotNull IPageCache pageCache, Supplier<T> supplier) {
        Object selectMembers = null;
        String _cacheStr = pageCache.get("LIST_MEMBER_CACHE_SELECT");
        if (StringUtils.isNotEmpty((CharSequence)_cacheStr)) {
            selectMembers = SerializationUtils.deSerializeFromBase64((String)_cacheStr);
        }
        if (selectMembers == null && supplier != null) {
            selectMembers = supplier.get();
        }
        return (T)selectMembers;
    }

    default public void buildSelectedMember(Collection<?> objects, ThreeConsumer<Long, String, String> consumer) {
        for (Object _object : objects) {
            String name;
            String number;
            Long pk;
            if (_object instanceof DynamicObject) {
                pk = ((DynamicObject)_object).getLong("id");
                number = ((DynamicObject)_object).getString("number");
                name = ((DynamicObject)_object).getString("name");
            } else if (_object instanceof Row) {
                pk = ((Row)_object).getLong("id");
                number = ((Row)_object).getString("number");
                name = ((Row)_object).getString("name");
            } else if (_object instanceof ListSelectedRow) {
                number = ((ListSelectedRow)_object).getNumber();
                pk = (Long)((ListSelectedRow)_object).getPrimaryKeyValue();
                name = ((ListSelectedRow)_object).getName();
            } else {
                throw new IllegalStateException();
            }
            consumer.accept((Object)pk, (Object)number, (Object)name);
        }
    }
}

