/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.task.log;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.schedule.executor.AbstractTask;
import kd.epm.epbs.common.enums.AppDBRouteEnum;

public class PermLogAutoCleanTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(PermLogAutoCleanTask.class);
    private static final int LEAVE_FUNCTIONPERMLOG_COUNT = 200000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.cleanFunctionPermLog();
    }

    private void cleanFunctionPermLog() {
        try {
            DataSet ds = ORM.create().queryDataSet("PermLogAutoCleanTask.queryfunpermlog", "epbs_functionpermlog", "id", null, "id DESC", 200000, 1, null);
            if (ds.hasNext()) {
                Long id = ds.next().getLong("id");
                Date use = ID.getCreateTime((long)id);
                LocalDateTime localDateTime = LocalDateTime.now().minusMonths(2L);
                Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
                if (date.after(use)) {
                    DB.execute((DBRoute)AppDBRouteEnum.EPBS.getDbRoute(), (String)"DELETE FROM t_epbs_functionpermlog WHERE fid < ?", (Object[])new Object[]{id});
                }
            }
        }
        catch (KDException e) {
            log.error((Throwable)e);
        }
    }
}

