/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.cashflow;

import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.service.ExportBillListService;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.business.balance.EPMDBalanceServiceHelper;
import kd.epm.epdm.business.cashflow.EPMLCashFlowHelper;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.business.etl.EtlRunningConfigService;
import kd.epm.epdm.business.etl.helper.EPDMETLTaskHelper;
import kd.epm.epdm.business.etl.vo.RunningConfig;
import kd.epm.epdm.business.etl.vo.RunningStatus;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.util.ListColumnEditUtil;

public class EPMLCashFlowListPlugin
extends AbstractBaseListPlugin {
    private static final String BILL_LIST = "billlistap";
    private static final String BTN_COLLECTION = "btn_collection";
    private static final String EXPORT_CONFIRM_BACK = "exportConfirmBack";
    private static final String BTN_EXPORT = "btn_export";
    private static final String CACHE_FIRST_VISIT = "first_visit";

    public void initialize() {
        super.initialize();
        BillList bill = (BillList)this.getView().getControl(BILL_LIST);
        bill.addCreateListColumnsListener(columnsArgs -> EPMLCashFlowHelper.addUserPresetToCol((List)columnsArgs.getListColumns()));
        bill.addPackageDataListener(e -> ListColumnEditUtil.formatDecimalAndHideZero((PackageDataEvent)e, propertyName -> propertyName.startsWith("count")));
        bill.addCreateListDataProviderListener(e -> e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public void setQueryBuilder(QueryBuilder queryBuilder) {
                super.setQueryBuilder(queryBuilder);
                DynamicObjectType dt = queryBuilder.getReturnEntityType();
                dt.registerSimpleProperty(new DynamicSimpleProperty("cashflowitemname", String.class, (Object)""));
                dt.registerSimpleProperty(new DynamicSimpleProperty("currencybasefilter", DynamicObject.class, null));
                EPMLCashFlowHelper.dealCommonBaseDataFilter((QFilter[])queryBuilder.getFilters());
            }
        }));
        bill.addBeforePackageDataListener(e -> {
            DynamicObjectCollection pageData = e.getPageData();
            EPMLCashFlowHelper.queryNoAliasField((DynamicObjectCollection)pageData);
        });
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get(CACHE_FIRST_VISIT) == null) {
            EPMDBalanceServiceHelper.initCommonFilterColumnsDefaultValue((List)args.getCommonFilterColumns());
            DataModelPresetHelper.userSettingToFilterColumn((DataModelPresetEnum)DataModelPresetEnum.T_EPM_CASHFLOW, arg_0 -> ((FilterContainerInitArgs)args).addFilterColumn(arg_0));
            pageCache.put(CACHE_FIRST_VISIT, "v");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String itemKey = eventArgs.getOperateKey();
        if (BTN_COLLECTION.equals(itemKey)) {
            this.showVoucherCollectionPage();
        } else if (BTN_EXPORT.equals(itemKey)) {
            BillList billList = (BillList)this.getControl(BILL_LIST);
            ExportBillListService.exportConfirm((BillList)billList, (ConfirmCallBackListener)new ConfirmCallBackListener(EXPORT_CONFIRM_BACK, (IFormPlugin)this), EPMLCashFlowHelper::dealCommonBaseDataFilter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (EXPORT_CONFIRM_BACK.equals(event.getCallBackId()) && MessageBoxResult.Yes == event.getResult()) {
            BillList billList = (BillList)this.getControl(BILL_LIST);
            EPMLCashFlowHelper.export((BillList)billList, EPMLCashFlowHelper::dealCommonBaseDataFilter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        if (BTN_COLLECTION.equals(event.getActionId()) && (returnData = event.getReturnData()) != null) {
            this.voucherCollectionPageBack(returnData);
        }
    }

    private void showVoucherCollectionPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("epdm_vouchercollection");
        showParameter.setCaption(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91c7\u96c6", (String)"EPMLCashFlowListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("tartype", (Object)DataModelPresetEnum.T_EPM_CASHFLOW.getId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_COLLECTION));
        this.getView().showForm(showParameter);
    }

    private void voucherCollectionPageBack(Object returnData) {
        MultiLangEnumBridge msg;
        String number;
        Map map = (Map)returnData;
        RunningConfig conf = new RunningConfig();
        Long id = (Long)map.remove("id");
        conf.setTaskId(id.longValue());
        List list = EPDMETLTaskHelper.getParamConfigById((long)id, fieldMap -> fieldMap.put("value", map.get(fieldMap.get("number"))));
        conf.setParams(conf.listToParams(list));
        EtlRunningConfigService configService = new EtlRunningConfigService();
        RunningStatus runningStatus = configService.setRunningParams(conf);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epdm_etl_task", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        String string = number = dynamicObject != null ? dynamicObject.getString("number") : "";
        if (200 == runningStatus.getCode()) {
            msg = new MultiLangEnumBridge("\u7f16\u7801\uff1a%s\uff0c\u91c7\u96c6\u4efb\u52a1\u542f\u52a8\u6210\u529f\u3002", "EPMLCashFlowListPlugin_2", "epm-epbs-formplugin", new Object[]{number});
            this.getView().showSuccessNotification(msg.loadKDString());
        } else {
            msg = new MultiLangEnumBridge("\u7f16\u7801\uff1a%s\uff0c\u91c7\u96c6\u4efb\u52a1\u542f\u52a8\u5931\u8d25\u3002", "EPMLCashFlowListPlugin_3", "epm-epbs-formplugin", new Object[]{number});
            this.getView().showErrorNotification(msg.loadKDString() + runningStatus.getMessage());
        }
        OperationLogUtil.writeLog((String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (IOperationTypeInfo)new OperationTypeInfo("cashflow_collect", new MultiLangEnumBridge("\u73b0\u91d1\u6d41\u4f59\u989d\u91c7\u96c6", "EPMLCashFlowListPlugin_5", "epm-epbs-formplugin")), (MultiLangEnumBridge)msg);
    }
}

