/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.datamodel;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.form.FormOpener;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.LeftTreeSearch;
import kd.epm.epbs.common.tree.SimpleDynamicTreeBuilder;
import kd.epm.epbs.common.util.AppUtils;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.common.constant.EPDMCatalogConstant;
import kd.epm.epdm.common.enums.CatalogTypeEnum;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class DataModelFormPlugin
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
SearchEnterListener,
LeftTreeSearch {
    private static final String TREEVIEWAP = "treeviewap";

    public void initialize() {
        super.initialize();
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnnew", "btnedit", "btndel"});
        Search treeSearch = (Search)this.getView().getControl("searchap");
        treeSearch.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        formShowParameter.setCustomParam("source", (Object)"epm");
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_group"});
        this.initTree(null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void initTree(String focusNodeId) {
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
        focusNodeId = focusNodeId == null ? tv.getTreeState().getFocusNodeId() : focusNodeId;
        QFilter qFilter = new QFilter("long_number", "like", (Object)(EPDMCatalogConstant.EPM_ROOT_CATALOG_LONG_NUMBER + "%"));
        DynamicTreeContext context = new DynamicTreeContext("iscx_catalog");
        context.setSelectFields("id,number,name,parent,type,long_number");
        context.setOrderby("priority");
        context.setqFilters(qFilter.toArray());
        context.setFocusTreeId(focusNodeId);
        AbstractTreeBuilder treeBuilder = new SimpleDynamicTreeBuilder(context).buildTree(tv);
        if (focusNodeId == null) {
            TreeNode root = treeBuilder.getRoot();
            tv.treeNodeClick(root.getParentid(), root.getId());
        } else {
            treeBuilder.nodeClick();
        }
    }

    private Map<String, Object> getNodeData(String nodeId) {
        TreeNode treeNode;
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        TreeNode root = AbstractTreeBuilder.getRootWithCache((TreeView)tree);
        Map nodeData = null;
        if (root != null && (treeNode = root.getTreeNode(nodeId)) != null) {
            nodeData = (Map)treeNode.getData();
        }
        return nodeData;
    }

    private String getFocusNodeId() {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        return tree.getTreeState().getFocusNodeId();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"btnnew", "btnedit", "btndel"})) {
            String focusNodeId = this.getFocusNodeId();
            Map<String, Object> nodeData = this.getNodeData(focusNodeId);
            if (nodeData != null) {
                String type = (String)nodeData.get("type");
                if ("btnnew".equals(key) && !type.equals(CatalogTypeEnum.System.name())) {
                    QFilter qFilter = new QFilter("parent.number", "=", (Object)EPDMCatalogConstant.EPM_ROOT_CATALOG_NUMBER);
                    DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"iscx_catalog", (String)"name", (QFilter[])qFilter.toArray());
                    List nameList = dynamicObjects.stream().map(o -> o.getString("name")).collect(Collectors.toList());
                    String nameStr = String.join((CharSequence)"\u3001", nameList);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5728%s\u6a21\u578b\u96c6\u4e0b\u65b0\u589e\u5b50\u6a21\u578b\u96c6\uff0c\u5176\u4f59\u6a21\u578b\u96c6\u4e0d\u652f\u6301\u65b0\u589e\u6a21\u578b\u96c6\u3002", (String)"DataModelFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), nameStr));
                    args.setCancel(true);
                } else if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"btnedit", "btndel"}) && !type.equals(CatalogTypeEnum.Module.name())) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u3001\u7f16\u8f91\u9884\u7f6e\u6a21\u578b\u96c6\u3002", (String)"DataModelFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
            } else {
                args.setCancel(true);
            }
            String appPkId = AppUtils.getAppPkId((IFormView)this.getView());
            if ("btnnew".equals(key)) {
                boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appPkId, (String)"epdm_dm_catalog", (String)"47156aff000000ac");
                if (!permission) {
                    args.setCancel(true);
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c\u6a21\u578b\u96c6\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataModelFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
            } else if ("btndel".equals(key)) {
                boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appPkId, (String)"epdm_dm_catalog", (String)"4715e1f1000000ac");
                if (!permission) {
                    args.setCancel(true);
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u201c\u6a21\u578b\u96c6\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataModelFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                boolean exists = QueryServiceHelper.exists((String)"epdm_dm", (QFilter[])new QFilter[]{new QFilter("catalog", "=", (Object)IDUtils.toLong((Object)focusNodeId))});
                if (exists) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u578b\u96c6\u4e0b\u5b58\u5728\u6570\u636e\u6570\u636e\u6a21\u578b\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"DataModelFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void openNewCatalog() {
        String focusNodeId = this.getFocusNodeId();
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("type", CatalogTypeEnum.Module.name());
        param.put("parent", Long.parseLong(focusNodeId));
        FormOpener.showForm((AbstractFormPlugin)this, (String)"epdm_dm_catalog", (String)"", param, (String)"addCatalog");
    }

    private void deleteCatalog() {
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete_card", (IFormPlugin)this);
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5220\u9664%s\u5417\uff1f", (String)"DataModelFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), nodeData != null ? nodeData.get("name") : " "), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks, (Map)null, focusNodeId);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("delete_card".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            String customVaule = evt.getCustomVaule();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)customVaule, (String)"iscx_catalog", (String)"name");
            if (dynamicObject == null) {
                return;
            }
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"iscx_catalog", (Object[])new Object[]{evt.getCustomVaule()}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.writeLog((IOperationTypeInfo)OperationTypeEnum.DELETE, OperationMsgUtil.getSucStatus());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataModelFormPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
                String parentid = (String)tree.getTreeState().getFocusNode().get("parentid");
                this.initTree(parentid);
            } else {
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private void openEditCatalog() {
        String focusNodeId = this.getFocusNodeId();
        Map<String, Object> nodeData = this.getNodeData(focusNodeId);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        if (nodeData != null) {
            param.put("type", nodeData.get("type"));
            param.put("parent", nodeData.get("parent"));
            param.put("catalogId", focusNodeId);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"epdm_dm_catalog", (String)"", param, (String)"addCatalog");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("addCatalog".equals(evt.getActionId()) && evt.getReturnData() != null) {
            this.initTree(null);
        }
    }

    public void setFilter(SetFilterEvent e) {
        Map<String, Object> nodeData = this.getNodeData(this.getFocusNodeId());
        List qFilters = e.getQFilters();
        if (nodeData != null) {
            e.addCustomQFilter(new QFilter("catalog.long_number", "like", (Object)(nodeData.get("long_number") + "%")));
        } else {
            e.addCustomQFilter(new QFilter("catalog.long_number", "like", (Object)(EPDMCatalogConstant.EPM_ROOT_CATALOG_LONG_NUMBER + "%")));
        }
        e.addCustomQFilter(new QFilter("source_app", "=", (Object)"epm"));
        e.addCustomQFilter(new QFilter("type", "in", (Object)new String[]{ResourceTypeEnum.DataTable.getNumber(), ResourceTypeEnum.DataEntity.getNumber(), ResourceTypeEnum.DataView.getNumber()}));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        billList.refresh();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.initTree(null);
        } else if ("frommetadata".equals(operateKey) || "select_type".equals(operateKey) || "reverse".equals(operateKey)) {
            String focusNodeId = this.getFocusNodeId();
            Map<String, Object> nodeData = this.getNodeData(focusNodeId);
            if (nodeData != null && CatalogTypeEnum.Module.name().equals(nodeData.get("type"))) {
                this.getView().getPageCache().put("catalogId", focusNodeId);
                this.getView().getFormShowParameter().setCustomParam("catalog", (Object)focusNodeId);
            } else {
                this.getView().getPageCache().remove("catalogId");
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.remove("catalog");
            }
        } else if ("btnnew".equals(operateKey)) {
            this.openNewCatalog();
        } else if ("btndel".equals(operateKey)) {
            this.deleteCatalog();
        } else if ("btnedit".equals(operateKey)) {
            this.openEditCatalog();
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String text = searchEnterEvent.getText().trim();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        TreeView tv = (TreeView)this.getView().getControl(TREEVIEWAP);
        this.leftSearch(tv, text);
    }
}

