/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.datamodel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OpCodeInfo;
import kd.epm.epbs.common.form.FormOpener;
import kd.epm.epbs.common.util.D;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.business.datamodel.helper.ImportMetaToIscxResourceHelper;
import kd.epm.epdm.common.enums.CataLogPresetEnum;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import kd.epm.epdm.common.enums.ResourceTypeGroupEnum;
import kd.epm.epdm.common.enums.form.EpdmDatamodelTableEnum;
import kd.epm.epdm.common.enums.form.EpdmDmPresetEnum;
import kd.epm.epdm.common.util.CatalogUtil;

public class DataModelListPlugin
extends AbstractBaseListPlugin {
    private static final String MODEL_MAPPING_CACHE = "dataModelToMain";

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject dyObject = e.getRowData();
        AbstractColumnDesc column = (AbstractColumnDesc)e.getSource();
        if ("ispreset".equals(column.getFieldKey())) {
            String catalogNumber = dyObject.getDynamicObject("catalog").getString("number");
            if (CataLogPresetEnum.EPM_BUSINESS.getNumber().equals(catalogNumber)) {
                DataModelPresetEnum dataModelPresetEnum = DataModelPresetEnum.getDataModelPreset((Long)((Long)dyObject.getPkValue()));
                e.setFormatValue((Object)(dataModelPresetEnum != null ? 1 : 0));
            } else {
                e.setFormatValue((Object)false);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dys = super.getData(start, limit);
                if (dys != null) {
                    ArrayList<Long> ids = new ArrayList<Long>(dys.size());
                    for (DynamicObject dy : dys) {
                        ids.add(dy.getLong("id"));
                    }
                    QFilter filter = new QFilter(EpdmDmPresetEnum.datamodel.s(), "in", ids);
                    DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)EpdmDmPresetEnum.getFormId(), (String)(EpdmDmPresetEnum.datamodel + "," + EpdmDmPresetEnum.mainmodel), (QFilter[])new QFilter[]{filter});
                    HashMap<Long, Long> dataModelToMain = new HashMap<Long, Long>(dys.size());
                    for (DynamicObject dy : dynamicObjects) {
                        dataModelToMain.put(dy.getLong(EpdmDmPresetEnum.datamodel.s()), dy.getLong(EpdmDmPresetEnum.mainmodel.s()));
                    }
                    DataModelListPlugin.this.getPageCache().put(DataModelListPlugin.MODEL_MAPPING_CACHE, JSON.toJSONString(dataModelToMain));
                } else {
                    DataModelListPlugin.this.getPageCache().put(DataModelListPlugin.MODEL_MAPPING_CACHE, "{}");
                }
                return dys;
            }
        });
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs a) {
        a.setCancel(true);
        if ("number".equals(a.getFieldName())) {
            Long id = (Long)this.getFocusRowPkId();
            DataModelPresetEnum dataModelPresetEnum = DataModelPresetEnum.getDataModelPreset((Long)id);
            if (dataModelPresetEnum != null && dataModelPresetEnum.getEntity() != null) {
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("source_app", "epm");
                params.put("datamodel", id);
                FormOpener.showForm((AbstractFormPlugin)this, (String)dataModelPresetEnum.getEntity(), (String)"", params, (String)"", (ShowType)ShowType.MainNewTabPage, (String)(dataModelPresetEnum.getEntity() + this.getView().getPageId()));
            } else {
                String json = this.getPageCache().get(MODEL_MAPPING_CACHE);
                if (!StringUtils.isEmpty((String)json) && json.startsWith("{") && json.endsWith("}")) {
                    JSONObject jObj = JSON.parseObject((String)json);
                    if (!jObj.isEmpty() && jObj.containsKey((Object)id)) {
                        DataModelListPlugin.openMainModel((Long)jObj.get((Object)id), (AbstractFormPlugin)this, false, "refresh_list");
                    } else {
                        DataModelListPlugin.openResourceEditor(id, (AbstractFormPlugin)this, false, "refresh_list");
                    }
                } else {
                    DataModelListPlugin.openResourceEditor(id, (AbstractFormPlugin)this, false, "refresh_list");
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("delete".equals(operateKey)) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            boolean hasPreset = false;
            for (Object pkid : primaryKeyValues) {
                DataModelPresetEnum dataModelPresetEnum = DataModelPresetEnum.getDataModelPreset((Long)((Long)pkid));
                if (dataModelPresetEnum == null) continue;
                hasPreset = true;
                break;
            }
            if (hasPreset) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u6a21\u578b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataModelListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operatename = formOperate.getOption().getVariableValue("operatename");
        Object[] primaryKeyValues = null;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("source_app", "epm");
        if ("select_type".equals(operateKey)) {
            params.put("group", ResourceTypeGroupEnum.DataModel.value());
            FormOpener.showForm((AbstractFormPlugin)this, (String)"epdm_dm_type_select", (String)"", params, (String)"select_resource");
        } else if ("frommetadata".equals(operateKey)) {
            params.putAll(CatalogUtil.getCatalogParam());
            FormOpener.showForm((AbstractFormPlugin)this, (String)"iscx_import_meta2resource", null, params, (String)"get_meta");
        } else if ("copy_model".equals(operateKey)) {
            Long id = this.getSelectedId();
            primaryKeyValues = new Object[]{id};
            if (id != null) {
                DataModelListPlugin.openResourceEditor(id, (AbstractFormPlugin)this, true, "refresh_list");
            }
        } else if ("reverse".equals(operateKey)) {
            String catalogId = this.getCatalogId();
            if (StringUtils.isNotEmpty((String)catalogId)) {
                params.put("catalog", IDUtils.toLong((Object)catalogId));
            }
            FormOpener.showForm((AbstractFormPlugin)this, (String)"epdm_dm_reverse", null, params, (String)"refresh_list");
        } else if ("topology".equals(operateKey)) {
            long id = this.getSelectedId();
            primaryKeyValues = new Object[]{id};
            this.showTopologyView(id);
        } else if ("show_history".equals(operateKey)) {
            Long selectedId = this.getSelectedId();
            primaryKeyValues = new Object[]{selectedId};
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("isc_res_history");
            param.setFormId("bos_list");
            QFilter qFilter = new QFilter("resid", "=", (Object)selectedId);
            param.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setHasRight(true);
            this.getView().showForm((FormShowParameter)param);
        } else if ("import".equals(operateKey)) {
            DataModelListPlugin.openImportForm((IFormPlugin)this, this.getView());
        } else if ("export".equals(operateKey) || "export_batch".equals(operateKey)) {
            primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        } else if ("delete".equals(operateKey)) {
            primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"DataModelListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), primaryKeyValues.length), "", MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
        }
        this.writeLog("epdm_dm", (IOperationTypeInfo)new OpCodeInfo(formOperate.getOperateKey(), operatename), primaryKeyValues);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("delete".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"iscx_resource", (Object[])primaryKeyValues, (OperateOption)option);
            ListView listView = (ListView)this.getView();
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataModelListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                listView.clearSelection();
                listView.refresh();
            } else {
                listView.showOperationResult(operationResult);
                List successPkIds = operationResult.getSuccessPkIds();
                if (!successPkIds.isEmpty()) {
                    listView.clearSelection();
                    listView.refresh();
                }
            }
        }
    }

    public static void openImportForm(IFormPlugin form, IFormView view) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("isc_dts_imp");
        showParameter.setCustomParam("entity", (Object)"iscx_resource");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack(form, "importschema"));
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"iscx_resource");
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u5bfc\u5165 - %s", (String)"DataModelListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dataEntityType.getDisplayName()));
        view.showForm((FormShowParameter)showParameter);
    }

    private Long getSelectedId() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DataModelListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (selectedRows.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DataModelListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }

    private void showTopologyView(long id) {
        if (id > 0L) {
            DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"iscx_resource");
            String type = res.getDynamicObject("type").getString("number");
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("type", type);
            params.put("id", id);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("iscx_topology_view");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setPageId("iscx_topology_view" + this.getView().getPageId() + id);
            formShowParameter.setCustomParams(params);
            formShowParameter.setHasRight(true);
            this.getView().showForm(formShowParameter);
        }
    }

    private static void openResourceEditor(long id, AbstractFormPlugin form, boolean isCopy, String callBack) {
        DynamicObject res = BusinessDataServiceHelper.loadSingle((Object)id, (String)"epdm_dm", (String)"type,dev_tenant,name");
        ResourceTypeEnum type = ResourceTypeEnum.get((String)res.getString("type.id"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("id", id);
        params.put("is_copy", isCopy);
        params.put("source_app", "epm");
        params.putAll(CatalogUtil.getCatalogParam());
        FormOpener.showForm((AbstractFormPlugin)form, (String)type.getEditFormId(), null, params, (String)callBack);
    }

    private static void openMainModel(long id, AbstractFormPlugin form, boolean enableEdit, String callBack) {
        HashMap<String, Constable> params = new HashMap<String, Constable>(16);
        params.put("id", Long.valueOf(id));
        params.put("enable_edit", Boolean.valueOf(enableEdit));
        FormOpener.showForm((AbstractFormPlugin)form, (String)EpdmDatamodelTableEnum.getFormId(), null, params, (String)callBack);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if ("select_resource".equals(e.getActionId())) {
            String formId = D.s((Object)returnData);
            if (formId != null) {
                HashMap<String, String> params = new HashMap<String, String>(16);
                params.put("catalog", this.getCatalogId());
                params.put("source_app", "epm");
                params.putAll(CatalogUtil.getCatalogParam());
                FormOpener.showForm((AbstractFormPlugin)this, (String)formId, null, params, (String)"refresh_list");
            }
        } else if ("get_meta".equals(e.getActionId())) {
            if (returnData instanceof Map) {
                ImportMetaToIscxResourceHelper.showImportModel((Map)((Map)returnData), (AbstractFormPlugin)this, (String)"refresh_list");
            }
        } else if ("refresh_list".equals(e.getActionId()) && returnData instanceof Map) {
            Map data = (Map)returnData;
            String msg = (String)data.get("msg");
            if (D.l(data.get("id")) > 0L) {
                this.getView().invokeOperation("refresh");
                if (data.containsKey("saveSuccess")) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataModelListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
            } else if (msg != null && msg.contains("success")) {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    protected String getCatalogId() {
        return this.getView().getPageCache().get("catalogId");
    }
}

