/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OpCodeInfo;
import kd.epm.epbs.common.util.AppUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetFormHepler;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.enums.DataModelPresetFieldTypeEnum;
import kd.epm.epdm.common.enums.DataModelPresetLabelEnum;
import kd.epm.epdm.common.enums.DataModelRefTypeEnum;

public class DataModelPresetFromPlugin
extends AbstractBaseListPlugin {
    private static final String EPDM_DATAMODEL_PRESET = "epdm_dm_preset";
    private static final String DIM_FROM_VOUCHER = "dim_from_voucher";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"title_ref", "line_ref", "it_ref"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("sys", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e", (String)"DataModelPresetFromPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        Object datamodel = this.getView().getFormShowParameter().getCustomParam("datamodel");
        if (datamodel != null) {
            this.getModel().setValue("datamodel", datamodel);
            this.initData();
        }
    }

    private void initData() {
        Object datamodel = this.getView().getFormShowParameter().getCustomParam("datamodel");
        String selectFields = "id,type,field,content,datatype,ref,remark,label,creater,createtime,modifier,modifytime,dseq,reftype,reffield,ispreset,showfields";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)EPDM_DATAMODEL_PRESET, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("datamodel", "=", datamodel)}, (String)"dseq");
        DynamicObjectCollection titleList = new DynamicObjectCollection();
        DynamicObjectCollection lineList = new DynamicObjectCollection();
        DynamicObjectCollection itList = new DynamicObjectCollection();
        HashMap<String, Set<String>> refMap = new HashMap<String, Set<String>>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String type = dynamicObject.getString("type");
            if (DataModelPresetFieldTypeEnum.Title.name().equals(type)) {
                titleList.add((Object)dynamicObject);
            } else if (DataModelPresetFieldTypeEnum.Line.name().equals(type)) {
                lineList.add((Object)dynamicObject);
            } else {
                itList.add((Object)dynamicObject);
            }
            String reftype = dynamicObject.getString("reftype");
            if (StringUtils.isEmpty((String)reftype)) continue;
            Set set = refMap.computeIfAbsent(reftype, k -> new HashSet(16));
            set.add(dynamicObject.getString("ref"));
        }
        Map<String, String> refIdNameMap = this.queryRefIdNameMap(refMap);
        HashMap<String, List<Integer>> fieldTypeListMap = new HashMap<String, List<Integer>>(16);
        this.initList(titleList, DataModelPresetFieldTypeEnum.Title, refIdNameMap, fieldTypeListMap);
        this.initList(lineList, DataModelPresetFieldTypeEnum.Line, refIdNameMap, fieldTypeListMap);
        this.initList(itList, DataModelPresetFieldTypeEnum.IT, refIdNameMap, fieldTypeListMap);
        this.getView().getPageCache().put("fieldTypeListMap", SerializationUtils.toJsonString(fieldTypeListMap));
    }

    private void initList(DynamicObjectCollection list, DataModelPresetFieldTypeEnum fieldType, Map<String, String> refIdNameMap, Map<String, List<Integer>> fieldTypeListMap) {
        String fieldTypeName = fieldType.name();
        String entryKey = fieldTypeName + "_list";
        this.getModel().deleteEntryData(entryKey);
        if (list.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        DynamicObject model = (DynamicObject)this.getModel().getValue("datamodel");
        boolean isBalanceDim = DataModelPresetFieldTypeEnum.Title == fieldType && DataModelPresetEnum.T_EPM_BALANCE.getId().longValue() == model.getLong("id");
        int[] rows = this.getModel().batchCreateNewEntryRow(entryKey, list.size());
        ArrayList<Integer> rockRow = new ArrayList<Integer>(10);
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            DynamicObject entryRowEntity = dataModel.getEntryRowEntity(entryKey, row);
            DynamicObject dynamicObject = (DynamicObject)list.get(i);
            if (dynamicObject.getBoolean("ispreset") || isBalanceDim) {
                rockRow.add(row);
            }
            entryRowEntity.set(fieldTypeName + "_preset", dynamicObject.get("ispreset"));
            String field = dynamicObject.getString("field");
            this.setFieldIndex(field, fieldTypeListMap, false);
            entryRowEntity.set(fieldTypeName + "_isnew", (Object)false);
            entryRowEntity.set(fieldTypeName + "_field", (Object)field);
            entryRowEntity.set(fieldTypeName + "_content", dynamicObject.get("content"));
            entryRowEntity.set(fieldTypeName + "_datatype", dynamicObject.get("datatype"));
            String ref = dynamicObject.getString("ref");
            entryRowEntity.set(fieldTypeName + "_ref", (Object)refIdNameMap.get(ref));
            entryRowEntity.set(fieldTypeName + "_reftype", dynamicObject.get("reftype"));
            entryRowEntity.set(fieldTypeName + "_refid", (Object)ref);
            entryRowEntity.set(fieldTypeName + "_reffield", dynamicObject.get("reffield"));
            entryRowEntity.set(fieldTypeName + "_showfields", dynamicObject.get("showfields"));
            entryRowEntity.set(fieldTypeName + "_label", dynamicObject.get("label"));
            entryRowEntity.set(fieldTypeName + "_remark", dynamicObject.get("remark"));
            dataModel.setValue(fieldTypeName + "_creater", dynamicObject.get("creater"), row);
            entryRowEntity.set(fieldTypeName + "_createtime", dynamicObject.get("createtime"));
            entryRowEntity.set(fieldTypeName + "_pk", (Object)dynamicObject.getLong("id"));
        }
        for (Integer i : rockRow) {
            this.getView().setEnable(Boolean.valueOf(false), i.intValue(), new String[]{fieldTypeName + "_content", fieldTypeName + "_remark"});
        }
        Object object = rows;
        int n = ((Object)object).length;
        for (int i = 0; i < n; ++i) {
            Integer i2 = (int)object[i];
            this.getView().setEnable(Boolean.valueOf(false), i2.intValue(), new String[]{fieldTypeName + "_datatype", fieldTypeName + "_label"});
        }
        this.getView().updateView(entryKey);
    }

    private void setFieldIndex(String field, Map<String, List<Integer>> fieldTypeListMap, boolean isRemove) {
        String type;
        if (field.startsWith("fdim")) {
            type = "fdim";
        } else if (field.startsWith("fhdim")) {
            type = "fhdim";
        } else if (field.startsWith("fattribute")) {
            type = "fattribute";
        } else if (field.startsWith("fcount")) {
            type = "fcount";
        } else {
            return;
        }
        List fdimList = fieldTypeListMap.computeIfAbsent(type, e -> new ArrayList(10));
        Integer fdim = Integer.parseInt(field.replace(type, ""));
        if (isRemove) {
            fdimList.remove(fdim);
        } else {
            fdimList.add(fdim);
        }
    }

    private Map<String, List<Integer>> getfieldTypeListMap() {
        String str = this.getView().getPageCache().get("fieldTypeListMap");
        if (StringUtils.isNotEmpty((String)str)) {
            return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return new HashMap<String, List<Integer>>(16);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("title_ref".equals(propName) || "line_ref".equals(propName) || "it_ref".equals(propName)) {
            String type = propName.split("_")[0];
            int rowIndex = changeData.getRowIndex();
            if (StringUtils.isEmpty((String)((String)changeData.getNewValue()))) {
                this.getModel().setValue(type + "_refid", null, rowIndex);
                this.getModel().setValue(type + "_reffield", null, rowIndex);
                this.getModel().setValue(type + "_reftype", null, rowIndex);
            }
        } else if ("title_label".equals(propName) || "line_label".equals(propName) || "it_label".equals(propName)) {
            int rowIndex;
            String label;
            String type = propName.split("_")[0];
            if (!this.setFieldName(type, label = (String)changeData.getNewValue(), rowIndex = changeData.getRowIndex())) {
                this.getModel().setValue(propName, changeData.getOldValue(), rowIndex);
            }
            this.initNewRow(type, label, rowIndex);
        }
    }

    private void initNewRow(String type, String label, int row) {
        if (DataModelPresetLabelEnum.SYS.getValue().equals(label) || DataModelPresetLabelEnum.DIM.getValue().equals(label)) {
            this.getModel().setValue(type + "_datatype", (Object)"varchar", row);
        } else if (DataModelPresetLabelEnum.METRIC.getValue().equals(label)) {
            this.getModel().setValue(type + "_datatype", (Object)"decimal", row);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "title_ref": 
            case "line_ref": 
            case "it_ref": {
                String entry = key.replace("_ref", "");
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setFormId("epdm_dm_ref");
                formShowParameter.setCustomParam("refid", this.getModel().getValue(entry + "_refid"));
                formShowParameter.setCustomParam("reffield", this.getModel().getValue(entry + "_reffield"));
                formShowParameter.setCustomParam("reftype", this.getModel().getValue(entry + "_reftype"));
                formShowParameter.setCustomParam("showfields", this.getModel().getValue(entry + "_showfields"));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "title_ref": 
            case "line_ref": 
            case "it_ref": {
                int[] selectRows;
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) break;
                String type = actionId.replace("_ref", "");
                EntryGrid entryGrid = (EntryGrid)this.getControl(type + "_list");
                for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                    this.getModel().setValue(type + "_ref", returnData.get("name"), selectRow);
                    this.getModel().setValue(type + "_refid", returnData.get("id"), selectRow);
                    this.getModel().setValue(type + "_reffield", returnData.get("field"), selectRow);
                    this.getModel().setValue(type + "_reftype", returnData.get("type"), selectRow);
                    this.getModel().setValue(type + "_showfields", returnData.get("showfields"), selectRow);
                }
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)AppUtils.getAppPkId((IFormView)this.getView()), (String)EPDM_DATAMODEL_PRESET, (String)"4715a0df000000ac");
            if (!permission) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u9884\u7f6e\u6a21\u578b\u7684\u4fee\u6539\u6743\u9650\u3002", (String)"DataModelPresetFromPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (operateKey.contains("deleteentry_")) {
            String type = operateKey.split("_")[1];
            EntryGrid entryGrid = (EntryGrid)this.getControl(type + "_list");
            int[] selectRows = entryGrid.getSelectRows();
            boolean hasPreset = false;
            boolean hasSave = false;
            for (int selectRow : selectRows) {
                if (D.x((Object)this.getModel().getValue(type + "_preset", selectRow))) {
                    hasPreset = true;
                    continue;
                }
                if (D.x((Object)this.getModel().getValue(type + "_isnew", selectRow))) continue;
                hasSave = true;
            }
            if (hasPreset) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataModelPresetFromPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else if (hasSave) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6548\u5b57\u6bb5\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DataModelPresetFromPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.deleteField(type);
                args.setCancel(true);
            }
        } else if (operateKey.contains("copyentryrow_")) {
            // empty if block
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (callBackId.contains("deleteentry_") && result == MessageBoxResult.Yes) {
            String type = callBackId.replace("deleteentry_", "");
            this.deleteField(type);
        }
    }

    private void deleteField(String type) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(type + "_list");
        int[] selectRows = entryGrid.getSelectRows();
        Map<String, List<Integer>> fieldTypeListMap = this.getfieldTypeListMap();
        for (int selectRow : selectRows) {
            String _field = (String)this.getModel().getValue(type + "_field", selectRow);
            this.setFieldIndex(_field, fieldTypeListMap, true);
        }
        this.getView().getPageCache().put("fieldTypeListMap", SerializationUtils.toJsonString(fieldTypeListMap));
        this.getModel().deleteEntryRows(entryGrid.getKey(), selectRows);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("save".equals(operateKey) && operationResult.isSuccess()) {
            DynamicObjectCollection titleList = this.getModel().getEntryEntity("title_list");
            DynamicObjectCollection lineList = this.getModel().getEntryEntity("line_list");
            DynamicObjectCollection itList = this.getModel().getEntryEntity("it_list");
            DynamicObjectCollection dynamicObjects = this.buildFiledDy(titleList, DataModelPresetFieldTypeEnum.Title);
            dynamicObjects.addAll((Collection)this.buildFiledDy(lineList, DataModelPresetFieldTypeEnum.Line));
            dynamicObjects.addAll((Collection)this.buildFiledDy(itList, DataModelPresetFieldTypeEnum.IT));
            DynamicObject datamodel = (DynamicObject)this.getModel().getValue("datamodel");
            long fid = datamodel.getLong("id");
            QFilter qFilter = new QFilter("datamodel", "=", (Object)fid);
            TXUtils.required(tx -> {
                DeleteServiceHelper.delete((String)EPDM_DATAMODEL_PRESET, (QFilter[])qFilter.toArray());
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])dynamicObjects.toArray((Object[])new DynamicObject[0])));
                List fields = dynamicObjects.stream().map(o -> {
                    HashMap<String, String> field = new HashMap<String, String>(16);
                    field.put("is_private", "0");
                    field.put("is_primary_key", "0");
                    field.put("field", o.getString("field"));
                    field.put("label", o.getString("content"));
                    field.put("is_required", "0");
                    field.put("data_type", o.getString("datatype"));
                    return field;
                }).collect(Collectors.toList());
                TXUtils.requiresNew((String)"isc.updateTableModel", tx2 -> {
                    try {
                        Map resultMap = DataModelPresetFormHepler.updateTableModel((long)fid, (List)fields);
                        if (resultMap.get("id") == null) {
                            throw new KDBizException(resultMap.get("msg").toString());
                        }
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DataModelPresetFromPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        this.initData();
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                });
            });
            this.initData();
            FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
            String operatename = formOperate.getOption().getVariableValue("operatename");
            this.getPageCache().remove(DIM_FROM_VOUCHER);
            this.writeLog((IOperationTypeInfo)new OpCodeInfo(operateKey, operatename), OperationMsgUtil.getSaveSucTipWithNumber((String)datamodel.getString("number")));
        } else if ("refresh".equals(operateKey)) {
            this.initData();
            String dimsFromVoucher = this.getPageCache().get(DIM_FROM_VOUCHER);
            if (dimsFromVoucher != null) {
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)ObjectSerialUtil.deSerializedBytes((String)dimsFromVoucher);
                this.fillDims(dynamicObjects);
                this.getView().updateView();
            }
        } else if (operateKey.contains("copyentryrow_")) {
            String type = operateKey.replace("copyentryrow_", "");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(type + "_list");
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                String field = dynamicObject.getString(type + "_field");
                if (!StringUtils.isEmpty((String)field)) continue;
                String label = dynamicObject.getString(type + "_label");
                String number = ((DynamicObject)this.getModel().getValue("datamodel")).getString("number");
                if (DataModelPresetEnum.T_EPM_VOUCHER.getNumber().equals(number) && "line".equals(type) && "1".equals(label)) {
                    this.getModel().setValue(type + "_label", null, i);
                }
                this.setFieldName(type, dynamicObject.getString(type + "_label"), i);
            }
        } else if (operateKey.contains("newentry_")) {
            int[] selectRows;
            String type = operateKey.replace("newentry_", "");
            String entry = type + "_list";
            EntryGrid entryGrid = (EntryGrid)this.getControl(entry);
            for (int selectRow : selectRows = entryGrid.getSelectRows()) {
                if (!this.setFieldName(type, (String)this.getModel().getValue(type + "_label", selectRow), selectRow)) {
                    this.getModel().deleteEntryRows(entry, selectRows);
                    continue;
                }
                this.initNewRow(type, (String)this.getModel().getValue(type + "_label"), selectRow);
            }
        } else if ("btn_dimcopy".equals(operateKey)) {
            DynamicObjectCollection dynamicObjects = DataModelPresetHelper.queryVoucherDim();
            this.fillDims(dynamicObjects);
            this.getPageCache().put(DIM_FROM_VOUCHER, ObjectSerialUtil.toByteSerialized((Object)dynamicObjects));
        }
    }

    private void fillDims(DynamicObjectCollection dynamicObjects) {
        Map<String, DynamicObject> fieldDynMap = dynamicObjects.stream().collect(Collectors.toMap(dy -> dy.getString("field"), dy -> dy, (v1, v2) -> v1));
        HashMap<String, Set<String>> refMap = new HashMap<String, Set<String>>(16);
        fieldDynMap.forEach((k, v) -> {
            String refType = v.getString("reftype");
            if (!StringUtils.isEmpty((String)refType)) {
                Set set = refMap.computeIfAbsent(refType, key -> new HashSet(16));
                set.add(v.getString("ref"));
            }
        });
        Map<String, String> refIdNameMap = this.queryRefIdNameMap(refMap);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("title_list");
        for (DynamicObject dynamicObject : entryEntity) {
            String string = dynamicObject.getString("title_field");
            DynamicObject dyn = fieldDynMap.remove(string);
            if (dyn == null) continue;
            int rowIndex = dynamicObject.getInt("seq") - 1;
            String refId = dyn.getString("ref");
            String titleRef = refIdNameMap.get(refId);
            this.getModel().setValue("title_ref", (Object)titleRef, rowIndex);
            this.getModel().setValue("title_refid", (Object)refId, rowIndex);
            this.fillRowByDyn(dyn, rowIndex);
        }
        fieldDynMap.keySet().stream().sorted().forEach(key -> {
            DynamicObject dyn = (DynamicObject)fieldDynMap.get(key);
            int rowIndex = this.getModel().createNewEntryRow("title_list");
            String refId = dyn.getString("ref");
            String titleRef = (String)refIdNameMap.get(refId);
            this.getModel().setValue("title_field", key, rowIndex);
            this.getModel().setValue("title_isnew", (Object)true, rowIndex);
            this.getModel().setValue("title_preset", (Object)false, rowIndex);
            this.getModel().setValue("title_ref", (Object)titleRef, rowIndex);
            this.getModel().setValue("title_refid", (Object)refId, rowIndex);
            this.getModel().setValue("title_label", (Object)DataModelPresetLabelEnum.DIM.getValue(), rowIndex);
            this.fillRowByDyn(dyn, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"title_content", "title_label"});
        });
    }

    private void fillRowByDyn(DynamicObject dyn, int rowIndex) {
        this.getModel().setValue("title_content", dyn.get("content"), rowIndex);
        this.getModel().setValue("title_datatype", dyn.get("datatype"), rowIndex);
        this.getModel().setValue("title_remark", dyn.get("remark"), rowIndex);
        this.getModel().setValue("title_reftype", dyn.get("reftype"), rowIndex);
        this.getModel().setValue("title_reffield", dyn.get("reffield"), rowIndex);
        this.getModel().setValue("title_showfields", dyn.get("showfields"), rowIndex);
    }

    private Map<String, String> queryRefIdNameMap(Map<String, Set<String>> refMap) {
        HashMap<String, String> refIdNameMap = new HashMap<String, String>(refMap.size());
        for (Map.Entry<String, Set<String>> entry : refMap.entrySet()) {
            DataModelRefTypeEnum dataModelRefTypeEnum = DataModelRefTypeEnum.valueOf((String)entry.getKey());
            QFilter qFilter = DataModelRefTypeEnum.Entityobject != dataModelRefTypeEnum ? new QFilter("id", "in", entry.getValue().stream().map(Long::parseLong).collect(Collectors.toSet())) : new QFilter("id", "in", entry.getValue());
            DynamicObjectCollection refObjs = QueryServiceHelper.query((String)dataModelRefTypeEnum.getEntity(), (String)"id,name", (QFilter[])qFilter.toArray());
            refIdNameMap.putAll(refObjs.stream().collect(Collectors.toMap(o -> o.getString("id"), o -> o.getString("name"))));
        }
        return refIdNameMap;
    }

    private DynamicObjectCollection buildFiledDy(DynamicObjectCollection list, DataModelPresetFieldTypeEnum fieldType) {
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        Object datamodel = this.getModel().getValue("datamodel");
        String fieldTypeName = fieldType.name();
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject viewObject = (DynamicObject)list.get(i);
            Boolean preset = (Boolean)viewObject.get(fieldTypeName + "_preset");
            String field = viewObject.getString(fieldTypeName + "_field");
            String label = viewObject.getString(fieldTypeName + "_label");
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)EPDM_DATAMODEL_PRESET);
            dynamicObject.set("datamodel", datamodel);
            dynamicObject.set("type", (Object)fieldTypeName);
            dynamicObject.set("field", (Object)field);
            dynamicObject.set("content", viewObject.get(fieldTypeName + "_content"));
            dynamicObject.set("datatype", viewObject.get(fieldTypeName + "_datatype"));
            dynamicObject.set("reftype", viewObject.get(fieldTypeName + "_reftype"));
            dynamicObject.set("ref", viewObject.get(fieldTypeName + "_refid"));
            dynamicObject.set("reffield", viewObject.get(fieldTypeName + "_reffield"));
            dynamicObject.set("showfields", viewObject.get(fieldTypeName + "_showfields"));
            dynamicObject.set("ispreset", (Object)preset);
            dynamicObject.set("label", (Object)label);
            dynamicObject.set("remark", viewObject.get(fieldTypeName + "_remark"));
            Long userId = UserUtils.getUserId();
            Date now = TimeServiceHelper.now();
            boolean isnew = viewObject.getBoolean(fieldTypeName + "_isnew");
            if (isnew) {
                dynamicObject.set("creater", (Object)userId);
                dynamicObject.set("createtime", (Object)now);
            } else {
                dynamicObject.set("creater", viewObject.get(fieldTypeName + "_creater"));
                dynamicObject.set("createtime", viewObject.get(fieldTypeName + "_createtime"));
                dynamicObject.set("id", viewObject.get(fieldTypeName + "_pk"));
            }
            dynamicObject.set("modifier", (Object)userId);
            dynamicObject.set("modifytime", (Object)now);
            dynamicObject.set("dseq", (Object)i);
            dynamicObjects.add((Object)dynamicObject);
        }
        return dynamicObjects;
    }

    private boolean setFieldName(String type, String label, int row) {
        if (label == null) {
            return true;
        }
        try {
            Map<String, List<Integer>> fieldTypeListMap = this.getfieldTypeListMap();
            String field = this.getFieldName(fieldTypeListMap, label, type);
            this.getModel().setValue(type + "_field", (Object)field, row);
            this.getView().getPageCache().put("fieldTypeListMap", SerializationUtils.toJsonString(fieldTypeListMap));
            return true;
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return false;
        }
    }

    private String getFieldName(Map<String, List<Integer>> fieldTypeListMap, String label, String type) {
        String number = ((DynamicObject)this.getModel().getValue("datamodel")).getString("number");
        String field = "";
        if (DataModelPresetEnum.T_EPM_VOUCHER.getNumber().equals(number)) {
            if (DataModelPresetLabelEnum.SYS.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fattribute", 20);
            } else if (DataModelPresetLabelEnum.DIM.getValue().equals(label) && DataModelPresetFieldTypeEnum.Title.name().equalsIgnoreCase(type)) {
                field = this.getFieldName(fieldTypeListMap, "fhdim", 10);
            } else if (DataModelPresetLabelEnum.DIM.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fdim", 100);
            } else if (DataModelPresetLabelEnum.METRIC.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fcount", 20);
            }
        } else if (DataModelPresetEnum.T_EPM_BALANCE.getNumber().equals(number)) {
            if (DataModelPresetLabelEnum.SYS.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fattribute", 20);
            } else if (DataModelPresetLabelEnum.DIM.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fdim", 100);
            } else if (DataModelPresetLabelEnum.METRIC.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fcount", 20);
            }
        } else if (DataModelPresetEnum.T_EPM_CASHFLOW.getNumber().equals(number)) {
            if (DataModelPresetLabelEnum.SYS.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fattribute", 10);
            } else if (DataModelPresetLabelEnum.DIM.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fdim", 100);
            } else if (DataModelPresetLabelEnum.METRIC.getValue().equals(label)) {
                field = this.getFieldName(fieldTypeListMap, "fcount", 10);
            }
        }
        return field;
    }

    private String getFieldName(Map<String, List<Integer>> fieldTypeListMap, String type, int max) {
        List fieldTypeList = fieldTypeListMap.computeIfAbsent(type, e -> new ArrayList(10));
        int nextValue = this.findNextValue(fieldTypeList, max);
        fieldTypeList.add(nextValue);
        return type + nextValue;
    }

    private int findNextValue(List<Integer> list, int max) {
        int maxValue = 0;
        for (int value : list) {
            if (value <= maxValue) continue;
            maxValue = value;
        }
        if (maxValue < max) {
            return maxValue + 1;
        }
        HashSet<Integer> availableValues = new HashSet<Integer>(16);
        for (int i = 1; i <= max; ++i) {
            availableValues.add(i);
        }
        for (int value : list) {
            availableValues.remove(value);
        }
        if (!availableValues.isEmpty()) {
            return (Integer)availableValues.iterator().next();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u53ef\u6269\u5c55\u7684\u5b57\u6bb5\u6570\u6570\u91cf\u5df2\u6ee1\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DataModelPresetFromPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
    }
}

