/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.datamodel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.GlobalIdUtil;
import kd.epm.epdm.business.datamodel.helper.DataModelServiceHelper;
import kd.epm.epdm.common.enums.DataModelRefTypeEnum;

public class DataModelRefFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String refid = (String)customParams.get("refid");
        String reftype = (String)customParams.get("reftype");
        if (StringUtils.isNotEmpty((String)reftype) && StringUtils.isNotEmpty((String)refid)) {
            this.getModel().setValue(reftype, (Object)refid);
            this.getModel().setValue("reftype", (Object)reftype);
            if (DataModelRefTypeEnum.Enum.name().equals(reftype)) {
                QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(refid));
                if (QueryServiceHelper.exists((String)DataModelRefTypeEnum.Enum.getEntity(), (QFilter[])new QFilter[]{filter})) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(refid), (String)DataModelRefTypeEnum.Enum.getEntity());
                    this.getModel().setValue("name", dynamicObject.get("name"));
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                    if (!dynamicObjectCollection.isEmpty()) {
                        this.getModel().batchCreateNewEntryRow("enumentryentity", dynamicObjectCollection.size());
                        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("enumentryentity");
                        for (int i = 0; i < entryEntity.size(); ++i) {
                            DynamicObject dynamicObject1 = (DynamicObject)dynamicObjectCollection.get(i);
                            DynamicObject row = (DynamicObject)entryEntity.get(i);
                            row.set("enumnumber", dynamicObject1.get("enumnumber"));
                            row.set("enumname", dynamicObject1.get("enumname"));
                        }
                    }
                }
            } else {
                List showfields;
                this.initRefNumberName();
                String showfieldStr = (String)customParams.get("showfields");
                this.getModel().deleteEntryData("entryentity");
                if (StringUtils.isNotEmpty((String)showfieldStr) && !(showfields = JSONArray.parseArray((String)showfieldStr, String.class)).isEmpty()) {
                    this.getModel().batchCreateNewEntryRow("entryentity", showfields.size());
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    for (int i = 0; i < showfields.size(); ++i) {
                        DynamicObject row0 = (DynamicObject)entryEntity.get(i);
                        String showfield = (String)showfields.get(i);
                        row0.set("shownumber", (Object)showfield);
                        if (DataModelRefTypeEnum.Datamodel.name().equals(reftype)) continue;
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"shownumber"});
                    }
                    this.getView().updateView("entryentity");
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "entityobject": 
            case "assistantdata": 
            case "datamodel": {
                try {
                    this.initRefNumberName();
                }
                catch (Exception ex) {
                    this.getView().showTipNotification(ex.getMessage());
                    this.getModel().setValue(name, changeData.getOldValue());
                }
                break;
            }
            case "reftype": {
                this.initRefNumberName();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initRefNumberName() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        ArrayList<ComboItem> showItemList = new ArrayList<ComboItem>(10);
        this.getModel().deleteEntryData("entryentity");
        String numberProperty = "number";
        String nameProperty = "name";
        LocaleString numberPlayName = new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"DataModelRefFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        LocaleString namePlayName = new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"DataModelRefFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        String refType = (String)this.getModel().getValue("reftype");
        if (DataModelRefTypeEnum.Entityobject.name().equals(refType)) {
            MainEntityType dataEntityType;
            DynamicObject entityobject = (DynamicObject)this.getModel().getValue(refType);
            if (entityobject != null && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityobject.getString("id"))) instanceof BasedataEntityType) {
                numberProperty = ((BasedataEntityType)dataEntityType).getNumberProperty();
                if (!StringUtils.isNotEmpty((String)numberProperty)) throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u57fa\u7840\u8d44\u6599\u6ca1\u6709\u7f16\u7801\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u3002", (String)"DataModelRefFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), dataEntityType.getDisplayName()));
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                for (Object entityProperty : properties) {
                    if (!entityProperty.getName().equals(numberProperty)) continue;
                    numberPlayName = entityProperty.getDisplayName();
                    break;
                }
                ComboItem comboItem = new ComboItem(new LocaleString(String.format("%s:%s", numberProperty, numberPlayName.getLocaleValue())), numberProperty);
                showItemList.add(comboItem);
                comboItemList.add(comboItem);
                nameProperty = ((BasedataEntityType)dataEntityType).getNameProperty();
                if (StringUtils.isNotEmpty((String)nameProperty)) {
                    for (IDataEntityProperty entityProperty : properties) {
                        if (!entityProperty.getName().equals(nameProperty)) continue;
                        namePlayName = entityProperty.getDisplayName();
                        break;
                    }
                    showItemList.add(new ComboItem(new LocaleString(String.format("%s:%s", nameProperty, namePlayName.getLocaleValue())), nameProperty));
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"field"});
            }
        } else if (DataModelRefTypeEnum.Assistantdata.name().equals(refType)) {
            if (this.getModel().getValue(refType) != null) {
                ComboItem comboItem = new ComboItem(new LocaleString(String.format("%s:%s", numberProperty, numberPlayName.getLocaleValue())), numberProperty);
                comboItemList.add(comboItem);
                showItemList.add(comboItem);
                showItemList.add(new ComboItem(new LocaleString(String.format("%s:%s", nameProperty, namePlayName.getLocaleValue())), nameProperty));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"field"});
            }
        } else {
            if (!DataModelRefTypeEnum.Datamodel.name().equals(refType)) return;
            Long datamodelId = (Long)this.getModel().getValue("datamodel_id");
            if (datamodelId != 0L) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"epdm_dm", (String)"id,details_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)datamodelId)});
                JSONArray jsonArray = DataModelServiceHelper.get().getDataModelFields(dynamicObject);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject fieldObj = (JSONObject)jsonArray.get(i);
                    ComboItem comboItem = new ComboItem(new LocaleString(String.format("%s:%s", fieldObj.getString("field"), fieldObj.getString("label"))), fieldObj.getString("field"));
                    showItemList.add(comboItem);
                    comboItemList.add(comboItem);
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"field"});
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("field");
        comboEdit.setComboItems(comboItemList);
        if (!comboItemList.isEmpty()) {
            this.getModel().setValue("field", (Object)((ComboItem)comboItemList.get(0)).getValue());
        }
        ComboEdit shownumber = (ComboEdit)this.getControl("shownumber");
        shownumber.setComboItems(showItemList);
        if (showItemList.isEmpty()) return;
        int rowCount = Math.min(showItemList.size(), 2);
        this.getModel().batchCreateNewEntryRow("entryentity", rowCount);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject row0 = (DynamicObject)entryEntity.get(i);
            ComboItem comboItem = (ComboItem)showItemList.get(i);
            row0.set("shownumber", (Object)comboItem.getValue());
            if (DataModelRefTypeEnum.Datamodel.name().equals(refType)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"shownumber"});
        }
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        if ("ok".equals(operateKey)) {
            String reftype = (String)this.getModel().getValue("reftype");
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("type", reftype);
            data.put("field", this.getModel().getValue("field"));
            if (DataModelRefTypeEnum.Enum.name().equals(reftype)) {
                DynamicObject enumObj = (DynamicObject)this.getModel().getValue(reftype);
                if (enumObj == null) {
                    enumObj = BusinessDataServiceHelper.newDynamicObject((String)"epdm_dm_ref_enum");
                    long id = GlobalIdUtil.genGlobalLongId();
                    enumObj.set("id", (Object)id);
                    enumObj.set("number", (Object)GlobalIdUtil.genStringId());
                    enumObj.set("name", this.getModel().getValue("name"));
                } else {
                    enumObj = BusinessDataServiceHelper.loadSingle((Object)enumObj.getLong("id"), (String)"epdm_dm_ref_enum");
                }
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("enumentryentity");
                DynamicObjectCollection dynamicObjectCollection = enumObj.getDynamicObjectCollection("entryentity");
                dynamicObjectCollection.clear();
                HashSet<String> numberSet = new HashSet<String>(16);
                for (DynamicObject dynamicObject : entryEntity) {
                    DynamicObject enumItem = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
                    String enumnumber = dynamicObject.getString("enumnumber");
                    if (!numberSet.add(enumnumber)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"DataModelRefFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    enumItem.set("enumnumber", dynamicObject.get("enumnumber"));
                    enumItem.set("enumname", dynamicObject.get("enumname"));
                    enumItem.set("seq", dynamicObject.get("seq"));
                    dynamicObjectCollection.add((Object)enumItem);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{enumObj});
                data.remove("field");
                data.put("id", enumObj.getLong("id"));
                data.put("name", this.getModel().getValue("name"));
            } else {
                data.put("id", this.getModel().getValue(reftype + "_id"));
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                List showfields = entryEntity.stream().map(o -> o.getString("shownumber")).collect(Collectors.toList());
                data.put("showfields", JSONArray.toJSONString(showfields));
                data.put("name", ((DynamicObject)this.getModel().getValue(reftype)).get("name"));
            }
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }
}

