/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.datamodel;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import kd.epm.epdm.formplugin.datamodel.CatalogF7SelectListener;

public class DataModelReverseFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CatalogF7SelectListener listener = new CatalogF7SelectListener(this, ResourceTypeEnum.DataEntity.getNumber());
        BasedataEdit catalogF7 = (BasedataEdit)this.getView().getControl("catalog");
        if (catalogF7 != null) {
            catalogF7.addBeforeF7SelectListener((BeforeF7SelectListener)listener);
        }
        BasedataEdit databaselinkF7 = (BasedataEdit)this.getView().getControl("databaselink");
        databaselinkF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("tip", (Object)ResManager.loadKDString((String)"\u6ce8\u610f\u4e8b\u9879\uff1a\u9006\u5411\u5de5\u7a0b\u4ec5\u652f\u6301\u6307\u5b9a\u6570\u636e\u6e90/\u6570\u636e\u8868\u4ece\u6570\u636e\u6e90\u4e2d\u52a0\u8f7d\u5bf9\u5e94\u5143\u6570\u636e\u81f3\u6570\u636e\u6a21\u578b\u5217\u8868\u4e2d\uff0c\u5982\u60a8\u9700\u8981\u5bf9\u539f\u6570\u636e\u8868\u8fdb\u884c\u4fee\u6539(\u5982\u6307\u5b9a\u6570\u636e\u8868\u7684\u9690\u79c1\u5b57\u6bb5\u7b49)\uff0c\u8bf7\u5728\u53cd\u5411\u5efa\u6a21\u5b8c\u6210\u540e\uff0c\u5728\u6570\u636e\u6a21\u578b\u5217\u8868\u6253\u5f00\u5bf9\u5e94\u7684\u6a21\u578b\u8fdb\u884c\u4fee\u6539\u3002", (String)"DataModelReverseFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        Object catalog = this.getView().getFormShowParameter().getCustomParam("catalog");
        this.getModel().setValue("catalog", catalog);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        if ("ok".equals(operateKey)) {
            Long catalogId = (Long)this.getModel().getValue("catalog_id");
            String table = (String)this.getModel().getValue("table");
            String[] tables = table.split(",");
            DynamicObject cataLogDy = BusinessDataServiceHelper.loadSingle((Object)catalogId, (String)"iscx_catalog", (String)"number");
            String cataLogNumber = cataLogDy.getString("number");
            for (String tableName : tables) {
                DataModelPresetEnum dataModelPresetEnum = DataModelPresetEnum.getDataModelPreset((String)tableName, (String)cataLogNumber);
                if (dataModelPresetEnum == null) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8868%s\u4e0d\u5141\u8bb8\u751f\u6210\u6570\u636e\u6a21\u578b\u3002", (String)"DataModelReverseFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), tableName));
                return;
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epdm_dm", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)tables), new QFilter("type", "=", (Object)ResourceTypeEnum.DataTable.getNumber())});
            List existNumbers = dynamicObjects.stream().map(o -> o.getString("number")).collect(Collectors.toList());
            if (!existNumbers.isEmpty()) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btnok", (IFormPlugin)this);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u96c6\u4e0b\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a\uff1a%s\u7684\u6570\u636e\u6a21\u578b\uff0c\u6b64\u64cd\u4f5c\u4f1a\u5c06\u6240\u586b\u6570\u636e\u8868\u7684\u6700\u65b0\u8868\u7ed3\u6784\u8986\u76d6\u5230\u5bf9\u5e94\u6570\u636e\u6a21\u578b\u4e2d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u66f4\u65b0\u8986\u76d6", (String)"DataModelReverseFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001", existNumbers)), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.save();
            }
        }
    }

    private void save() {
        Long databaselinkId = (Long)this.getModel().getValue("databaselink_id");
        Long catalogId = (Long)this.getModel().getValue("catalog_id");
        String table = (String)this.getModel().getValue("table");
        String[] tables = table.split(",");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("dbLink", databaselinkId);
        params.put("tableNames", Arrays.asList(tables));
        params.put("catalog", catalogId);
        params.put("isUpdate", "1");
        params.put("source_app", "epm");
        StringBuilder msg = new StringBuilder();
        try {
            List response = (List)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscx", (String)"IscResourceBuildService", (String)"buildTableModel", (Object[])new Object[]{params});
            for (int i = 0; i < response.size(); ++i) {
                Map map = (Map)response.get(i);
                Long id = (Long)map.get("id");
                if (id != null) continue;
                msg.append(i + 1).append(".").append(((String)map.get("error")).replace("\r\n\r\n", "\r\n")).append("\n\n");
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        if (msg.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5b58\u5728\u5931\u8d25", (String)"DataModelReverseFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), msg.toString(), MessageTypes.Default);
        } else {
            HashMap<String, String> returnData = new HashMap<String, String>(16);
            returnData.put("msg", "success");
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("btnok".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.save();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("databaselink".equals(name)) {
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("source_app", (Object)"epm");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("catalog_select".equals(actionId) && (data = (Map)closedCallBackEvent.getReturnData()) != null) {
            this.getModel().setValue("catalog", data.get("id"));
        }
    }
}

