/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.datamodel;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public class ExportAndImportForListPlugin
extends AbstractBaseListPlugin {
    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("export".equals(operateKey) || "export_batch".equals(operateKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            boolean hasPreset = false;
            for (Object pkId : primaryKeyValues) {
                DataModelPresetEnum dataModelPresetEnum = DataModelPresetEnum.getDataModelPreset((Long)((Long)pkId));
                if (dataModelPresetEnum == null) continue;
                hasPreset = true;
                break;
            }
            if (hasPreset) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u51fa\u9884\u7f6e\u6a21\u578b\u3002", (String)"ExportAndImportForListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                byte[] bytes;
                try {
                    String exportStr = (String)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"exportResourceByMultiId", (Object[])new Object[]{"iscx_resource", Arrays.asList(primaryKeyValues)});
                    bytes = exportStr.getBytes(StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epdm_dm", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValues[0])});
                try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl((dynamicObject != null ? dynamicObject.getString("number") : "dataModel") + ".dts", (InputStream)input, 1800);
                    this.getView().openUrl(urls);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ExportAndImportForListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }
}

