/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.UserUtils;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.business.etl.IscxService;
import kd.epm.epdm.common.enums.ETLStatusEnum;
import kd.epm.epdm.formplugin.etl.util.DataQueryUtil;

public abstract class AbstractEtlListPlugin
extends AbstractBaseListPlugin {
    public static final String REFRESH = "refresh_list";

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (REFRESH.equals(closedCallBackEvent.getActionId())) {
            ListView listView = (ListView)this.getView();
            listView.refresh();
        }
    }

    public abstract DynamicObject[] getRowsByStatus(List<ETLStatusEnum> var1, Object[] var2);

    public void act(Object[] primaryKeyValues, String actId, String actName, ETLStatusEnum[] currList, ETLStatusEnum tar) {
        if (primaryKeyValues.length > 1) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u652f\u6301\u591a\u4efb\u52a1%s\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractEtlListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), actName));
            return;
        }
        try {
            IscxService iscxService = new IscxService();
            DynamicObject[] objects = this.getRowsByStatus(Arrays.asList(currList), primaryKeyValues);
            ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>();
            String succMsg = String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"AbstractEtlListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), actName);
            if (objects.length > 0) {
                switch (actId) {
                    case "enable": {
                        this.enable(objects, tar, iscxService, updates);
                        break;
                    }
                    case "disable": {
                        this.disable(objects, tar, iscxService, updates);
                        break;
                    }
                    case "deploy": {
                        this.deploy(objects, tar, iscxService, updates);
                        break;
                    }
                    case "start": {
                        this.start(objects, iscxService, updates);
                        break;
                    }
                    case "retry": {
                        this.retry(objects, tar, iscxService, updates);
                        succMsg = String.format(ResManager.loadKDString((String)"%s\u6307\u4ee4\u53d1\u9001\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u89c2\u5bdf\u4efb\u52a1\u72b6\u6001\u3002", (String)"AbstractEtlListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), actName);
                        break;
                    }
                    case "terminate": {
                        this.tryTerminate(objects, tar, iscxService, updates);
                        succMsg = String.format(ResManager.loadKDString((String)"%s\u6307\u4ee4\u53d1\u9001\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u89c2\u5bdf\u4efb\u52a1\u72b6\u6001\u3002", (String)"AbstractEtlListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), actName);
                    }
                }
                if (!updates.isEmpty()) {
                    objects = new DynamicObject[updates.size()];
                    int i = 0;
                    for (DynamicObject obj : updates) {
                        objects[i++] = obj;
                    }
                    SaveServiceHelper.save((DynamicObject[])objects);
                    ListView listView = (ListView)this.getView();
                    listView.refresh();
                    this.getView().showSuccessNotification(succMsg);
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25,\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u4efb\u52a1\u3002", (String)"AbstractEtlListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]), actName));
                }
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5931\u8d25,\u4efb\u52a1\u72b6\u6001\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"AbstractEtlListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), actName));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25:%2$s", (String)"AbstractEtlListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), actName, e.getMessage()));
            throw new KDBizException(e.getMessage());
        }
    }

    public void enable(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
        for (DynamicObject obj : objects) {
            if (null == obj) continue;
            obj.set("status", (Object)tar.getNumber());
            long id = obj.getLong("id");
            iscxService.enable(id);
            updates.add(obj);
        }
    }

    public abstract void retry(DynamicObject[] var1, ETLStatusEnum var2, IscxService var3, List<DynamicObject> var4);

    public abstract void disable(DynamicObject[] var1, ETLStatusEnum var2, IscxService var3, List<DynamicObject> var4);

    public abstract void tryTerminate(DynamicObject[] var1, ETLStatusEnum var2, IscxService var3, List<DynamicObject> var4);

    public void deploy(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
        for (DynamicObject obj : objects) {
            if (null == DataQueryUtil.deployOneWithRetry(obj, tar, iscxService, 5)) continue;
            updates.add(obj);
        }
    }

    public void start(DynamicObject[] objects, IscxService iscxService, List<DynamicObject> tasks) {
        ArrayList<DynamicObject> runningStates = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objects) {
            long id;
            long deployId;
            if (null == obj || (deployId = iscxService.start(id = obj.getLong("id"))) <= 0L) continue;
            tasks.add(obj);
            DynamicObject oState = BusinessDataServiceHelper.newDynamicObject((String)"epdm_etl_running_status");
            oState.set("task", (Object)id);
            oState.set("deployid", (Object)deployId);
            oState.set("status", (Object)ETLStatusEnum.Running.getNumber());
            oState.set("creater", (Object)UserUtils.getUserId());
            oState.set("modifier", (Object)UserUtils.getUserId());
            runningStates.add(oState);
        }
        if (!runningStates.isEmpty()) {
            DynamicObject[] rows = new DynamicObject[runningStates.size()];
            int i = 0;
            for (DynamicObject obj : runningStates) {
                rows[i++] = obj;
            }
            SaveServiceHelper.save((DynamicObject[])rows);
        }
    }

    @Override
    public void writeLog(String entityNumber, String baseEntity, IOperationTypeInfo opName, Object[] primaryKeyValues) {
        MainEntityType dataEntityType;
        MultiLangEnumBridge opDescriotion = null;
        if (primaryKeyValues != null && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntity)) instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)dataEntityType;
            String numberProperty = basedataEntityType.getNumberProperty();
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)baseEntity, (String)numberProperty, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
            List numbers = dynamicObjects.stream().map(o -> o.getString(numberProperty)).collect(Collectors.toList());
            opDescriotion = new MultiLangEnumBridge("\u7f16\u7801\uff1a%s", "AbstractEtlListPlugin_7", "epm-epbs-formplugin", new Object[]{String.join((CharSequence)",", numbers)});
        }
        OperationLogUtil.writeLog((String)entityNumber, (IOperationTypeInfo)opName, opDescriotion);
    }
}

