/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.formplugin.etl.util.DataFlowTriggerUtil;
import org.quartz.CronExpression;

public class CronExpressionFormPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String cron = (String)this.getView().getFormShowParameter().getCustomParam("cron_expr");
        if (!StringUtils.isEmpty((String)cron) && CronExpression.isValidExpression((String)cron)) {
            String[] split = cron.replaceAll(" {2,}", " ").split(" ");
            this.getModel().setValue("second", (Object)split[0]);
            this.getModel().setValue("minute", (Object)split[1]);
            this.getModel().setValue("hour", (Object)split[2]);
            this.getModel().setValue("day", (Object)split[3]);
            this.getModel().setValue("month", (Object)split[4]);
            this.getModel().setValue("week", (Object)split[5]);
        }
        this.showRecent20Plans();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("cron_expr", this.buildCron());
        this.getView().returnDataToParent((Object)params);
    }

    private String buildCron() {
        String cronExpression = this.getExpression();
        if (CronExpression.isValidExpression((String)cronExpression)) {
            return cronExpression;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8868\u683c\u5185\u586b\u5199\u5185\u5bb9\u89e3\u6790\u7684cron\u8868\u8fbe\u5f0f\u975e\u6cd5\uff0c\u65e0\u6cd5\u8fd4\u56decron\u8868\u8fbe\u5f0f\u3002", (String)"CronExpressionFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
    }

    private String getExpression() {
        return String.valueOf(this.getModel().getValue("second")) + ' ' + this.getModel().getValue("minute") + ' ' + this.getModel().getValue("hour") + ' ' + this.getModel().getValue("day") + ' ' + this.getModel().getValue("month") + ' ' + this.getModel().getValue("week");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.showRecent20Plans();
    }

    private void showRecent20Plans() {
        String expression = this.getExpression();
        Timestamp startTime = D.t((Object)this.getView().getFormShowParameter().getCustomParam("start_time"));
        Timestamp endTime = D.t((Object)this.getView().getFormShowParameter().getCustomParam("end_time"));
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl("desc");
        codeEdit.setText(DataFlowTriggerUtil.getRecentTopPlansDesc(startTime, endTime, expression, 20));
    }
}

