/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OpCodeInfo;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.business.etl.IscxService;
import kd.epm.epdm.common.enums.ETLStatusEnum;
import kd.epm.epdm.common.util.EtlUtil;
import kd.epm.epdm.formplugin.etl.AbstractEtlListPlugin;

public class EtlRunningListPlugin
extends AbstractEtlListPlugin {
    private static final Log log = LogFactory.getLog(EtlRunningListPlugin.class);
    private final String selectFields = "id,deployid,status,task.id";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        this.setListUnitStyle();
        super.afterBindData(e);
    }

    private void setListUnitStyle() {
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        List rows = (List)billList.getQingData(0, billList.getCurrentListAllRowCollection().size()).get("rows");
        for (int i = 0; i < rows.size(); ++i) {
            List row = (List)rows.get(i);
            String state = D.s(row.get(4));
            if (!"F".equals(state)) continue;
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey("deployid_state");
            cellStyle.setRow(i);
            cellStyle.setForeColor("rgb(251,35,35)");
            cellStyles.add(cellStyle);
        }
        billList.setCellStyle(cellStyles);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"iscx_data_stream"));
                return super.getData(start, limit);
            }
        });
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject row : pageData) {
            DynamicObject obj = row.getDynamicObject("deployid");
            if (null == obj) continue;
            Date startTime = obj.getDate("start_time");
            Date endTime = obj.getDate("modifytime");
            if (null == startTime || null == endTime) continue;
            row.set("runtime", (Object)EtlUtil.formatDuring((long)(endTime.getTime() - startTime.getTime())));
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("task_number".equals(args.getFieldName())) {
            QFilter filter;
            DynamicObject obj;
            args.setCancel(true);
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.setFormId("epdm_etl_task");
            if (this.getFocusRowPkId() != null && null != (obj = BusinessDataServiceHelper.loadSingle((String)"epdm_etl_running_status", (String)"id,deployid,status,task.id", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", this.getFocusRowPkId())})) && null != obj.getDynamicObject("task")) {
                formShowParameter.setPkId((Object)obj.getDynamicObject("task").getLong("id"));
                formShowParameter.setCustomParam("id", (Object)obj.getDynamicObject("task").getLong("id"));
                formShowParameter.setCustomParam("actType", (Object)"edit");
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh_list"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else if ("deployid_number".equals(args.getFieldName())) {
            QFilter filter;
            DynamicObject obj;
            DynamicObject stream;
            args.setCancel(true);
            if (this.getFocusRowPkId() != null && null != (stream = (obj = BusinessDataServiceHelper.loadSingle((String)"epdm_etl_running_status", (String)"id,deployid,status,task.id", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", this.getFocusRowPkId())})).getDynamicObject("deployid"))) {
                this.showLogListView(stream.getLong("id"), "staram");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateName = formOperate.getOption().getVariableValue("operatename");
        Object[] primaryKeyValues = null;
        switch (operateKey) {
            case "retrybtn": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                this.act(primaryKeyValues, "retry", operateName, new ETLStatusEnum[]{ETLStatusEnum.RUN_F, ETLStatusEnum.RUN_S, ETLStatusEnum.RUN_X}, ETLStatusEnum.Running);
                break;
            }
            case "terminate": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                this.act(primaryKeyValues, "terminate", operateName, new ETLStatusEnum[]{ETLStatusEnum.RUN_R}, ETLStatusEnum.Stopping);
                break;
            }
            case "view_log": 
            case "view_trace": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                if (primaryKeyValues.length > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EtlRunningListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                QFilter filter = new QFilter("id", "=", this.getFocusRowPkId());
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"epdm_etl_running_status", (String)"id,deployid,status,task.id", (QFilter[])new QFilter[]{filter});
                DynamicObject stream = obj.getDynamicObject("deployid");
                if (null == stream) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"EtlRunningListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.showLogListView(stream.getLong("id"), operateKey);
            }
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"epdm_etl_running_status", (String)"task.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        Object[] pks = Arrays.stream(load).map(o -> o.getLong("task.id")).toArray();
        this.writeLog("epdm_etl_running_status", "epdm_etl_task", (IOperationTypeInfo)new OpCodeInfo(operateKey, operateName), pks);
    }

    @Override
    public DynamicObject[] getRowsByStatus(List<ETLStatusEnum> currList, Object[] primaryKeyValues) {
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"epdm_etl_running_status", (String)"id,deployid,status,task.id", (QFilter[])new QFilter[]{filter});
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : objects) {
            DynamicObject stream = obj.getDynamicObject("deployid");
            if (null == stream || !currList.contains(ETLStatusEnum.getByNumber((String)stream.getString("state")))) continue;
            dynamicObjectList.add(obj);
        }
        return dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
    }

    @Override
    public void retry(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
        for (DynamicObject obj : objects) {
            long deployId;
            DynamicObject stream = obj.getDynamicObject("deployid");
            if (null == stream || !iscxService.retry(deployId = stream.getLong("id"))) continue;
            obj.set("status", (Object)tar.getNumber());
            updates.add(obj);
        }
    }

    @Override
    public void tryTerminate(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
        for (DynamicObject obj : objects) {
            obj.set("status", (Object)tar.getNumber());
            DynamicObject stream = obj.getDynamicObject("deployid");
            if (null == stream) continue;
            long deployId = stream.getLong("id");
            iscxService.tryTerminate(deployId);
            updates.add(obj);
        }
    }

    @Override
    public void disable(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
    }

    private void showLogListView(long id, String operateKey) {
        ListShowParameter p = new ListShowParameter();
        String formId = "iscx_data_stream";
        String property = "id";
        if ("view_log".equals(operateKey)) {
            formId = "iscx_data_stream_log";
            property = "data_stream.id";
        } else if ("view_trace".equals(operateKey)) {
            formId = "iscx_data_stream_trace";
            property = "data_stream.id";
        }
        p.setBillFormId(formId);
        ListFilterParameter listFilterParameter = p.getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter(property, "=", (Object)id));
        p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)p);
    }
}

