/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OpCodeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.export.ExportDynamicParamVo;
import kd.epm.epbs.common.export.ExportDynamicUtil;
import kd.epm.epbs.common.form.FormOpener;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.business.etl.EtlRunningConfigService;
import kd.epm.epdm.business.etl.IscxService;
import kd.epm.epdm.business.etl.helper.EPDMETLTaskHelper;
import kd.epm.epdm.business.etl.vo.RunningConfig;
import kd.epm.epdm.business.etl.vo.RunningStatus;
import kd.epm.epdm.common.enums.CataLogPresetEnum;
import kd.epm.epdm.common.enums.ETLStatusEnum;
import kd.epm.epdm.formplugin.etl.AbstractEtlListPlugin;
import kd.epm.epdm.formplugin.etl.util.DataFlowTriggerUtil;
import kd.epm.epdm.formplugin.etl.util.DataQueryUtil;

public class EtlTaskListPlugin
extends AbstractEtlListPlugin {
    private static final Log log = LogFactory.getLog(EtlTaskListPlugin.class);
    private static final String BTN_ADD = "btnadd";
    private static final String LIT_ADD = "litadd";
    public static final String NOTICE_BTN = "notice_btn";

    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject row : pageData) {
            if (!"scheduled".equals(row.getString("run_type"))) continue;
            row.set("schedule", (Object)DataFlowTriggerUtil.getRecentTopPlansDesc(D.s((Object)row.get("schedule")), 2));
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if ("bos_listf7".equals(this.getView().getFormShowParameter().getFormId())) {
            e.getNoLinkKey().add("number");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("base_add".equals(actionId)) {
            if (returnData != null) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EtlTaskListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                Map openStepForm = (Map)returnData;
                this.openStepForm(openStepForm);
            }
        } else if ("startbtn".equals(actionId) && returnData != null) {
            EtlRunningConfigService runningConfigService = new EtlRunningConfigService();
            Map map = (Map)returnData;
            RunningConfig conf = new RunningConfig();
            long id = D.l(map.remove("id"));
            conf.setTaskId(id);
            List list = EPDMETLTaskHelper.getParamConfigById((long)id, fieldMap -> fieldMap.put("value", map.get(fieldMap.get("number"))));
            conf.setParams(conf.listToParams(list));
            RunningStatus runningStatus = runningConfigService.setRunningParams(conf);
            if (200 == runningStatus.getCode()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u6210\u529f\u3002", (String)"EtlTaskListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff1a%1$s", (String)"EtlTaskListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), runningStatus.getMessage()));
            }
        }
        if (returnData != null) {
            ListView view = (ListView)this.getView();
            view.refresh();
        }
    }

    private void openStepForm(Map<String, Object> returnData) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("number", returnData.get("number"));
        formShowParameter.setCustomParam("actType", (Object)"new");
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setFormId("epdm_etl_task");
        formShowParameter.setPkId(returnData.get("id"));
        Object copyId = returnData.get("copyId");
        if (copyId != null) {
            formShowParameter.setPkId(copyId);
            formShowParameter.setCustomParam("iscopy", (Object)true);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("number".equals(args.getFieldName())) {
            args.setCancel(true);
            BaseShowParameter formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.setFormId("epdm_etl_task");
            if (this.getFocusRowPkId() != null) {
                formShowParameter.setPkId(this.getFocusRowPkId());
                formShowParameter.setPageId(this.getView().getPageId() + this.getFocusRowPkId());
                formShowParameter.setCustomParam("id", this.getFocusRowPkId());
                formShowParameter.setCustomParam("actType", (Object)"edit");
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh_list"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("delete".equals(operateKey)) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            String operateName = ResManager.loadKDString((String)"\u5220\u9664", (String)"EtlTaskListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
            this.writeLog("epdm_etl_task", (IOperationTypeInfo)new OpCodeInfo(operateKey, operateName), primaryKeyValues);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && !operationResult.isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operatename = formOperate.getOption().getVariableValue("operatename");
        Object[] primaryKeyValues = null;
        switch (operateKey) {
            case "running_conf": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                if (this.getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EtlTaskListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("id", primaryKeyValues[0]);
                FormOpener.showForm((AbstractFormPlugin)this, (String)"epdm_etl_running_conf", (String)ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u4fee\u6539", (String)"EtlTaskListPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), param, (String)operateKey);
                break;
            }
            case "export": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epdm_etl_task"));
                List numbers = Arrays.stream(dynamicObjects).map(e -> e.getString("number")).collect(Collectors.toList());
                String fileName = String.join((CharSequence)"&", numbers);
                if (fileName.length() > 30) {
                    fileName = fileName.substring(0, 30);
                }
                ArrayList<Long> refIds = new ArrayList<Long>(10);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    refIds.add(dynamicObject.getLong("datamodesrc_id"));
                    refIds.add(dynamicObject.getLong("datamodetar_id"));
                }
                DynamicObject[] refs = null;
                if (!refIds.isEmpty()) {
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"epdm_dm_preset", (String)"id", (QFilter[])new QFilter[]{new QFilter("datamodel", "in", refIds)});
                    List ids = collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                    refs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"epdm_dm_preset"));
                }
                QFilter qFilter = new QFilter("number", "in", (Object)CataLogPresetEnum.allNumbers());
                DynamicObjectCollection cataLogs = QueryServiceHelper.query((String)"iscx_catalog", (String)"id", (QFilter[])qFilter.toArray());
                Set cataLogIds = cataLogs.stream().map(o -> "iscx_catalog_" + o.getLong("id")).collect(Collectors.toSet());
                HashSet igPkSet = new HashSet(16);
                igPkSet.addAll(cataLogIds);
                ExportDynamicParamVo exportDynamicParamVo = new ExportDynamicParamVo(this.getView(), fileName + ".dts", dynamicObjects, refs, null, igPkSet);
                ExportDynamicUtil.export((ExportDynamicParamVo)exportDynamicParamVo);
                break;
            }
            case "import": {
                HashMap<String, String> params = new HashMap<String, String>(16);
                params.put("entityName", "epdm_etl_task");
                FormOpener.showForm((AbstractFormPlugin)this, (String)"epdm_etl_task_import", (String)"", params, (String)"refresh_list", (ShowType)ShowType.MainNewTabPage, (String)("epdm_etl_task_import" + this.getView().getPageId()));
                break;
            }
            case "deploy_lst": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                this.act(primaryKeyValues, "deploy", ResManager.loadKDString((String)"\u90e8\u7f72\u4efb\u52a1", (String)"EtlTaskListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), new ETLStatusEnum[]{ETLStatusEnum.ToBeDeployed}, ETLStatusEnum.Deployed);
                break;
            }
            case "startbtn": {
                if (this.getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EtlTaskListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.showVoucherCollectionPage();
                break;
            }
            case "copy": {
                if (this.getSelectedRows().size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"EtlTaskListPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    break;
                }
                Object primaryKeyValue = this.getSelectedRows().get(0).getPrimaryKeyValue();
                primaryKeyValues = new Object[]{primaryKeyValue};
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("epdm_etl_info");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                Map customParams = formShowParameter.getCustomParams();
                customParams.put("iscopy", true);
                customParams.put("id", primaryKeyValue);
                customParams.put("actType", "new");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "base_add"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "delete": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                break;
            }
            case "btnadd": 
            case "litadd": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                DataQueryUtil.openBaseInfoForm((AbstractFormPlugin)this, null, "base_add");
                break;
            }
            case "notice_btn": {
                primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
                DataQueryUtil.openBaseList((AbstractFormPlugin)this, 1000, 600, "epdm_etl_notice_send");
                break;
            }
            case "iscx_debug": {
                FormOpener.showForm((AbstractFormPlugin)this, (String)"epdm_etl_iscx_debug", (String)"", null, (String)operateKey);
                break;
            }
        }
        if (!"delete".equals(operateKey)) {
            this.writeLog("epdm_etl_task", (IOperationTypeInfo)new OpCodeInfo(operateKey, operatename), primaryKeyValues);
        }
    }

    private void showVoucherCollectionPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("epdm_vouchercollection");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8", (String)"EtlTaskListPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        DynamicObject task = this.getFirstFromSelectedRows(this.getSelectedRows());
        if (null != task) {
            String status = D.s((Object)task.get("status"));
            if (!ETLStatusEnum.Deployed.getNumber().equals(status)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u4efb\u52a1\u72b6\u6001\u4e3a[%s]\uff0c\u4e0d\u6ee1\u8db3\u6267\u884c\u6761\u4ef6\u3002", (String)"EtlTaskListPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]), ETLStatusEnum.getName((String)status)));
                return;
            }
            long id = D.l((Object)task.get("id"));
            showParameter.setCustomParam("id", (Object)id);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "startbtn"));
        try {
            this.writeLog((IOperationTypeInfo)new OperationTypeInfo("starttask", new MultiLangEnumBridge("\u542f\u52a8\u4efb\u52a1", "EtlTaskListPlugin_11", "epm-epbs-formplugin")), null);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        this.getView().showForm(showParameter);
    }

    public DynamicObject getFirstFromSelectedRows(ListSelectedRowCollection selectedRows) {
        if (null == selectedRows || selectedRows.isEmpty()) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", selectedRows.get(0).getPrimaryKeyValue());
        return BusinessDataServiceHelper.loadSingle((String)"epdm_etl_task", (String)"id,status,run_type", (QFilter[])new QFilter[]{filter});
    }

    @Override
    public DynamicObject[] getRowsByStatus(List<ETLStatusEnum> currList, Object[] primaryKeyValues) {
        List statusList = currList.stream().map(ETLStatusEnum::getNumber).collect(Collectors.toList());
        QFilter filterStatus = new QFilter("status", "in", statusList);
        QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
        return BusinessDataServiceHelper.load((String)"epdm_etl_task", (String)"id,status,run_type", (QFilter[])new QFilter[]{filter, filterStatus});
    }

    @Override
    public void retry(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
    }

    @Override
    public void disable(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
    }

    @Override
    public void tryTerminate(DynamicObject[] objects, ETLStatusEnum tar, IscxService iscxService, List<DynamicObject> updates) {
    }
}

