/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.Button;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.common.enums.ETLStatusEnum;
import kd.epm.epdm.formplugin.etl.util.DataQueryUtil;
import kd.epm.epdm.formplugin.etl.util.EtlValidityUtil;

public class EtlTaskRunningConfFormPlugin
extends AbstractFormPlugin {
    private static final String normalFields = "id,run_type,schedule,max_threads,work_area_size,log_level,checkpoint,max_retry_times,retry_interval,status,failed_notice,success_notice";
    private static final String paramFields = "params.id,params.entryid,params.seq,params.param_number,params.param_name,params.param_type,params.param_value,params.param_desc,params.ismultiple";
    private static final String[] clickKeys = new String[]{"schedule", "newbtn_err", "newbtn_ok"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long id = 0L;
        if (null != this.getView().getFormShowParameter().getCustomParam("id")) {
            id = D.l((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        }
        if (id > 0L) {
            String[] keys;
            QFilter filter = new QFilter("id", "=", (Object)id);
            DynamicObject baseInfo = QueryServiceHelper.queryOne((String)"epdm_etl_task", (String)"id,number,name,remark", (QFilter[])new QFilter[]{filter});
            String selectFields = "id,run_type,schedule,max_threads,work_area_size,log_level,checkpoint,max_retry_times,retry_interval,status,failed_notice,success_notice,datamodetar,params.id,params.entryid,params.seq,params.param_number,params.param_name,params.param_type,params.param_value,params.param_desc,params.ismultiple";
            DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((String)"epdm_etl_task", (String)selectFields, (QFilter[])new QFilter[]{filter});
            this.setModelValue(baseInfo, "remark");
            for (String key : keys = normalFields.split(",")) {
                this.setModelValue(taskInfo, key);
            }
            this.setModelValue(taskInfo, "params");
            this.setModelValue(taskInfo, "datamodetar");
            this.getView().updateView();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(clickKeys);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof TextEdit) {
            TextEdit source = (TextEdit)evt.getSource();
            String fieldKey = source.getFieldKey();
            int row = DataQueryUtil.getEntryRowIndex(this, fieldKey);
            DataQueryUtil.showFieldSelectForm(this, this.getModel(), fieldKey, row);
        } else if (src instanceof Button) {
            String fieldKey = ((Button)src).getKey();
            DataQueryUtil.showFieldSelectForm(this, this.getModel(), fieldKey, 0);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null != result && !result.isSuccess()) {
            return;
        }
        if ("save".equals(args.getOperateKey())) {
            this.save();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String action = event.getActionId();
        Object returnData = event.getReturnData();
        switch (action) {
            case "schedule": {
                if (returnData == null) break;
                this.getModel().setValue("schedule", ((Map)returnData).get("cron_expr"));
                break;
            }
            case "success_notice": 
            case "failed_notice": {
                if (returnData == null) break;
                this.getModel().setValue(action, ((Map)returnData).get("noticeId"));
            }
        }
    }

    private void setModelValue(DynamicObject obj, String key) {
        this.getModel().setValue(key, obj.get(key));
    }

    private void setDynamicObject(DynamicObject obj, String key) {
        obj.set(key, this.getModel().getValue(key));
    }

    private boolean validity(StringBuffer validityMsg) {
        String retryInterval;
        int workSize;
        int maxThreads;
        boolean rs = true;
        if (null == this.getModel().getValue("run_type")) {
            rs = false;
            validityMsg.append(ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EtlTaskRunningConfFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else if ("scheduled".equals(this.getModel().getValue("run_type")) && null == this.getModel().getValue("schedule")) {
            rs = false;
            validityMsg.append(ResManager.loadKDString((String)"\u6267\u884c\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EtlTaskRunningConfFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        int n = maxThreads = null == this.getModel().getValue("max_threads") ? 0 : (Integer)this.getModel().getValue("max_threads");
        if (maxThreads < 1 || maxThreads > 16) {
            rs = false;
            validityMsg.append(ResManager.loadKDString((String)"\u6700\u5927\u7ebf\u7a0b\u6570\u53d6\u503c\u533a\u95f4\u662f[1-16]\u3002", (String)"EtlTaskRunningConfFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        int n2 = workSize = null == this.getModel().getValue("work_area_size") ? 0 : (Integer)this.getModel().getValue("work_area_size");
        if (workSize < 1) {
            rs = false;
            validityMsg.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u4f5c\u533a\u5927\u5c0f\u3002", (String)"EtlTaskRunningConfFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (null == this.getModel().getValue("log_level")) {
            rs = false;
            validityMsg.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5fd7\u7ea7\u522b\u3002", (String)"EtlTaskRunningConfFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (null == this.getModel().getValue("checkpoint")) {
            rs = false;
            validityMsg.append(ResManager.loadKDString((String)"\u68c0\u67e5\u70b9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EtlTaskRunningConfFormPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (EtlValidityUtil.entityValidity(this.getModel(), "params") && !EtlValidityUtil.entityValidity(this.getModel(), "params", "param_value")) {
            rs = false;
            validityMsg.append(ResManager.loadKDString((String)"\u53c2\u6570\u7ed1\u5b9a\u8868\u914d\u7f6e\u9519\u8bef\u3002", (String)"EtlTaskRunningConfFormPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (!StringUtils.isEmpty((String)(retryInterval = D.s((Object)this.getModel().getValue("retry_interval")))) && "0".equals(retryInterval.trim())) {
            validityMsg.append(ResManager.loadKDString((String)"\u91cd\u8bd5\u95f4\u9694(\u5206\u949f)\uff1a\u4e0d\u80fd\u4e3a0\uff0c\u5982\u679c\u9700\u8981\u5206\u522b\u6307\u5b9a\u5404\u6b21\u91cd\u8bd5\u7684\u5ef6\u65f6\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694\u3002\u4f8b\u5982\uff1a5,15,30", (String)"EtlTaskRunningConfFormPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            rs = false;
        }
        return rs;
    }

    private void save() {
        StringBuffer validityMsg = new StringBuffer();
        if (!this.validity(validityMsg)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\u5982\u4e0b\uff1a%s", (String)"EtlTaskRunningConfFormPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]), validityMsg));
        } else {
            DynamicObject task = (DynamicObject)this.getModel().getValue("id");
            if (null != task) {
                DynamicObject update = BusinessDataServiceHelper.loadSingle((Object)task.getLong("id"), (String)"epdm_etl_task");
                if (null != update) {
                    String[] keys;
                    for (String key : keys = normalFields.split(",")) {
                        if ("id".equals(key) || "status".equals(key)) continue;
                        this.setDynamicObject(update, key);
                    }
                    if ("manual".equals(update.getString("run_type"))) {
                        update.set("schedule", (Object)"");
                    }
                    DataQueryUtil.setEntry(this.getModel(), "params", update);
                    Boolean[] stepValidity = new Boolean[]{false, false, false, false};
                    boolean validity = true;
                    for (int i = 0; i < 4; ++i) {
                        String valMsg = EtlValidityUtil.validityTab(update, i, stepValidity);
                        if (StringUtils.isEmpty((String)valMsg)) continue;
                        validity = false;
                        break;
                    }
                    if (validity) {
                        String valMsg = EtlValidityUtil.validityTarAndMaping(update);
                        validity = StringUtils.isEmpty((String)valMsg);
                    }
                    if (validity) {
                        update.set("status", (Object)ETLStatusEnum.ToBeDeployed.getNumber());
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{update});
                    HashMap<String, Long> map = new HashMap<String, Long>(4);
                    map.put("taskId", task.getLong("id"));
                    this.getView().returnDataToParent(map);
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"EtlTaskRunningConfFormPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    this.getView().close();
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"EtlTaskRunningConfFormPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"EtlTaskRunningConfFormPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

