/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.form.FormOpener;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.common.util.MetadataUtil;
import kd.epm.epdm.formplugin.etl.util.DataQueryUtil;
import kd.epm.epdm.formplugin.etl.util.EtlValidityUtil;

public class ValueConvertFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sql_text", "script_remark"});
        EntryGrid fields = (EntryGrid)this.getControl("fields_mapping");
        fields.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject update;
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        String input = (String)this.getView().getFormShowParameter().getCustomParam("input");
        String output = (String)this.getView().getFormShowParameter().getCustomParam("output");
        QFilter filter = new QFilter("number", "=", (Object)number);
        Map propertyToAlias = MetadataUtil.getAllProperties((String)"epdm_etl_task");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"epdm_etl_task", (String)String.join((CharSequence)",", propertyToAlias.keySet()), (QFilter[])new QFilter[]{filter});
        DynamicObject dynamicObject = update = load.length > 0 ? load[0] : null;
        if (null != update) {
            DynamicObject object;
            DynamicObject tarMode;
            this.getModel().setValue("baseid", update.getPkValue());
            this.getModel().setValue("src_field", (Object)input);
            this.getModel().setValue("tar_field", (Object)output);
            DynamicObject srcMode = (DynamicObject)update.get("datamodesrc");
            if (null != srcMode) {
                this.getModel().setValue("inputid", srcMode.getPkValue());
            }
            if (null != (tarMode = (DynamicObject)update.get("datamodetar"))) {
                this.getModel().setValue("outputid", tarMode.getPkValue());
            }
            if (D.l((Object)(object = this.loadSingle()).getPkValue()) > 0L) {
                if (!StringUtils.isEmpty((String)object.getString("number"))) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                }
                this.getModel().setValue("number", object.get("number"));
                this.getModel().setValue("name", object.get("name"));
                this.getModel().setValue("info", object.get("info"));
                this.getModel().setValue("def_value", object.get("def_value"));
                this.getModel().setValue("type", object.get("type"));
                this.getModel().setValue("constant_entity", object.get("constant_entity"));
                this.getModel().setValue("sql_tag", object.get("script_tag"));
                this.getModel().setValue("sql", object.get("script"));
                this.getModel().setValue("sql_text", object.get("script_remark"));
                this.getModel().setValue("script_tag", object.get("script_tag"));
                this.getModel().setValue("script", object.get("script"));
                this.getModel().setValue("script_remark", object.get("script_remark"));
                this.getModel().setValue("fields_mapping", object.get("fields_mapping"));
                this.getModel().setValue("class_name", object.get("class_name"));
                this.getModel().setValue("sub_rules", object.get("sub_rules"));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u57fa\u7840\u8d44\u6599\u4fe1\u606f\u3002", (String)"ValueConvertFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null != result && !result.isSuccess()) {
            return;
        }
        if ("save".equals(args.getOperateKey())) {
            boolean insert;
            String type = (String)this.getModel().getValue("type");
            String id = "unknown";
            switch (type) {
                case "constant": {
                    id = "constant_entity";
                    break;
                }
                case "SQL": {
                    id = "sql_tag";
                    break;
                }
                case "script": {
                    id = "script_tag";
                    break;
                }
                case "key": {
                    id = "fields_mapping";
                    break;
                }
                case "java": {
                    id = "class_name";
                    break;
                }
                case "comb": {
                    id = "sub_rules";
                }
            }
            StringBuffer messageBuffer = new StringBuffer();
            boolean bl = insert = null == this.loadByNumberSingle();
            if (EtlValidityUtil.valueConvertValidity(this.getModel(), id, messageBuffer, insert)) {
                if (this.save(type)) {
                    Map params = this.getView().getFormShowParameter().getCustomParams();
                    params.put("name_number", this.getModel().getValue("number"));
                    this.getView().returnDataToParent((Object)params);
                    this.getView().close();
                }
            } else {
                throw new KDBizException(messageBuffer.toString());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("sql_text".equals(source.getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("remark", this.getModel().getValue("sql"));
            params.put("script", this.getModel().getValue("sql_tag"));
            params.put("plugin_name", this.getView().getEntityId() + "_sql");
            params.put("field", "sql");
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_sql_editor", (String)ResManager.loadKDString((String)"SQL\u7f16\u8f91", (String)"ValueConvertFormPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), params, (String)"get_sql");
        } else if ("open_script_editor".equals(source.getKey()) || "script_remark".equals(source.getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("remark", this.getModel().getValue("script"));
            params.put("script", this.getModel().getValue("script_tag"));
            String formStatus = this.getView().getPageCache().get("form_status");
            params.put("billStatus", "view".equals(formStatus) ? OperationStatus.VIEW : OperationStatus.ADDNEW);
            params.put("env", "value_convert_script");
            params.put("context_variables", Collections.singletonList("param"));
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_script_editor_new", (String)ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"ValueConvertFormPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), params, (String)"get_script");
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void closedCallBack(ClosedCallBackEvent env) {
        Map params;
        super.closedCallBack(env);
        String action = env.getActionId();
        if ("get_sql".equals(action)) {
            String formStatus = this.getView().getPageCache().get("form_status");
            Map params2 = (Map)env.getReturnData();
            if (params2 != null && !"view".equals(formStatus)) {
                this.getModel().setValue("sql_text", params2.get("remark"));
                this.getModel().setValue("sql", params2.get("remark"));
                this.getModel().setValue("sql_tag", params2.get("script"));
                this.getView().updateView("script_tag");
                if (params2.get("script") == null || !params2.get("script").toString().contains("as result")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8b66\u544a\uff1aSQL\u811a\u672c\u6ca1\u6709\u8bbe\u7f6e\u8fd4\u56de\u503cas result.", (String)"ValueConvertFormPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("get_script".equals(action) && (params = (Map)env.getReturnData()) != null) {
            this.getModel().setValue("script_remark", params.get("remark"));
            this.getModel().setValue("script", params.get("remark"));
            this.getModel().setValue("script_tag", params.get("script"));
            this.getView().updateView("script_tag");
        }
    }

    private boolean save(String type) {
        DynamicObject update = this.loadSingle();
        update.set("name", this.getModel().getValue("name"));
        if (!StringUtils.isEmpty((String)update.getString("number")) && update.getLong("id") <= 0L && update.getString("number").equals(D.s((Object)this.getModel().getValue("number")))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\u7f16\u7801[%s]\u91cd\u590d", (String)"ValueConvertFormPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), update.getString("number")));
            return false;
        }
        update.set("number", this.getModel().getValue("number"));
        update.set("src_field", this.getModel().getValue("src_field"));
        update.set("tar_field", this.getModel().getValue("tar_field"));
        update.set("info", this.getModel().getValue("info"));
        update.set("def_value", this.getModel().getValue("def_value"));
        update.set("type", this.getModel().getValue("type"));
        update.set("baseid", this.getModel().getValue("baseid"));
        switch (type) {
            case "constant": {
                DataQueryUtil.setEntry(this.getModel(), "constant_entity", update);
                break;
            }
            case "SQL": {
                update.set("script_remark", this.getModel().getValue("sql_text"));
                update.set("script", this.getModel().getValue("sql"));
                update.set("script_tag", this.getModel().getValue("sql_tag"));
                break;
            }
            case "script": {
                update.set("script_remark", this.getModel().getValue("script_remark"));
                update.set("script", this.getModel().getValue("script"));
                update.set("script_tag", this.getModel().getValue("script_tag"));
                break;
            }
            case "key": {
                DataQueryUtil.setEntry(this.getModel(), "fields_mapping", update);
                break;
            }
            case "java": {
                update.set("class_name", this.getModel().getValue("class_name"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{update});
        return true;
    }

    private DynamicObject loadSingle() {
        DynamicObject obj = this.loadByNumberSingle();
        if (null == obj) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"epdm_etl_vc_form");
        }
        return obj;
    }

    private DynamicObject loadByNumberSingle() {
        String number = (String)this.getView().getFormShowParameter().getCustomParam("vc_number");
        Map propertyToAlias = MetadataUtil.getAllProperties((String)"epdm_etl_vc_form");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"epdm_etl_vc_form", (String)String.join((CharSequence)",", propertyToAlias.keySet()), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        return load.length > 0 ? load[0] : null;
    }
}

