/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.business.etl.vo.iscx.flow.ParamTypeEnum;
import kd.epm.epdm.common.enums.CompareTypeEnum;
import org.quartz.CronExpression;

public class DataFlowTriggerUtil {
    public static void resetParams(AbstractFormPlugin form, IDataModel model) {
        DynamicObjectCollection filterEntries = model.getEntryEntity("filters");
        DynamicObjectCollection paramEntries = model.getEntryEntity("params");
        if (!filterEntries.isEmpty()) {
            HashMap<String, String> valMap = new HashMap<String, String>(16);
            HashMap<String, String> typeMap = new HashMap<String, String>(16);
            HashMap<String, String> descMap = new HashMap<String, String>(16);
            HashMap<String, String> nameMap = new HashMap<String, String>(16);
            if (!paramEntries.isEmpty()) {
                for (DynamicObject obj : paramEntries) {
                    valMap.put(obj.getString("param_number"), obj.getString("param_value"));
                    typeMap.put(obj.getString("param_number"), obj.getString("param_type"));
                    descMap.put(obj.getString("param_number"), obj.getString("param_desc"));
                    nameMap.put(obj.getString("param_number"), obj.getString("param_name"));
                }
            }
            paramEntries.clear();
            HashMap<String, Integer> pNameMap = new HashMap<String, Integer>(filterEntries.size());
            for (DynamicObject row : filterEntries) {
                String paramNumber;
                String filterColumn;
                if (!D.x((Object)row.get("isvar")) || StringUtils.isEmpty((String)(filterColumn = D.s((Object)row.get("filter_column"))))) continue;
                CompareTypeEnum compareType = CompareTypeEnum.get((String)row.getString("filter_compare"));
                String enName = "";
                int pos = filterColumn.indexOf(".");
                if (pos > 0) {
                    enName = filterColumn.substring(0, pos);
                    paramNumber = (filterColumn.replace(".", "_") + "_" + compareType.name()).toLowerCase(Locale.ROOT);
                } else {
                    paramNumber = (filterColumn + "_" + compareType.name()).toLowerCase(Locale.ROOT);
                }
                DynamicObject paramsEntry = paramEntries.addNew();
                paramsEntry.set("param_number", (Object)paramNumber);
                if (nameMap.containsKey(paramNumber)) {
                    paramsEntry.set("param_name", nameMap.get(paramNumber));
                } else {
                    String paramName = enName + row.get("filter_label") + "_" + compareType.getCnName();
                    if (pNameMap.containsKey(paramName)) {
                        paramName = row.getString("filter_column").toLowerCase(Locale.ROOT) + paramName;
                    }
                    pNameMap.put(paramName, 1);
                    paramsEntry.set("param_name", (Object)paramName);
                }
                if (typeMap.containsKey(paramNumber)) {
                    paramsEntry.set("param_type", typeMap.get(paramNumber));
                } else {
                    String paramType = ParamTypeEnum.getByName((String)row.getString("filter_type")).getNumber();
                    paramsEntry.set("param_type", (Object)paramType);
                }
                paramsEntry.set("param_desc", (Object)descMap.getOrDefault(paramNumber, ""));
                paramsEntry.set("param_value", (Object)valMap.getOrDefault(paramNumber, ""));
                if ("in".equals(row.get("filter_compare")) || "not in".equals(row.get("filter_compare"))) {
                    paramsEntry.set("ismultiple", (Object)1);
                    continue;
                }
                paramsEntry.set("ismultiple", (Object)0);
            }
            form.getView().setVisible(Boolean.TRUE, new String[]{"advconap311111"});
            model.getDataEntity(true).set("params", (Object)paramEntries);
            form.getView().updateView("params");
        } else {
            if (!paramEntries.isEmpty()) {
                paramEntries.clear();
                model.getDataEntity(true).set("params", (Object)paramEntries);
                form.getView().updateView("params");
            }
            form.getView().setVisible(Boolean.FALSE, new String[]{"advconap311111"});
        }
    }

    public static String getRecentTopPlansDesc(String cron, int size) {
        return DataFlowTriggerUtil.getRecentTopPlansDesc(null, null, cron, size);
    }

    public static String getRecentTopPlansDesc(Timestamp startTime, Timestamp endTime, String cron, int size) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (CronExpression.isValidExpression((String)cron)) {
                Date date = DataFlowTriggerUtil.getStartDate(startTime);
                for (int i = 1; i <= size; ++i) {
                    CronExpression cronExe = new CronExpression(cron);
                    date = cronExe.getNextValidTimeAfter(date);
                    DataFlowTriggerUtil.checkDateIsExpired(date, i, format, endTime);
                    sb.append(ResManager.loadKDString((String)"\u7b2c", (String)"DataFlowTriggerUtil_1", (String)"epm-epbs-formplugin", (Object[])new Object[0])).append(i).append(ResManager.loadKDString((String)"\u6b21\uff1a", (String)"DataFlowTriggerUtil_2", (String)"epm-epbs-formplugin", (Object[])new Object[0])).append(format.format(date)).append('\n');
                }
            } else {
                sb.append(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5185\u586b\u5199\u5185\u5bb9\u89e3\u6790\u7684Cron\u8868\u8fbe\u5f0f:%s\u975e\u6cd5\uff0c\u65e0\u6cd5\u8ba1\u7b97\uff0c\u8bf7\u53c2\u8003\u4e0a\u65b9tips\u89c4\u5219\u66f4\u6539\u3002", (String)"DataFlowTriggerUtil_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), cron));
            }
        }
        catch (Exception var7) {
            sb.append(var7.getMessage());
        }
        return sb.toString();
    }

    private static Date getStartDate(Timestamp startTime) {
        return startTime != null && startTime.getTime() >= System.currentTimeMillis() ? startTime : new Date();
    }

    private static void checkDateIsExpired(Date date, int i, SimpleDateFormat format, Timestamp endTime) {
        if (endTime != null && endTime.getTime() > 0L && date.getTime() > endTime.getTime()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8c03\u5ea6\u8ba1\u5212\u8ba1\u7b97\uff0c\u7b2c%1$s\u6b21\u6267\u884c\u65f6\u95f4\u662f%2$s,\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4%3$s\uff0c\u5f53\u524d\u4efb\u52a1\u5c06\u5728\u6267\u884c%4$s\u6b21\u540e\u505c\u6b62\u3002", (String)"DataFlowTriggerUtil_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]), i, format.format(date), D.t((Object)endTime), i - 1));
        }
    }
}

