/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.etl.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.id.IDService;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.epm.epbs.common.form.FormOpener;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.business.etl.EtlFieldSelectFormPluginHelper;
import kd.epm.epdm.business.etl.IscxService;
import kd.epm.epdm.business.etl.mapping.SimilarityPair;
import kd.epm.epdm.business.etl.mapping.StringSimilarityUtil;
import kd.epm.epdm.business.etl.vo.iscx.flow.FlowType;
import kd.epm.epdm.common.enums.CompareTypeEnum;
import kd.epm.epdm.common.enums.ETLStatusEnum;
import kd.epm.epdm.common.util.IDataModelUtils;
import kd.epm.epdm.formplugin.etl.util.ScriptMappingUtil;

public class DataQueryUtil {
    public static DynamicObject deployOne(DynamicObject task, ETLStatusEnum tar, IscxService iscxService, int retry) throws JsonProcessingException {
        if (null != task) {
            long deployId;
            task.set("status", (Object)tar.getNumber());
            long id = task.getLong("id");
            iscxService.disableAnyway(id, retry);
            Map rs = "manual".equals(task.getString("run_type")) ? iscxService.deploy(id, FlowType.ManualTable) : iscxService.deploy(id, FlowType.TimerTable);
            long l = deployId = null != rs ? (Long)rs.get("id") : 0L;
            if (deployId == id) {
                iscxService.enable(id);
                return task;
            }
        }
        return null;
    }

    public static DynamicObject deployOneWithRetry(DynamicObject task, ETLStatusEnum tar, IscxService iscxService, int retry) {
        try {
            return DataQueryUtil.deployOne(task, tar, iscxService, retry);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (kd.bos.util.StringUtils.isEmpty((String)message)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u7f72\u5931\u8d25\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u786e\u8ba4\u914d\u7f6e\u65e0\u8bef\u540e\u91cd\u8bd5\u3002", (String)"DataQueryUtil_15", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            throw new KDBizException(e.getMessage());
        }
    }

    public static void setFilterFixedValue(IDataModel model, IFormView view, Object returnData) {
        if (returnData instanceof List) {
            DynamicObjectCollection entries = model.getDataEntity(true).getDynamicObjectCollection("filters");
            Map data = (Map)((List)returnData).get(0);
            Object customData = data.get("customData");
            if (customData instanceof Map) {
                int index = D.i(((Map)customData).get("$row"));
                DynamicObject entry = (DynamicObject)entries.get(index);
                String valueFixed = D.s(data.get("fullnumber"));
                if (!kd.bos.util.StringUtils.isEmpty((String)valueFixed)) {
                    valueFixed = valueFixed.replace(".", "_");
                }
                entry.set("filter_value_fixed", (Object)("<%" + valueFixed + "%>"));
                if (entry.getDataEntityType().getProperties().containsKey((Object)"param_label")) {
                    entry.set("param_label", data.get("fulllabel"));
                }
                view.updateView("filters");
            }
        }
    }

    public static void showFieldSelectForm(AbstractFormPlugin form, IDataModel model, String fieldKey, int row) {
        switch (fieldKey) {
            case "filter_column": 
            case "field_name": 
            case "field_name_tar": 
            case "sort_field": {
                DataQueryUtil.showOutputForm(form, model, fieldKey, row);
                break;
            }
            case "filter_value_fixed": {
                DataQueryUtil.showFilterValueFixedForm(form, model, fieldKey, row);
                break;
            }
            case "src_column": 
            case "tar_column": 
            case "aggr_fn": {
                DataQueryUtil.showMappingOutputParamsForm(form, model, fieldKey, row);
                break;
            }
            case "btn_open_default_script": {
                ScriptMappingUtil.openScriptEditor(form, model, "default_script");
                break;
            }
            case "btn_open_ext_script": {
                ScriptMappingUtil.openScriptEditor(form, model, "ext_script");
                break;
            }
            case "vc_rule": {
                DataQueryUtil.showValueConvertForm(form, model, row);
                break;
            }
            case "schedule": {
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put("cron_expr", model.getValue("schedule"));
                FormOpener.showForm((AbstractFormPlugin)form, (String)"epdm_etl_cron", (String)"", params, (String)"schedule");
                break;
            }
            case "newbtn_err": 
            case "newbtn_ok": {
                DataQueryUtil.showNoticeSendForm(form, model, fieldKey);
            }
        }
    }

    public static void setEntry(IDataModel model, String entryId, DynamicObject update) {
        IDataModelUtils.setEntry((IDataModel)model, (String)entryId, (DynamicObject)update);
    }

    private static void showValueConvertForm(AbstractFormPlugin form, IDataModel model, int row) {
        DynamicObject obj;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("$row", row);
        params.put("number", model.getValue("number"));
        params.put("input", "-");
        params.put("output", "-");
        DynamicObjectCollection dynamicObjects = model.getEntryEntity("mapping_entries");
        if (!(null == dynamicObjects || dynamicObjects.isEmpty() || row < 0 || null == (obj = (DynamicObject)dynamicObjects.get(row)) || kd.bos.util.StringUtils.isEmpty((String)D.s((Object)obj.get("src_column"))) || kd.bos.util.StringUtils.isEmpty((String)D.s((Object)obj.get("tar_column"))))) {
            Object vcNumber = obj.get("vc_rule_hidden");
            params.put("vc_number", vcNumber);
            if (kd.bos.util.StringUtils.isEmpty((String)D.s((Object)obj.get("vc_rule"))) && !kd.bos.util.StringUtils.isEmpty((String)D.s((Object)vcNumber))) {
                DeleteServiceHelper.delete((String)"epdm_etl_vc_form", (QFilter[])new QFilter[]{new QFilter("number", "=", vcNumber)});
            }
            params.put("input", obj.get("src_column"));
            params.put("output", obj.get("tar_column"));
            FormOpener.showForm((AbstractFormPlugin)form, (String)"epdm_etl_vc_form_window", (String)ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219", (String)"DataQueryUtil_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), params, (String)"mapping_vc_rule");
            return;
        }
        form.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6e90\u5b57\u6bb5\u548c\u76ee\u6807\u5b57\u6bb5\u3002", (String)"DataQueryUtil_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
    }

    private static void showNoticeSendForm(AbstractFormPlugin form, IDataModel model, String fieldKey) {
        IFormView view = form.getView();
        long outputId = DataQueryUtil.getEntityId("notice_tar", model);
        if (outputId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9 \u5b9e\u4f53 / \u6570\u636e\u8868 / \u89c6\u56fe \u6570\u636e\u6a21\u578b\u3002", (String)"DataQueryUtil_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            HashMap<String, Long> param = new HashMap<String, Long>(16);
            param.put("resourceId", outputId);
            String callBackKey = "newbtn_ok".equals(fieldKey) ? "success_notice" : "failed_notice";
            FormOpener.showForm((AbstractFormPlugin)form, (String)"epdm_etl_notice_send", (String)ResManager.loadKDString((String)"\u6d88\u606f\u901a\u77e5", (String)"DataQueryUtil_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]), param, (String)callBackKey);
        }
    }

    private static void showMappingOutputParamsForm(AbstractFormPlugin form, IDataModel model, String fieldKey, int row) {
        long outputId = DataQueryUtil.getEntityId(fieldKey, model);
        if (outputId == 0L) {
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u6570\u636e\u3002", (String)"DataQueryUtil_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (fieldKey.equals("aggr_fn")) {
            HashMap<String, Integer> params = new HashMap<String, Integer>(16);
            params.put("$row", row);
            FormOpener.showForm((AbstractFormPlugin)form, (String)"isc_aggr_fn_selecor", (String)ResManager.loadKDString((String)"\u9009\u62e9\u805a\u5408\u51fd\u6570", (String)"DataQueryUtil_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]), params, (String)"get_aggr_fn");
        } else {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            HashMap<String, Object> customData = new HashMap<String, Object>(16);
            customData.put("$row", row);
            customData.put("#FLAG", fieldKey);
            param.put("customData", customData);
            param.put("resourceId", outputId);
            param.put("single", Boolean.FALSE);
            if ("tar_column".equals(fieldKey)) {
                String entryName = DataQueryUtil.getEntryName(fieldKey);
                DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
                List selectList = entryEntity.stream().map(o -> o.getString(fieldKey)).collect(Collectors.toList());
                param.put("selectList", selectList);
            } else if ("src_column".equals(fieldKey)) {
                DynamicObjectCollection entryEntity = model.getEntryEntity("result_fields");
                List filterList = entryEntity.stream().map(o -> o.getString("field_name")).collect(Collectors.toList());
                param.put("filterList", filterList);
            }
            FormOpener.showForm((AbstractFormPlugin)form, (String)"epdm_etl_field_select", (String)"", param, (String)"get_fields");
        }
    }

    public static void setReturnVariable(ClosedCallBackEvent evt, IFormView view, String entries, String key, String rowField) {
        Object data = evt.getReturnData();
        if (data == null) {
            return;
        }
        Map map = (Map)data;
        Object rowValue = map.get("$row");
        Object expression = map.get(key);
        if (rowValue != null && expression != null) {
            DynamicObject row = view.getModel().getEntryRowEntity(entries, D.i(rowValue));
            row.set(rowField, (Object)D.s(expression));
            if ("vc_rule".equals(rowField)) {
                row.set("vc_rule_hidden", (Object)D.s(expression));
            }
            view.updateView(entries);
        }
    }

    public static List<String> findReMappingList(IDataModel model, List<Map<String, Object>> dataList) {
        int index = 0;
        ArrayList<String> reMapping = new ArrayList<String>();
        if (null != dataList && !dataList.isEmpty()) {
            String tarCol;
            DynamicObjectCollection entries = model.getDataEntity(true).getDynamicObjectCollection("mapping_entries");
            HashMap<String, Boolean> tarSrcMapping = new HashMap<String, Boolean>(16);
            for (DynamicObject obj : entries) {
                tarCol = obj.getString("tar_column");
                if (kd.bos.util.StringUtils.isEmpty((String)obj.getString("src_column")) && kd.bos.util.StringUtils.isEmpty((String)obj.getString("fixed_value"))) continue;
                tarSrcMapping.put(tarCol, true);
            }
            int size = entries.size();
            for (Map<String, Object> map : dataList) {
                DynamicObject object;
                int row;
                Map customData = (Map)map.get("customData");
                if ("src_column".equals(customData.get("#FLAG")) && (row = D.i(customData.get("$row")) + index) < size && tarSrcMapping.containsKey(tarCol = (object = (DynamicObject)entries.get(row)).getString("tar_column"))) {
                    reMapping.add(tarCol);
                }
                ++index;
            }
        }
        return reMapping;
    }

    public static void setMappingFields(AbstractFormPlugin form, IDataModel model, List<Map<String, Object>> dataList) {
        DynamicObjectCollection entries = model.getDataEntity(true).getDynamicObjectCollection("mapping_entries");
        if (null != dataList && !dataList.isEmpty()) {
            DataQueryUtil.updateMappingEntryByDataList(entries, dataList);
            form.getView().updateView("mapping_entries");
        }
    }

    private static void updateMappingEntryByDataList(DynamicObjectCollection entries, List<Map<String, Object>> dataList) {
        int index = 0;
        for (Map<String, Object> map : dataList) {
            DynamicObject object;
            int row;
            Map customData = (Map)map.get("customData");
            if ("src_column".equals(customData.get("#FLAG"))) {
                row = D.i(customData.get("$row")) + index;
                if (row < entries.size() && null != (object = (DynamicObject)entries.get(row)) && !kd.bos.util.StringUtils.isEmpty((String)object.getString("tar_column"))) {
                    object.set("src_column", map.get("fullnumber"));
                    object.set("src_desc", (Object)DataQueryUtil.buildMappingDesc(map));
                    object.set("fixed_value", null);
                }
            } else {
                row = D.i(customData.get("$row")) + index;
                object = IDataModelUtils.addNewMappingEntry((DynamicObjectCollection)entries, (long)IDService.get().genLongId(), (int)row);
                object.set("tar_column", map.get("fullnumber"));
                object.set("tar_desc", (Object)DataQueryUtil.buildMappingDesc(map));
            }
            ++index;
        }
    }

    private static String buildMappingDesc(Map<String, Object> map) {
        String desc = D.s((Object)map.get("label"));
        if (D.x((Object)map.get("is_primary_key"))) {
            desc = String.format(ResManager.loadKDString((String)"%s-\u4e3b\u952e", (String)"DataQueryUtil_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), desc);
        }
        if (D.x((Object)map.get("is_required"))) {
            desc = String.format(ResManager.loadKDString((String)"%s-\u5fc5\u586b", (String)"DataQueryUtil_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]), desc);
        }
        return desc;
    }

    private static void showFilterValueFixedForm(AbstractFormPlugin form, IDataModel model, String fieldKey, int row) {
        long outputId = DataQueryUtil.getEntityId(fieldKey, model);
        if (outputId == 0L) {
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u67e5\u8be2\u6761\u4ef6\u53c2\u6570\u3002", (String)"DataQueryUtil_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        String entryName = DataQueryUtil.getEntryName(fieldKey);
        DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
        List selectList = entryEntity.stream().map(o -> {
            String value = o.getString(fieldKey);
            if (value != null && value.startsWith("<%") && value.endsWith("%>")) {
                return value.substring(2, value.length() - 2);
            }
            return "";
        }).collect(Collectors.toList());
        Map<String, Object> param = DataQueryUtil.prepareParam(row, outputId);
        param.put("single", Boolean.TRUE);
        param.put("selectList", selectList);
        FormOpener.showForm((AbstractFormPlugin)form, (String)"epdm_etl_field_select", (String)"", param, (String)"filter_value_fixed");
    }

    private static Map<String, Object> prepareParam(int row, long outputId) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        HashMap<String, Integer> customData = new HashMap<String, Integer>(16);
        customData.put("$row", row);
        param.put("customData", customData);
        param.put("resourceId", outputId);
        return param;
    }

    public static void showOutputForm(AbstractFormPlugin form, IDataModel model, String fieldKey, int row) {
        IFormView view = form.getView();
        long outputId = DataQueryUtil.getEntityId(fieldKey, model);
        if (outputId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9 \u5b9e\u4f53 / \u6570\u636e\u8868 / \u89c6\u56fe \u6570\u636e\u6a21\u578b\u3002", (String)"DataQueryUtil_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        } else {
            String entryName = DataQueryUtil.getEntryName(fieldKey);
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            HashMap<String, Integer> customData = new HashMap<String, Integer>(16);
            customData.put("$row", row);
            param.put("customData", customData);
            param.put("resourceId", outputId);
            if ("sort_field".equals(fieldKey) || "field_name_tar".equals(fieldKey) || "field_name".equals(fieldKey)) {
                DynamicObjectCollection entryEntity = model.getEntryEntity(entryName);
                List selectList = entryEntity.stream().map(o -> o.getString(fieldKey)).collect(Collectors.toList());
                param.put("selectList", selectList);
            }
            FormOpener.showForm((AbstractFormPlugin)form, (String)"epdm_etl_field_select", (String)"", param, (String)entryName);
        }
    }

    public static void setFields(IDataModel model, IFormView view, Object returnData, String entryName) throws KDBizException {
        if (returnData instanceof List) {
            DynamicObjectCollection entries = model.getDataEntity(true).getDynamicObjectCollection(entryName);
            List dataList = (List)returnData;
            if (!dataList.isEmpty()) {
                DataQueryUtil.updateEntryByDataList(entries, dataList, model, view);
                view.updateView(entryName);
            }
        }
    }

    public static Set<String> getExistedFieldSet(DynamicObjectCollection selectors, String entryName) throws KDBizException {
        HashSet<String> fieldSet = new HashSet<String>();
        if (!"filters".equals(entryName)) {
            for (DynamicObject selector : selectors) {
                String field = D.s((Object)selector.get(DataQueryUtil.getFieldNameByEntries(entryName)));
                if (field == null) continue;
                fieldSet.add(field);
            }
        }
        return fieldSet;
    }

    public static long getEntityId(String fieldKey, IDataModel model) {
        DynamicObject dynamicObject = fieldKey.startsWith("tar_") || fieldKey.endsWith("_tar") ? (DynamicObject)model.getValue("datamodetar") : (DynamicObject)model.getValue("datamodesrc");
        return null == dynamicObject ? 0L : dynamicObject.getLong("id");
    }

    public static String getEntryName(String fieldKey) {
        switch (fieldKey) {
            case "src_column": 
            case "tar_column": 
            case "aggr_fn": 
            case "vc_rule": {
                return "mapping_entries";
            }
            case "field_name": {
                return "result_fields";
            }
            case "field_name_tar": {
                return "tar_fields";
            }
            case "sort_field": {
                return "order_by_fields";
            }
            case "filter_column": 
            case "filter_value_fixed": {
                return "filters";
            }
        }
        return "";
    }

    public static int getEntryRowIndex(AbstractFormPlugin form, String fieldKey) {
        String entryName = DataQueryUtil.getEntryName(fieldKey);
        return IDataModelUtils.getEntryRowIndex((AbstractFormPlugin)form, (String)entryName);
    }

    public static void autofill(String fieldKey, IFormView view, IDataModel model) {
        long dataModelId = DataQueryUtil.getEntityId(fieldKey, model);
        String entryName = DataQueryUtil.getEntryName(fieldKey);
        if (dataModelId != 0L) {
            List fields = EtlFieldSelectFormPluginHelper.getFieldsByDataModel((Long)dataModelId, null, null);
            model.setValue(entryName, (Object)DataQueryUtil.toObjectCollection(fields, entryName, model));
            view.updateView(entryName);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6a21\u578b\u3002", (String)"DataQueryUtil_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    public static void updateMapping(IFormView view, IDataModel model) {
        String tarEntity = "tar_fields";
        String srcEntity = "result_fields";
        String entryName = "mapping_entries";
        DynamicObjectCollection mappingEntries = model.getEntryEntity(entryName);
        DynamicObjectCollection tarObjects = model.getEntryEntity(tarEntity);
        if (tarObjects.isEmpty()) {
            mappingEntries.clear();
            view.updateView(entryName);
            return;
        }
        if (mappingEntries.isEmpty()) {
            for (DynamicObject tarObject : tarObjects) {
                DynamicObject entry = mappingEntries.addNew();
                String col = tarObject.getString("field_name_tar");
                if (kd.bos.util.StringUtils.isEmpty((String)col)) continue;
                entry.set("tar_column", (Object)col);
                entry.set("tar_desc", tarObject.get("field_label_tar"));
            }
        } else {
            String col;
            HashMap<String, DynamicObject> mappingMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject row : mappingEntries) {
                col = row.getString("tar_column");
                mappingMap.put(col, row);
            }
            mappingEntries.clear();
            for (DynamicObject tarObject : tarObjects) {
                DynamicObject sub;
                col = (String)tarObject.get("field_name_tar");
                if (kd.bos.util.StringUtils.isEmpty((String)col)) continue;
                if (mappingMap.containsKey(col)) {
                    sub = (DynamicObject)mappingMap.get(col);
                    sub.set("id", (Object)IDService.get().genLongId());
                    mappingEntries.add((Object)sub);
                    continue;
                }
                sub = mappingEntries.addNew();
                sub.set("tar_column", (Object)col);
                sub.set("tar_desc", tarObject.get("field_label_tar"));
            }
            DynamicObjectCollection srcObjects = model.getEntryEntity(srcEntity);
            if (!srcObjects.isEmpty()) {
                HashMap<String, DynamicObject> srcMap = new HashMap<String, DynamicObject>(16);
                for (DynamicObject srcObject : srcObjects) {
                    col = (String)srcObject.get("field_name");
                    srcMap.put(col, srcObject);
                }
                for (DynamicObject row : mappingEntries) {
                    col = row.getString("src_column");
                    if (kd.bos.util.StringUtils.isEmpty((String)col) || srcMap.containsKey(col)) continue;
                    row.set("src_column", (Object)"");
                    row.set("src_desc", (Object)"");
                }
            }
        }
        model.getDataEntity(true).set(entryName, (Object)mappingEntries);
        view.updateView(entryName);
    }

    public static void autoMapping(IFormView view, IDataModel model) {
        DataQueryUtil.autoMapping("tar_fields", "result_fields", view, model, "mapping_entries", true);
    }

    public static void autoMapping(String tarEntity, String srcEntity, IFormView view, IDataModel model, String entryName, boolean showTips) {
        DynamicObjectCollection srcObjects = model.getEntryEntity(srcEntity);
        if (srcObjects.isEmpty()) {
            if (showTips) {
                view.showTipNotification(ResManager.loadKDString((String)"\u6e90\u53d6\u6570\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataQueryUtil_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        DynamicObjectCollection tarObjects = model.getEntryEntity(tarEntity);
        if (tarObjects.isEmpty()) {
            if (showTips) {
                view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataQueryUtil_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        HashMap<String, SimilarityPair> mappingRs = new HashMap<String, SimilarityPair>(16);
        double matchRatio = 0.0;
        HashMap<String, Double> maxRatioMap = new HashMap<String, Double>(16);
        for (DynamicObject tar : tarObjects) {
            String srcCol;
            String tarCol = tar.getString("field_name_tar");
            for (DynamicObject src : srcObjects) {
                srcCol = src.getString("field_name");
                matchRatio = StringSimilarityUtil.calculateSimilarity(null, (CharSequence)tarCol, (CharSequence)srcCol);
                if (!maxRatioMap.containsKey(srcCol) || matchRatio > (Double)maxRatioMap.get(srcCol)) {
                    maxRatioMap.put(srcCol, matchRatio);
                }
                if (!(matchRatio >= 0.8) || !(matchRatio >= (Double)maxRatioMap.get(srcCol)) || mappingRs.containsKey(tarCol) && !(((SimilarityPair)mappingRs.get(tarCol)).getMatchRatio() < matchRatio)) continue;
                mappingRs.put(tarCol, new SimilarityPair((Object)tar, (Object)src, matchRatio));
            }
            for (DynamicObject src : srcObjects) {
                if (mappingRs.containsKey(tarCol)) continue;
                srcCol = src.getString("field_name");
                matchRatio = StringSimilarityUtil.calculateSimilarity(null, (CharSequence)tar.getString("field_label_tar"), (CharSequence)src.getString("field_label"));
                if (!maxRatioMap.containsKey(srcCol) || matchRatio > (Double)maxRatioMap.get(srcCol)) {
                    maxRatioMap.put(srcCol, matchRatio);
                }
                if (!(matchRatio >= 0.8) || !(matchRatio >= (Double)maxRatioMap.get(srcCol)) || mappingRs.containsKey(tarCol) && !(((SimilarityPair)mappingRs.get(tarCol)).getMatchRatio() < matchRatio)) continue;
                mappingRs.put(tarCol, new SimilarityPair((Object)tar, (Object)src, matchRatio));
            }
        }
        DynamicObjectCollection entries = model.getEntryEntity(entryName);
        entries.clear();
        int size = tarObjects.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = entries.addNew();
            String col = (String)((DynamicObject)tarObjects.get(i)).get("field_name_tar");
            entry.set("tar_column", (Object)col);
            entry.set("tar_desc", ((DynamicObject)tarObjects.get(i)).get("field_label_tar"));
            if (!mappingRs.containsKey(col)) continue;
            entry.set("src_column", ((DynamicObject)((SimilarityPair)mappingRs.get(col)).getValue()).get("field_name"));
            entry.set("src_desc", ((DynamicObject)((SimilarityPair)mappingRs.get(col)).getValue()).get("field_label"));
        }
        model.setValue(entryName, (Object)entries);
        view.updateView(entryName);
    }

    public static DynamicObjectCollection toObjectCollection(List<Map<String, Object>> list, String entryName, IDataModel model) {
        DynamicObjectCollection entries = model.getEntryEntity(entryName);
        entries.clear();
        if (!CollectionUtils.isEmpty(list)) {
            for (Map<String, Object> rowMap : list) {
                if (("result_fields".equals(entryName) || "tar_fields".equals(entryName)) && "REF".equals(rowMap.get("data_type"))) continue;
                DynamicObject entry = entries.addNew();
                DataQueryUtil.mapToObject(rowMap, entry, entryName);
            }
        }
        return entries;
    }

    public static void openBaseInfoForm(AbstractFormPlugin form, Object pkId, String closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setParentPageId(form.getView().getPageId());
        formShowParameter.setFormId("epdm_etl_info");
        if (pkId != null) {
            formShowParameter.setCustomParam("id", pkId);
            formShowParameter.setCustomParam("actType", (Object)"edit");
        } else {
            formShowParameter.setCustomParam("id", null);
            formShowParameter.setCustomParam("actType", (Object)"new");
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)form, closeCallBack));
        form.getView().showForm(formShowParameter);
    }

    public static void openBaseList(AbstractFormPlugin form, int width, int height, String fromId) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setShowTitle(false);
        StyleCss css = new StyleCss();
        css.setHeight(height + "px");
        css.setWidth(width + "px");
        formShowParameter.getOpenStyle().setInlineStyleCss(css);
        formShowParameter.setBillFormId(fromId);
        form.getView().showForm((FormShowParameter)formShowParameter);
    }

    private static void mapToObject(Map<String, Object> rowMap, DynamicObject entry, String entryName) {
        if ("filters".equals(entryName)) {
            entry.set("id", rowMap.get("id"));
            entry.set("filter_column", rowMap.get("field"));
            entry.set("filter_type", rowMap.get("filter_type"));
            entry.set("filter_label", rowMap.get("label"));
            entry.set("filter_compare", rowMap.get("filter_compare"));
            entry.set("filter_value_fixed", rowMap.get("filter_value_fixed"));
            DataEntityPropertyCollection properties = entry.getDataEntityType().getProperties();
            boolean isDataQueryFilter = properties.containsKey((Object)"filter_left_bracket");
            if (isDataQueryFilter) {
                entry.set("filter_left_bracket", rowMap.get("filter_left_bracket"));
                entry.set("filter_right_bracket", rowMap.get("filter_right_bracket"));
                entry.set("filter_link", rowMap.get("filter_link"));
            }
            if (properties.containsKey((Object)"param_label")) {
                entry.set("param_label", rowMap.get("param_label"));
            }
        } else if ("result_fields".equals(entryName)) {
            entry.set("id", rowMap.get("id"));
            entry.set("field_name", rowMap.get("fullnumber"));
            entry.set("data_type", rowMap.get("data_type"));
            entry.set("field_label", rowMap.get("label"));
        } else if ("tar_fields".equals(entryName)) {
            entry.set("id", rowMap.get("id"));
            entry.set("field_name_tar", rowMap.get("fullnumber"));
            entry.set("data_type_tar", rowMap.get("data_type"));
            entry.set("field_label_tar", rowMap.get("label"));
            entry.set("is_required", rowMap.get("is_required"));
        } else if ("order_by_fields".equals(entryName)) {
            entry.set("id", rowMap.get("id"));
            entry.set("sort_field", rowMap.get("field"));
            entry.set("sort_field_label", rowMap.get("label"));
            entry.set("sort_mode", rowMap.get("sort_mode"));
        }
    }

    public static void setFilterValueFixed(DynamicObject obj) {
        if (D.x((Object)obj.get("isvar"))) {
            if (!StringUtils.isEmpty((CharSequence)obj.getString("filter_column")) && !StringUtils.isEmpty((CharSequence)obj.getString("filter_compare"))) {
                CompareTypeEnum compareType = CompareTypeEnum.get((String)obj.getString("filter_compare"));
                String value = (obj.getString("filter_column") + "_" + compareType.name()).toLowerCase(Locale.ROOT);
                if (!kd.bos.util.StringUtils.isEmpty((String)value)) {
                    value = value.replace(".", "_");
                }
                value = "<%" + value + "%>";
                obj.set("filter_value_fixed", (Object)value);
            }
        } else {
            String val = obj.getString("filter_value_fixed");
            if (null != val && val.startsWith("<%")) {
                obj.set("filter_value_fixed", (Object)"");
            }
        }
    }

    public static void mapToEntry(String entryName, Map<String, Object> dataMap, Object field, DynamicObject entry) {
        entry.set("id", (Object)ID.genLongId());
        switch (entryName) {
            case "filters": {
                entry.set("filter_column", field);
                entry.set("filter_label", dataMap.get("label"));
                entry.set("filter_type", dataMap.get("type"));
                DataQueryUtil.setFilterValueFixed(entry);
                break;
            }
            case "result_fields": {
                entry.set("field_name", field);
                entry.set("data_type", dataMap.get("type"));
                entry.set("field_label", dataMap.get("label"));
                break;
            }
            case "tar_fields": {
                entry.set("field_name_tar", field);
                entry.set("data_type_tar", dataMap.get("type"));
                entry.set("field_label_tar", dataMap.get("label"));
                entry.set("is_required", dataMap.get("is_required"));
                break;
            }
            default: {
                entry.set("sort_field", field);
                entry.set("sort_field_label", dataMap.get("label"));
            }
        }
    }

    private static String getFieldNameByEntries(String entryName) throws KDException {
        if ("filters".equals(entryName)) {
            return "filter_column";
        }
        if ("result_fields".equals(entryName)) {
            return "field_name";
        }
        if ("tar_fields".equals(entryName)) {
            return "field_name_tar";
        }
        if ("order_by_fields".equals(entryName)) {
            return "sort_field";
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570entryName\u4e0d\u5408\u6cd5\uff0c\u6ca1\u6709\u6807\u8bc6\u540d\u4e3a[%s]\u7684\u5206\u5f55\u3002", (String)"DataQueryUtil_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]), entryName));
    }

    private static void updateEntryByDataList(DynamicObjectCollection entries, List<Map<String, Object>> dataList, IDataModel model, IFormView view) throws KDException {
        String entryName = entries.getDynamicObjectType().getName();
        Map<String, Object> firstRecord = dataList.get(0);
        Object customData = firstRecord.get("customData");
        if (customData instanceof Map) {
            int index = D.i(((Map)customData).get("$row"));
            Set<String> fieldSet = DataQueryUtil.getExistedFieldSet(entries, entryName);
            if (dataList.size() == 1) {
                DataQueryUtil.updateOneRecord(dataList, index, fieldSet, entryName, model, view);
            } else {
                DynamicObject entry = model.getEntryRowEntity(entryName, index);
                String col = DataQueryUtil.getFieldNameByEntries(entryName);
                if (null != entry && kd.bos.util.StringUtils.isEmpty((String)entry.getString(col))) {
                    entries.remove(index);
                }
                DataQueryUtil.updateSelectors(entries, index, dataList, fieldSet, entryName);
            }
        }
    }

    private static void updateOneRecord(List<Map<String, Object>> dataList, int index, Set<String> fieldSet, String entryName, IDataModel model, IFormView view) {
        Map<String, Object> dataMap = dataList.get(0);
        Object field = dataMap.get("fullnumber");
        if (!fieldSet.contains(field)) {
            DynamicObject entry = model.getEntryRowEntity(entryName, index);
            DataQueryUtil.mapToEntry(entryName, dataMap, field, entry);
        } else {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u3010%s\u3011\u5df2\u5b58\u5728\u3002", (String)"DataQueryUtil_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]), field));
        }
    }

    private static void updateSelectors(DynamicObjectCollection entries, int index, List<Map<String, Object>> dataList, Set<String> fieldSet, String entryName) {
        for (Map<String, Object> dataMap : dataList) {
            Object field = dataMap.get("fullnumber");
            if (fieldSet.contains(field)) continue;
            DynamicObject entry = IDataModelUtils.insertEntries((int)(++index), (DynamicObjectCollection)entries);
            DataQueryUtil.mapToEntry(entryName, dataMap, field, entry);
        }
    }
}

