/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.importscheme;

import java.util.HashMap;
import java.util.List;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.business.importscheme.EPDMImportLogHelper;

public class EPDMImportLogListPlugin
extends AbstractBaseListPlugin {
    private static final String BILL_LIST = "billlistap";
    public static final String SCHEME_IDS = "scheme_ids";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl(BILL_LIST);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object schemeIds = parameter.getCustomParam(SCHEME_IDS);
        billList.addSetFilterListener(event -> {
            List qFilters = event.getQFilters();
            if (null != schemeIds) {
                qFilters.add(new QFilter("scheme", "in", schemeIds));
            }
        });
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent event = args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)event).getCurrentRow();
        Object primaryKeyValue = currentRow.getPrimaryKeyValue();
        if (EPDMImportLogHelper.isRunning((Object)primaryKeyValue)) {
            this.openImporting(primaryKeyValue);
            args.setCancel(true);
        }
    }

    private void openImporting(Object logId) {
        long schemeId = EPDMImportLogHelper.queryScheme((Object)logId);
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("importscheme", schemeId);
        map.put("logId", String.valueOf(logId));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epdm_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        showParameter.setParentPageId(showParam.getParentPageId());
        showParameter.setCloseCallBack(showParam.getCloseCallBack());
        showParameter.setCustomParams(map);
        this.getView().showForm(showParameter);
    }
}

