/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.importscheme;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.business.importscheme.EPDMImportSchemeHelper;
import kd.epm.epdm.common.constant.EPDMImportSchemeConstant;

public class EPDMImportSchemeListPlugin
extends AbstractBaseListPlugin {
    private static final String IMPORT_START = "importstart";
    private static final String IMPORT_LOG = "importlog";

    @Override
    public String getFormId(PreOpenFormEventArgs e) {
        String formId = ((FormShowParameter)e.getSource()).getFormId();
        if (e.getFormShowParameter() instanceof ListShowParameter) {
            formId = ((ListShowParameter)e.getFormShowParameter()).getBillFormId();
        }
        return formId;
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("attachment_name".equals(args.getFieldName())) {
            BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = event.getCurrentRow();
            Object primaryKeyValue = currentRow.getPrimaryKeyValue();
            String fullUrl = EPDMImportSchemeHelper.queryFullUrlById((Object)primaryKeyValue);
            this.getView().download(fullUrl);
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if (IMPORT_START.equals(operateKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            this.focusAbleIdSet(showParameter);
            showParameter.setFormId("epdm_importstart");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (IMPORT_LOG.equals(operateKey)) {
            ListShowParameter para = new ListShowParameter();
            para.setBillFormId("epdm_importlog");
            para.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            para.getOpenStyle().setInlineStyleCss(css);
            this.selectedSchemeIds(para);
            this.getView().showForm((FormShowParameter)para);
        }
    }

    private void selectedSchemeIds(ListShowParameter para) {
        Set collect = this.getBillList().getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            para.setCustomParam("scheme_ids", collect);
        }
    }

    private void focusAbleIdSet(FormShowParameter showParameter) {
        Object focusRowPkId = this.getBillList().getFocusRowPkId();
        QFBuilder qf = new QFBuilder("id", "=", focusRowPkId).and("billstatus", "=", (Object)EPDMImportSchemeConstant.BillStatus.B.name());
        if (QueryServiceHelper.exists((String)"epdm_importscheme", (QFilter[])qf.toArray())) {
            showParameter.setCustomParam("importscheme", focusRowPkId);
        }
    }
}

