/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.importscheme;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epdm.business.datamodel.helper.DataModelServiceHelper;
import kd.epm.epdm.business.importscheme.EPDMAbstractImportService;
import kd.epm.epdm.business.importscheme.EPDMImportSchemeAttService;
import kd.epm.epdm.business.importscheme.EPDMImportSchemeHelper;
import kd.epm.epdm.common.constant.EPDMImportSchemeConstant;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import kd.epm.epdm.common.function.IRunnable;

public class EPDMImportSchemePlugin
extends AbstractBasePlugIn {
    private static final String ENABLE_OP = "enable";
    private static final String BTN_SAVEANDNEW = "btn_saveandnew";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_DISABLE = "btn_disable";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getControl("datamodel");
        control.addBeforeF7SelectListener(event -> event.addCustomQFilter(new QFilter("type", "=", (Object)ResourceTypeEnum.DataTable.getNumber())));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeButtonState();
        this.initCombo();
        boolean dataChanged = this.getModel().getDataChanged();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW == status) {
            Object isCopy = formShowParameter.getCustomParam("iscopy");
            if (Boolean.TRUE.equals(isCopy)) {
                Object number = this.getModel().getValue("number");
                Object name = this.getModel().getValue("name");
                this.getModel().setValue("number", (Object)String.format("%1$s_copy", number));
                this.getModel().setValue("name", (Object)String.format(ResManager.loadKDString((String)"%1$s_\u590d\u5236", (String)"EPDMImportSchemePlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), name));
            } else {
                DynamicObject dy;
                String entityName;
                ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
                CodeRuleInfo codeRule = service.getCodeRule(entityName = "epdm_importscheme", dy = BusinessDataServiceHelper.newDynamicObject((String)entityName), null);
                if (codeRule != null) {
                    dy.set("createtime", (Object)TimeServiceHelper.now());
                    String number = service.getNumber(entityName, dy, null);
                    this.getModel().setValue("number", (Object)number);
                }
                Optional.ofNullable(this.getView()).map(IFormView::getParentView).map(view -> view.getControl("treeviewap")).map(TreeView.class::cast).map(TreeView::getTreeState).map(TreeView.TreeState::getFocusNodeId).filter(StringUtils::isNotEmpty).map(Long::parseLong).ifPresent(category -> this.getModel().setValue("category", category));
                this.defaultStartRowAndCol();
            }
        }
        this.synchronizeConfig();
        this.getModel().setDataChanged(dataChanged);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save) {
            this.checkNumberName();
            this.defaultCategory();
            this.defaultStartRowAndCol();
        } else if (source instanceof StatusConvert && this.getModel().getDataChanged() && ENABLE_OP.equals(((StatusConvert)source).getOperateKey())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\u3002", (String)"EPDMImportSchemePlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        this.changeButtonState();
        String operateKey = eventArgs.getOperateKey();
        if ("disable".equals(operateKey)) {
            boolean dataChanged = this.getModel().getDataChanged();
            this.synchronizeConfig();
            this.getModel().setDataChanged(dataChanged);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        String name = e.getProperty().getName();
        if ("datamodel".equals(name)) {
            this.initEntryEntity((DynamicObject)newValue);
        } else if ("attachment".equals(name)) {
            IRunnable task = () -> {
                this.changeSheetCombo();
                this.changeColNameCombo();
            };
            this.wrapTask((MulBasedataDynamicObjectCollection)newValue, task);
        } else if ("startcol".equals(name) || "startrow".equals(name)) {
            this.changeColNameCombo();
        } else if ("sheet".equals(name)) {
            this.changeColNameCombo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapTask(MulBasedataDynamicObjectCollection newValue, IRunnable task) {
        if (newValue.isEmpty()) {
            task.run();
        } else {
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790\u9644\u4ef6\u3002", (String)"EPDMImportSchemePlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
                task.run();
                String type = ((DynamicObject)newValue.get(0)).getDynamicObject("fbasedataid").getString("type");
                Integer startRow = (Integer)this.getModel().getValue("startrow");
                if (startRow == null || startRow < 1) {
                    this.getModel().setValue("startrow", (Object)1);
                }
                Object startCol = this.getModel().getValue("startcol");
                String newStartCol = Optional.ofNullable(startCol).map(String.class::cast).filter(StringUtils::isNotEmpty).map(col -> EPDMImportSchemeHelper.startColConvert((String)col, (String)type)).orElseGet(() -> EPDMImportSchemeHelper.startColDefault((String)type));
                this.getModel().setValue("startcol", (Object)newStartCol);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void initEntryEntity(DynamicObject newDataModel) {
        if (newDataModel == null) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Object pkValue = newDataModel.getPkValue();
        Map supplierMap = pkValue instanceof Long ? EPDMAbstractImportService.DEFAULT_FIELD.getOrDefault((Long)pkValue, Collections.emptyMap()) : Collections.emptyMap();
        DataModelServiceHelper serviceHelper = new DataModelServiceHelper();
        JSONArray fields = serviceHelper.getDataModelFields(pkValue);
        fields.removeIf(row -> supplierMap.containsKey(((JSONObject)row).getString("field").toUpperCase(Locale.ROOT)));
        this.getModel().deleteEntryData("entryentity");
        if (!fields.isEmpty()) {
            this.getModel().batchCreateNewEntryRow("entryentity", fields.size());
        }
        int i = 0;
        for (Object row2 : fields) {
            JSONObject rowJson = (JSONObject)row2;
            String field = rowJson.getString("field");
            Object content = rowJson.get((Object)"label");
            boolean required = Optional.ofNullable(rowJson.getBoolean("is_required")).orElseGet(() -> false);
            this.getModel().setValue("fieldname", (Object)field, i);
            this.getModel().setValue("content", content, i);
            this.getModel().setValue("isrequired", (Object)required, i++);
        }
    }

    private void changeColNameCombo() {
        DynamicObjectCollection attachment = (DynamicObjectCollection)this.getModel().getValue("attachment");
        EPDMImportSchemeAttService service = new EPDMImportSchemeAttService(attachment);
        String sheetName = (String)this.getModel().getValue("sheet");
        String startCol = (String)this.getModel().getValue("startcol");
        if (!EPDMImportSchemeHelper.startColCheck((String)startCol)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u5217\u540d\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"EPDMImportSchemePlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        int startRow = Optional.ofNullable(this.getModel().getValue("startrow")).map(Integer.class::cast).orElseGet(() -> 0);
        List comboItems = service.analyzeColNameComboItems(sheetName, startCol, startRow);
        Set newColNames = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toSet());
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entry.get(i);
            String colName = dynamicObject.getString("colname");
            if (newColNames.contains(colName)) continue;
            this.getModel().setValue("colname", null, i);
        }
        ComboEdit combo = (ComboEdit)this.getControl("colname");
        combo.setComboItems(comboItems);
    }

    private void changeSheetCombo() {
        DynamicObjectCollection attachment = (DynamicObjectCollection)this.getModel().getValue("attachment");
        EPDMImportSchemeAttService service = new EPDMImportSchemeAttService(attachment);
        List comboItems = service.analyzeSheetComboItems();
        Object current = this.getModel().getValue("sheet");
        Optional<String> firstCurrentSelect = comboItems.stream().map(ComboItem::getValue).filter(value -> value.equals(current)).findFirst();
        if (!firstCurrentSelect.isPresent()) {
            this.getModel().setValue("sheet", null);
        }
        ComboEdit combo = (ComboEdit)this.getControl("sheet");
        combo.setComboItems(comboItems);
    }

    private void changeButtonState() {
        Object pkValue;
        Object customParam = this.getView().getFormShowParameter().getCustomParam("");
        if (null != customParam) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SAVEANDNEW});
        }
        if (null != (pkValue = this.getModel().getDataEntity().getPkValue()) && QueryServiceHelper.exists((String)"epdm_importscheme", (Object)pkValue)) {
            Object billStatus = this.getModel().getValue("billstatus");
            boolean enableStatus = EPDMImportSchemeConstant.BillStatus.B.name().equals(billStatus);
            this.getView().setEnable(Boolean.valueOf(!enableStatus), new String[]{BTN_ENABLE});
            this.getView().setEnable(Boolean.valueOf(enableStatus), new String[]{BTN_DISABLE});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_ENABLE, BTN_DISABLE});
        }
    }

    private void defaultStartRowAndCol() {
        String startCol;
        Object startRow = this.getModel().getValue("startrow");
        if (startRow == null) {
            this.getModel().setValue("startrow", (Object)1L);
        }
        if (StringUtils.isEmpty((String)(startCol = (String)this.getModel().getValue("startcol")))) {
            this.getModel().setValue("startcol", (Object)"A");
        }
    }

    private void defaultCategory() {
        QFBuilder qfBuilder;
        DynamicObjectCollection query;
        Object dataModel = this.getModel().getValue("category");
        if (dataModel == null && !(query = QueryServiceHelper.query((String)"epdm_importcategory", (String)"id", (QFilter[])(qfBuilder = new QFBuilder("number", "=", (Object)"root")).toArray())).isEmpty()) {
            this.getModel().setValue("category", (Object)((DynamicObject)query.get(0)).getLong("id"));
        }
    }

    private void checkNumberName() {
        String number = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((String)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPDMImportSchemePlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (number.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u957f\u5ea6\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EPDMImportSchemePlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        String localeValue = name.getLocaleValue();
        if (!StringUtils.isEmpty((String)localeValue) && localeValue.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EPDMImportSchemePlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
    }

    private void initCombo() {
        DynamicObjectCollection attachment = (DynamicObjectCollection)this.getModel().getValue("attachment");
        EPDMImportSchemeAttService service = new EPDMImportSchemeAttService(attachment);
        List sheetComboItems = service.analyzeSheetComboItems();
        ComboEdit combo = (ComboEdit)this.getControl("sheet");
        combo.setComboItems(sheetComboItems);
        String sheetName = (String)this.getModel().getValue("sheet");
        String startCol = (String)this.getModel().getValue("startcol");
        int startRow = Optional.ofNullable(this.getModel().getValue("startrow")).map(Integer.class::cast).orElseGet(() -> 0);
        List colNameComboItems = service.analyzeColNameComboItems(sheetName, startCol, startRow);
        ComboEdit colNameCombo = (ComboEdit)this.getControl("colname");
        colNameCombo.setComboItems(colNameComboItems);
    }

    private void synchronizeConfig() {
        Object status = this.getModel().getValue("billstatus");
        if (EPDMImportSchemeConstant.BillStatus.B.name().equals(status)) {
            return;
        }
        DynamicObject newDataModel = (DynamicObject)this.getModel().getValue("datamodel");
        if (newDataModel == null) {
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Object pkValue = newDataModel.getPkValue();
        Map supplierMap = pkValue instanceof Long ? EPDMAbstractImportService.DEFAULT_FIELD.getOrDefault((Long)pkValue, Collections.emptyMap()) : Collections.emptyMap();
        DataModelServiceHelper serviceHelper = new DataModelServiceHelper();
        JSONArray fields = serviceHelper.getDataModelFields(pkValue);
        fields.removeIf(row -> supplierMap.containsKey(((JSONObject)row).getString("field").toUpperCase(Locale.ROOT)));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Set oldFieldSet = entryEntity.stream().map(dy -> dy.getString("fieldname")).collect(Collectors.toSet());
        fields.removeIf(row -> oldFieldSet.contains(((JSONObject)row).getString("field")));
        for (Object row2 : fields) {
            JSONObject rowJson = (JSONObject)row2;
            int newEntryRow = this.getModel().createNewEntryRow("entryentity");
            String field = rowJson.getString("field");
            Object content = rowJson.get((Object)"label");
            boolean required = Optional.ofNullable(rowJson.getBoolean("is_required")).orElseGet(() -> false);
            this.getModel().setValue("fieldname", (Object)field, newEntryRow);
            this.getModel().setValue("content", content, newEntryRow);
            this.getModel().setValue("isrequired", (Object)required, newEntryRow);
        }
    }
}

