/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.importscheme;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epdm.common.constant.EPDMImportLogConstant;
import kd.epm.epdm.common.constant.EPDMImportSchemeConstant;
import kd.epm.epdm.common.enums.DataModelPresetEnum;

public class EPDMImportStartPlugin
extends AbstractFormPlugin
implements UploadListener {
    public static final String IMPORT_SCHEME = "importscheme";
    public static final String FILE_PATH = "filepath";
    private static final String BTN_OK = "btnok";
    public static final String BTN_RESETFILE = "btnresetfile";
    public static final String BTN_CLOSETIPS = "btnclosetips";
    public static final String IMPORT_TYPE = "importtype";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BTN_CLOSETIPS, BTN_RESETFILE, BTN_OK});
        Image upload = (Image)this.getControl("btnupload");
        upload.addUploadListener((UploadListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit importScheme = (BasedataEdit)this.getControl(IMPORT_SCHEME);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object param = parameter.getCustomParam("datamodel");
        importScheme.addBeforeF7SelectListener(event -> {
            List customQFilters = event.getCustomQFilters();
            if (param instanceof Number) {
                customQFilters.add(new QFilter("datamodel", "=", param));
            }
            customQFilters.add(new QFilter("billstatus", "=", (Object)EPDMImportSchemeConstant.BillStatus.B.name()));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object importScheme = parameter.getCustomParam(IMPORT_SCHEME);
        this.getModel().setValue(IMPORT_SCHEME, importScheme);
        this.getModel().setValue("keyfields", (Object)this.queryKeyFieldNames());
        Object param = parameter.getCustomParam("datamodel");
        Label label = (Label)this.getControl("title");
        if (DataModelPresetEnum.T_EPM_BALANCE.getId().equals(param)) {
            label.setText(ResManager.loadKDString((String)"\u4f59\u989d", (String)"EPDMImportStartPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else if (DataModelPresetEnum.T_EPM_VOUCHER.getId().equals(param)) {
            label.setText(ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"EPDMImportStartPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else {
            label.setText(ResManager.loadKDString((String)"EPM\u5e93", (String)"EPDMImportStartPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        this.showUpdateTips(Boolean.FALSE);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.uploadState(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button btOK = (Button)evt.getSource();
            String key = btOK.getKey();
            if (BTN_OK.equals(key)) {
                Map<String, Object> params = this.getParams();
                this.openImporting(params);
            } else if (BTN_RESETFILE.equals(key)) {
                this.getModel().setValue("filename", null);
                this.getModel().setValue(FILE_PATH, null);
                this.uploadState(false);
            } else if (BTN_CLOSETIPS.equals(key)) {
                this.showUpdateTips(Boolean.FALSE);
            }
        }
    }

    private void showUpdateTips(boolean isVisible) {
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"updatetipspanel"});
    }

    private Map<String, Object> getParams() {
        String importType = (String)this.getModel().getValue(IMPORT_TYPE);
        if (StringUtils.isEmpty((String)importType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u5bfc\u5165\u7c7b\u578b\u3002", (String)"EPDMImportStartPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        String filepath = (String)this.getModel().getValue(FILE_PATH);
        if (StringUtils.isEmpty((String)filepath)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u8981\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\u3002", (String)"EPDMImportStartPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        DynamicObject importScheme = (DynamicObject)this.getModel().getValue(IMPORT_SCHEME);
        if (null == importScheme) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u65b9\u6848\u3002", (String)"EPDMImportStartPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(IMPORT_TYPE, importType);
        params.put(IMPORT_SCHEME, importScheme.getPkValue());
        params.put(FILE_PATH, filepath);
        return params;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.setImportStartTypeTip(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (IMPORT_SCHEME.equals(name)) {
            this.getModel().setValue("keyfields", (Object)this.queryKeyFieldNames());
        }
    }

    public void afterUpload(UploadEvent evt) {
        super.afterBindData((EventObject)evt);
        Object[] names = evt.getNames();
        Object[] urls = evt.getUrls();
        if (names.length > 0) {
            String url = (String)urls[0];
            this.getModel().setValue("filename", (Object)url.substring(url.lastIndexOf("/") + 1));
            this.getModel().setValue(FILE_PATH, (Object)url);
            this.uploadState(true);
        }
    }

    private void openImporting(Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epdm_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        showParameter.setParentPageId(showParam.getParentPageId());
        showParameter.setCloseCallBack(showParam.getCloseCallBack());
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private void uploadState(boolean isUploaded) {
        this.getView().setVisible(Boolean.valueOf(isUploaded), new String[]{"filepaneluploadsuccess"});
        this.getView().setVisible(Boolean.valueOf(!isUploaded), new String[]{"uploadpanel"});
    }

    private String queryKeyFieldNames() {
        DynamicObject importScheme = (DynamicObject)this.getModel().getValue(IMPORT_SCHEME);
        if (null == importScheme) {
            return "";
        }
        Object pkValue = importScheme.getPkValue();
        String candidateKey = String.join((CharSequence)".", "entryentity", "iscandidatekey");
        QFBuilder qfBuilder = new QFBuilder("id", "=", pkValue).and(candidateKey, "=", (Object)true);
        String colName = String.join((CharSequence)".", "entryentity", "content");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epdm_importscheme", (String)colName, (QFilter[])qfBuilder.toArray());
        return dynamicObjects.stream().map(dy -> dy.getString(colName)).reduce((a, b) -> String.join((CharSequence)"+", a, b)).orElseGet(() -> "");
    }

    private void setImportStartTypeTip(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (IMPORT_TYPE.equalsIgnoreCase(propertyName)) {
            String importType = String.valueOf(this.getModel().getValue(propertyName));
            if (EPDMImportLogConstant.ImportTypeEnum.NEW_ADD.getNumber().equals(importType)) {
                this.updateTipContent(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u5728\u7cfb\u7edf\u4e2d\u6dfb\u52a0\u5168\u65b0\u7684\u6570\u636e\u3002", (String)"EPDMImportStartPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                this.showUpdateTips(Boolean.FALSE);
            }
            if (EPDMImportLogConstant.ImportTypeEnum.OVERRIDE.getNumber().equals(importType)) {
                this.updateTipContent(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u6839\u636e\u6570\u636e\u66ff\u6362\u89c4\u5219\u7684\u552f\u4e00\u503c\u5b9a\u4e49\u7684\u5339\u914d\u5b57\u6bb5\uff0c\u505a\u552f\u4e00\u6027\u5339\u914d\uff0c\u5339\u914d\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u7684\u552f\u4e00\u4e00\u6761\u6570\u636e\uff0c\u5bf9\u5176\u8fdb\u884c\u6570\u636e\u66f4\u65b0\u3002", (String)"EPDMImportStartPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                this.showUpdateTips(Boolean.TRUE);
            }
            if (EPDMImportLogConstant.ImportTypeEnum.OVERRIDE_NEW.getNumber().equals(importType)) {
                this.updateTipContent(ResManager.loadKDString((String)"\u5f15\u5165\u65f6\u5148\u6839\u636e\u66f4\u65b0\u89c4\u5219\uff0c\u5339\u914d\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u7684\u6570\u636e\u8fdb\u884c\u66f4\u65b0\uff0c\u672a\u5339\u914d\u5230\u7684\u6570\u636e\uff0c\u6309\u6dfb\u52a0\u65b0\u6570\u636e\u903b\u8f91\u6267\u884c\u3002", (String)"EPDMImportStartPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                this.showUpdateTips(Boolean.TRUE);
            }
        }
    }

    private void updateTipContent(String content) {
        HashMap controlMap = new HashMap();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("content", content);
        controlMap.put("tips", contentMap);
        this.getView().updateControlMetadata("labelap", controlMap);
    }
}

