/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.importscheme;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.epdm.business.importscheme.EPDMAbstractImportService;
import kd.epm.epdm.business.importscheme.EPDMImportInfo;
import kd.epm.epdm.business.importscheme.EPDMImportLogHelper;
import kd.epm.epdm.business.importscheme.EPDMImportServiceFactory;
import kd.epm.epdm.common.constant.EPDMImportLogConstant;

public class EPDMImportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String IMPORT_PROGRESS_ID = "IMPORT_PROGRESS_ID";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        progress.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnresult"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "btnok"});
        FormShowParameter params = this.getView().getFormShowParameter();
        Map customParams = params.getCustomParams();
        String logId = (String)customParams.get("logId");
        if (StringUtils.isEmpty((CharSequence)logId)) {
            long schemeId = (Long)customParams.get("importscheme");
            String importType = (String)customParams.get("importtype");
            EPDMImportLogConstant.ImportTypeEnum importTypeEnum = EPDMImportLogConstant.ImportTypeEnum.getImportTypeByNumber((String)importType);
            long logIdL = EPDMImportLogHelper.insertNewLog((long)schemeId, (EPDMImportLogConstant.ImportTypeEnum)importTypeEnum);
            logId = String.valueOf(logIdL);
        }
        this.getPageCache().put(IMPORT_PROGRESS_ID, logId);
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        try {
            progress.setPercent(0);
            progress.start();
        }
        catch (Exception var11) {
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"EPDMImportingPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            String errMsg = var11 instanceof KDBizException ? var11.getMessage() : ResManager.loadKDString((String)"\u5f15\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790", (String)"EPDMImportingPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errMsg);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label) {
            String logId = this.getPageCache().get(IMPORT_PROGRESS_ID);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("epdm_importlog");
            showParameter.setPkId((Object)Long.parseLong(logId));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        String logId = this.getPageCache().get(IMPORT_PROGRESS_ID);
        long logIdLong = Long.parseLong(logId);
        boolean isStart = this.isStart();
        this.setStart();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!isStart && this.getImportState() == null && customParams.get("filepath") != null) {
            Object schemeId = customParams.get("importscheme");
            String filePath = (String)customParams.get("filepath");
            EPDMAbstractImportService importService = EPDMImportServiceFactory.buildEPDMImportService((IAppCache)this.getAppCache(), schemeId, (String)filePath, (long)logIdLong);
            String importType = (String)customParams.get("importtype");
            importService.doImport(filePath, importType);
        } else {
            int progress;
            EPDMImportInfo info = this.getImportState();
            if (info == null || (progress = info.getProgress()) < 0) {
                String err = info == null || StringUtils.isEmpty((CharSequence)info.getErrorMsg()) ? ResManager.loadKDString((String)"\u5f15\u5165\u8fc7\u7a0b\u9047\u5230\u672a\u77e5\u9519\u8bef\u3002", (String)"EPDMImportingPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]) : info.getErrorMsg();
                this.getView().showErrorNotification(err);
                info = new EPDMImportInfo();
                info.setTotal(0);
                info.setFail(0);
                info.setResolveRow(0);
                info.setImportRow(0);
                info.setErrorMsg(err);
                info.setImportComplete(true);
                this.getAppCache().put(this.getSuspendKey(), (Object)info);
                return;
            }
            if (info.isImportComplete()) {
                this.getView().hideLoading();
                this.getView().setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel", "btnsuspend", "suspendpanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap"});
                if (info.getFail() > 0 || info.isHasException()) {
                    this.failEnd(info.getTotal(), info.getFail());
                } else {
                    this.successEnd(info.getTotal());
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnok"});
                this.getAppCache().remove(this.getSuspendKey());
                progressBar.stop();
            } else {
                progressEvent.setProgress(progress >= 100 ? 99 : progress);
                Label currRow = (Label)this.getControl("currentrow");
                Label handleRow = (Label)this.getControl("handlerow");
                currRow.setText("" + info.getResolveRow());
                handleRow.setText("" + (info.getImportRow() - 1));
                Label rowCount = (Label)this.getControl("rowcount");
                Label handleCount = (Label)this.getControl("handlecount");
                rowCount.setText("" + info.getTotal());
                handleCount.setText("" + info.getTotal());
            }
        }
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        return !StringUtils.isBlank((CharSequence)start) && Boolean.parseBoolean(start);
    }

    private void setStart() {
        this.getPageCache().put("isstart", String.valueOf(true));
    }

    private EPDMImportInfo getImportState() {
        IAppCache appCache = this.getAppCache();
        return (EPDMImportInfo)appCache.get(this.getSuspendKey(), EPDMImportInfo.class);
    }

    private String getSuspendKey() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object schemeId = customParams.get("importscheme");
        String logId = this.getPageCache().get(IMPORT_PROGRESS_ID);
        return EPDMAbstractImportService.getSuspendKey(schemeId, (String)logId);
    }

    private IAppCache getAppCache() {
        String appId = this.getModel().getDataEntityType().getAppId();
        return AppCache.get((String)appId);
    }

    private void successEnd(int total) {
        Label success = (Label)this.getControl("successall");
        success.setText("" + total);
        if (total == 0) {
            Label allSuccessLabel = (Label)this.getControl("labelap10");
            allSuccessLabel.setText(ResManager.loadKDString((String)"\u65e0\u6709\u6548\u6570\u636e\u5f15\u5165", (String)"EPDMImportingPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"successpanel"});
        HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
        notHidden.put("gr", 1);
        this.getView().updateControlMetadata("successpanel", notHidden);
    }

    private void failEnd(int total, int fail) {
        Label success = (Label)this.getControl("success");
        Label allSuccessLabel = (Label)this.getControl("failed");
        success.setText("" + (total - fail));
        allSuccessLabel.setText("" + fail);
        this.getView().setVisible(Boolean.TRUE, new String[]{"failpanel"});
        HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
        notHidden.put("gr", 1);
        this.getView().updateControlMetadata("failpanel", notHidden);
    }
}

