/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.res;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.epm.epbs.common.util.D;
import kd.epm.epdm.common.enums.ResourceTypeEnum;
import kd.epm.epdm.common.enums.ResourceTypeGroupEnum;

public class ResTypeSelectorFormPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)new resourceTypeDataProvider());
        QFilter qFilter = new QFilter("for_module", "=", (Object)Boolean.TRUE);
        String group = D.s((Object)this.getView().getFormShowParameter().getCustomParam("group"));
        if (group != null) {
            qFilter.and(new QFilter("group", "=", (Object)group));
            if (ResourceTypeGroupEnum.DataModel.value().equals(group)) {
                qFilter.and(new QFilter("number", "in", Arrays.stream(ResourceTypeEnum.values()).map(ResourceTypeEnum::getNumber).collect(Collectors.toList())));
            }
        }
        billList.setFilter(qFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if ("next".equals(eventArgs.getOperateKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectResources = billList.getSelectedRows();
            if (selectResources.size() == 1) {
                String number = selectResources.get(0).getNumber();
                ResourceTypeEnum resource = ResourceTypeEnum.get((String)number);
                this.getView().returnDataToParent((Object)resource.getEditFormId());
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u79cd\u7c7b\u578b\u3002", (String)"ResTypeSelectorFormPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    static class resourceTypeDataProvider
    extends ListDataProvider
    implements CreateListDataProviderListener {
        resourceTypeDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (!rows.isEmpty() && ((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"icon_url")) {
                try {
                    this.setFieldData(rows);
                }
                catch (UnknownHostException e) {
                    throw new KDBizException(e.getMessage());
                }
            }
            return rows;
        }

        private void setFieldData(DynamicObjectCollection rows) throws UnknownHostException {
            String url = UrlService.getDomainContextUrl();
            for (DynamicObject row : rows) {
                row.set("icon_url", (Object)(url + "/kingdee/isc/isc_res_type_logo/" + D.s((Object)(row.get("number") + ".png"))));
                row.set("group", (Object)ResourceTypeGroupEnum.get((String)row.getString("group")).loadKDString());
            }
        }

        public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
            args.setListDataProvider((IListDataProvider)this);
        }
    }
}

