/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.voucher;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.business.etl.IscxService;
import kd.epm.epdm.business.voucher.EPDMVoucherSearchService;
import kd.epm.epdm.common.constant.EPMDVoucherConstant;

public class EPDMVoucherSearchPlugin
extends AbstractBaseListPlugin {
    private static final String SOURCE_SYS = "sourcesysrow";
    private static final String NUMBER = "numberrow";
    private static final String ORG = "orgrow";
    private static final String PERIOD = "periodrow";
    private static final String SOURCE_TYPE = "sourcestyperow";
    private static final String COLLECTION_TASK = "collectiontaskrow";
    private static final String COLLECTOR_DATE = "collectordaterow";
    private static final String BATCH_NO = "batchnorow";
    private static final String ACCOUNT = "account";
    private static final String DEBIT_LOCAL = "debitlocal";
    private static final String CREDIT_LOCAL = "creditlocal";
    private static final Set<String> DEFAULT_VOUCHER_FIELDS = Sets.newHashSet((Object[])new String[]{"numberrow", "orgrow", "periodrow", "sourcestyperow", "sourcesysrow", "collectiontaskrow", "collectordaterow", "batchnorow", "account", "debitlocal", "creditlocal"});
    private static final Set<String> DEFAULT_BALANCE_FIELDS = Sets.newHashSet((Object[])new String[]{"entity", "currencystr", "currency", "account", "period", "bybalance_c", "bybalance_d", "bpbalance_c", "bpbalance_d"});
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String LABEL = "labelap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid control = (AbstractGrid)this.getControl(ENTRY_ENTITY);
        IDataModel dataModel = this.getModel();
        control.addHyperClickListener(event -> {
            String fieldName = event.getFieldName();
            int rowIndex = event.getRowIndex();
            Object number = dataModel.getValue(fieldName, rowIndex);
            if (NUMBER.equals(fieldName)) {
                Object sourceSys = dataModel.getValue(SOURCE_SYS, rowIndex);
                Object sourceType = dataModel.getValue(SOURCE_TYPE, rowIndex);
                this.showAddNewVoucher((Consumer<BillShowParameter>)((Consumer)showParameter -> {
                    showParameter.setCustomParam("openType", (Object)EPMDVoucherConstant.OpenType.HYPER_LINK);
                    showParameter.setCustomParam(NUMBER, number);
                    showParameter.setCustomParam(SOURCE_SYS, sourceSys);
                    showParameter.setCustomParam(SOURCE_TYPE, sourceType);
                    showParameter.setStatus(OperationStatus.VIEW);
                }));
            } else {
                QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)IscxService.getTrigger((String)((String)number)))};
                DynamicObjectCollection query = QueryServiceHelper.query((String)"iscx_data_flow_trigger", (String)"data_flow_id", (QFilter[])filters);
                if (query.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u542f\u52a8\u65b9\u6848\u3002", (String)"EPDMVoucherSearchPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                    return;
                }
                long dataFlowId = ((DynamicObject)query.get(0)).getLong("data_flow_id");
                HashMap<String, Object> params = new HashMap<String, Object>(2);
                params.put("type", "DataMapping.ScriptMapping");
                params.put("id", dataFlowId);
                FormShowParameter p = new FormShowParameter();
                p.setFormId("iscx_topology_view");
                p.setCustomParams(params);
                p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(p);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object balanceId = showParameter.getCustomParam("filter");
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        AtomicInteger maxRow = new AtomicInteger(0);
        new EPDMVoucherSearchService(balanceId, DEFAULT_VOUCHER_FIELDS, DEFAULT_BALANCE_FIELDS).addVoucherFieldAndFieldNameConsumer(propertyNameMap -> {
            Set selectFields = propertyNameMap.keySet();
            List fieldEdits = entryEntity.getFieldEdits();
            for (FieldEdit fieldEdit : fieldEdits) {
                String fieldKey = fieldEdit.getFieldKey();
                fieldEdit.setVisible("s", selectFields.contains(fieldKey));
                Tuple tuple = (Tuple)propertyNameMap.get(fieldKey);
                if (tuple == null) continue;
                fieldEdit.setCaption((LocaleString)tuple.item2);
            }
        }).addVoucherRowAndRowFieldConsumer((selectFields, dynamicObject) -> {
            this.getModel().createNewEntryRow(ENTRY_ENTITY);
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRY_ENTITY, maxRow.getAndIncrement());
            for (String selectField : selectFields) {
                row.set(selectField, dynamicObject.get(selectField));
            }
        }).addBalanceFieldAndValueConsumer((s, o) -> this.getModel().setValue("bl" + s, o)).addBalanceFieldAndFieldNameConsumer(nameMap -> {
            Set blSelectFields = nameMap.keySet();
            Container flexPanel = (Container)this.getView().getControl("flexpanelap1");
            List items = flexPanel.getItems();
            for (Control item : items) {
                String key = item.getKey();
                String field = key.substring(2);
                if (!(item instanceof FieldEdit)) continue;
                FieldEdit fieldEdit = (FieldEdit)item;
                fieldEdit.setVisible("s", blSelectFields.contains(field));
                Tuple tuple = (Tuple)nameMap.get(field);
                if (tuple == null) continue;
                fieldEdit.setCaption((LocaleString)tuple.item2);
            }
        }).addBalanceErrorRunner(() -> this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff0c\u79d1\u76ee\uff0c\u671f\u95f4\uff0c\u5e01\u79cd\u7b49\u5b57\u6bb5\u5b58\u5728\u7a7a\u503c\uff0c\u65e0\u6cd5\u67e5\u8be2\u51ed\u8bc1\u4fe1\u606f\u3002", (String)"EPDMVoucherSearchPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]))).doAction();
        Label label = (Label)this.getControl(LABEL);
        label.setText(String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761", (String)"EPDMVoucherSearchPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), maxRow.get()));
    }

    private void showAddNewVoucher(Consumer<BillShowParameter> consumer) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("epdm_voucher");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("openType", (Object)EPMDVoucherConstant.OpenType.TEMPLATE);
        consumer.accept((Object)showParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epdm_voucher"));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

