/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.voucher;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.common.entity.EPDMDataModelPreset;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.enums.DataModelPresetFieldTypeEnum;
import kd.epm.epdm.common.enums.DataModelRefTypeEnum;
import kd.epm.epdm.common.util.LongUtil;
import kd.epm.epdm.common.util.MetadataUtil;

public class EPMDAccountingConfigPlugin
extends AbstractBasePlugIn {
    private static final String BTN_OK = "btnok";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ACCOUNTING = "accounting";
    private static final String VALUE = "value";
    private static final String MODEL_NMAE = "datamodel";
    private static final String SELECT_ROW = "selectRow";
    private static final String VALUE_F7_BACK = "value_f7_back";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        BasedataEdit control = (BasedataEdit)this.getControl(ACCOUNTING);
        final IDataModel dataModel = this.getModel();
        control.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity(ENTRY_ENTITY);
            List idSelected = entryEntity.stream().map(dy -> dy.getDynamicObject(ACCOUNTING)).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            evt.addCustomQFilter(new QFilter("id", "not in", idSelected));
            evt.addCustomQFilter(new QFilter(MODEL_NMAE, "=", (Object)DataModelPresetEnum.T_EPM_VOUCHER.getId()));
            evt.addCustomQFilter(new QFilter("type", "=", (Object)DataModelPresetFieldTypeEnum.Line.name()));
            evt.addCustomQFilter(new QFilter("field", "like", (Object)"fdim%"));
        });
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent cellClickEvent) {
                int row = cellClickEvent.getRow();
                IFormView view = ((EntryGrid)cellClickEvent.getSource()).getView();
                if (OperationStatus.VIEW != view.getFormShowParameter().getStatus()) {
                    Object value;
                    IPageCache pageCache = view.getPageCache();
                    if (!String.valueOf(row).equals(pageCache.get(EPMDAccountingConfigPlugin.SELECT_ROW)) && EPMDAccountingConfigPlugin.VALUE.equals(cellClickEvent.getFieldKey()) && (value = dataModel.getValue(EPMDAccountingConfigPlugin.ACCOUNTING)) instanceof DynamicObject) {
                        DynamicObject dynamicObject = (DynamicObject)value;
                        String ref = dynamicObject.getString("ref");
                        String refType = dynamicObject.getString("reftype");
                        if (DataModelRefTypeEnum.Entityobject.name().equals(refType)) {
                            EPMDAccountingConfigPlugin.this.showValueF7(ref, para -> {});
                        } else if (DataModelRefTypeEnum.Assistantdata.name().equals(refType)) {
                            EPMDAccountingConfigPlugin.this.showValueF7("bos_assistantdata_detail", para -> {
                                ListFilterParameter parameter = para.getListFilterParameter();
                                parameter.getQFilters().add(new QFilter("group", "=", (Object)LongUtil.toLong((String)ref)));
                            });
                        } else if (DataModelRefTypeEnum.Enum.name().equals(refType)) {
                            EPMDAccountingConfigPlugin.this.showValueF7("epdm_datamodelenumf7", para -> {
                                ListFilterParameter parameter = para.getListFilterParameter();
                                parameter.getQFilters().add(new QFilter("ref", "=", (Object)LongUtil.toLong((String)ref)));
                            });
                        }
                        pageCache.put(EPMDAccountingConfigPlugin.SELECT_ROW, String.valueOf(row));
                    }
                }
            }

            public void cellDoubleClick(CellClickEvent cellClickEvent) {
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String uds = (String)formShowParameter.getCustomParam("dimselected");
        if (StringUtils.isNotEmpty((String)uds)) {
            String[] split = uds.split(",");
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            Map dimIds = DataModelPresetHelper.queryDimConfigIdMap((String[])split, (DataModelPresetEnum)DataModelPresetEnum.T_EPM_VOUCHER);
            for (int i = 0; i < split.length; ++i) {
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                String dim = split[i];
                Object id = dimIds.get(dim);
                this.getModel().setValue(ACCOUNTING, id, i);
                this.getModel().setValue(VALUE, formShowParameter.getCustomParam(dim), i);
            }
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Map map = MetadataUtil.getAliasToPropertyName((String)"epdm_voucher");
        Collection dataModelPresets = DataModelPresetHelper.getDataModelPresetsLineDim();
        Set dimFieldSet = dataModelPresets.stream().map(EPDMDataModelPreset::getField).collect(Collectors.toSet());
        DynamicObjectCollection config = this.getModel().getEntryEntity(ENTRY_ENTITY);
        StringJoiner selectedJoin = new StringJoiner(",");
        StringJoiner accountingJoiner = new StringJoiner(",");
        Map<String, String> collect = config.stream().filter(dy -> dy.getDynamicObject(ACCOUNTING) != null).filter(dy -> dimFieldSet.contains(dy.getDynamicObject(ACCOUNTING).getString("field"))).peek(dy -> {
            String alias = dy.getDynamicObject(ACCOUNTING).getString("field");
            String dim = (String)map.get(alias.toUpperCase(Locale.ROOT));
            selectedJoin.add(dim);
        }).peek(dy -> accountingJoiner.add(dy.getDynamicObject(ACCOUNTING).getString("content") + ":" + dy.getString(VALUE))).collect(Collectors.toMap(dy -> map.getOrDefault(dy.getDynamicObject(ACCOUNTING).getString("field").toUpperCase(Locale.ROOT), ""), dy -> dy.getString(VALUE), (v1, v2) -> v1));
        collect.put(ACCOUNTING, accountingJoiner.toString());
        IFormView view = this.getView();
        collect.put("row", (String)this.getView().getFormShowParameter().getCustomParam("row"));
        view.returnDataToParent(collect);
        view.close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (ACCOUNTING.equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            this.changeDataModelName(newValue, changeData.getRowIndex());
            this.getModel().setValue(VALUE, null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection config = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (int i = 0; i < config.size(); ++i) {
            DynamicObject rowData = (DynamicObject)config.get(i);
            DynamicObject dynamicObject = rowData.getDynamicObject(ACCOUNTING);
            this.changeDataModelName(dynamicObject, i);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (VALUE_F7_BACK.equals(event.getActionId())) {
            String selectRow;
            Object returnData = event.getReturnData();
            if (returnData instanceof ListSelectedRowCollection && (selectRow = this.getPageCache().get(SELECT_ROW)) != null) {
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)returnData;
                ListSelectedRow selectedRow = listSelectedRows.get(0);
                String number = selectedRow.getNumber();
                this.getModel().setValue(VALUE, (Object)number, Integer.parseInt(selectRow));
            }
            this.getPageCache().remove(SELECT_ROW);
        }
    }

    private void changeDataModelName(Object newValue, int rowIndex) {
        if (newValue instanceof DynamicObject) {
            DynamicObject newValueDy = (DynamicObject)newValue;
            String type = newValueDy.getString("reftype");
            String ref = newValueDy.getString("ref");
            if (DataModelRefTypeEnum.Entityobject.name().equals(type)) {
                LocaleString displayName = MetadataServiceHelper.getDataEntityType((String)ref).getDisplayName();
                this.getModel().setValue(MODEL_NMAE, (Object)displayName.getLocaleValue(), rowIndex);
            } else {
                DataModelRefTypeEnum dataModelRefTypeEnum = DataModelRefTypeEnum.getEnumByName((String)type);
                if (null != dataModelRefTypeEnum) {
                    String entity = dataModelRefTypeEnum.getEntity();
                    BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entity);
                    String nameProperty = dataEntityType.getNameProperty();
                    String idProperty = dataEntityType.getPrimaryKey().getName();
                    DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)nameProperty, (QFilter[])new QFilter[]{new QFilter(idProperty, "=", (Object)LongUtil.toLong((String)ref))});
                    if (!query.isEmpty()) {
                        DynamicObject dynamicObject = (DynamicObject)query.get(0);
                        String name = dynamicObject.getString(nameProperty);
                        this.getModel().setValue(MODEL_NMAE, (Object)name, rowIndex);
                    }
                }
            }
        } else {
            this.getModel().setValue(MODEL_NMAE, null, rowIndex);
        }
    }

    private void showValueF7(String formId, Consumer<ListShowParameter> addFilter) {
        ListShowParameter para = this.createShowListForm(formId);
        para.setStatus(this.getView().getFormShowParameter().getStatus());
        para.setShowApproved(true);
        para.setShowUsed(true);
        para.setUseOrgId(0L);
        para.setShowFrequent(false);
        para.setHasRight(true);
        String parentFormId = this.getView().getFormShowParameter().getFormId();
        parentFormId = FormMetadataCache.getFormConfig((String)parentFormId).getEntityTypeId();
        para.setCustomParam("originFormId", (Object)parentFormId);
        para.setCustomParam("originFieldKey", (Object)"");
        para.setCustomParam("originUseOrg", (Object)para.getUseOrgId());
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, VALUE_F7_BACK));
        addFilter.accept(para);
        this.getView().showForm((FormShowParameter)para);
    }

    private ListShowParameter createShowListForm(String formId) {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId(formId);
        para.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        para.getOpenStyle().setInlineStyleCss(css);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        para.setFormId(formConfig == null ? formId : formConfig.getF7ListFormId());
        para.setF7Style(0);
        para.setMultiSelect(false);
        para.setShowTitle(false);
        para.setHasRight(true);
        return para;
    }
}

