/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.voucher;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.epm.commo.SubPagePlugin;

public class EPMDCollectionParamPlugin
extends AbstractBasePlugIn
implements SubPagePlugin {
    public static final String PARAM_AREA = "param_area";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initParamArea();
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType copy = (MainEntityType)e.getOriginalEntityType().clone();
            e.setNewEntityType(copy);
            Map<String, Object> fieldKey2Name = this.getDynamicField();
            if (fieldKey2Name.isEmpty()) {
                return;
            }
            this.updateEntityTypeAndMetadata(fieldKey2Name, () -> copy);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("kd.epm.epdm.formplugin.voucher.EPMDCollectionParamPlugin.getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        Map<String, Object> dynamicField = this.getDynamicField();
        if (dynamicField.containsKey(ctrlKey)) {
            TextEdit edit = new TextEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.setDraggable(true);
            edit.setDroppable(true);
            e.setControl((Control)edit);
        }
    }

    @Override
    public Map<String, Object> getData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Map<String, Object> dynamicField = this.getDynamicField();
        HashMap<String, Object> rs = new HashMap<String, Object>(dynamicField.size());
        dynamicField.forEach((k, v) -> {
            String key = k.toLowerCase(Locale.ROOT);
            Object value = dataEntity.get(key);
            if (value == null || "".equals(value)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPMDCollectionParamPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), v.toString()));
            }
            rs.put((String)k, value);
        });
        return rs;
    }

    private void initParamArea() {
        IFormView view = this.getView();
        Map<String, Object> fieldKey2Name = this.getDynamicField();
        if (fieldKey2Name.isEmpty()) {
            return;
        }
        this.updateEntityTypeAndMetadata(fieldKey2Name, () -> view.getModel().getDataEntityType());
        String flexArea = PARAM_AREA;
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(flexArea);
        this.addToFront(flexPanelAp, fieldKey2Name);
        Map control = flexPanelAp.createControl();
        view.updateControlMetadata(flexArea, control);
    }

    private Map<String, Object> getDynamicField() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        return parameter.getCustomParams();
    }

    private void updateEntityTypeAndMetadata(Map<String, Object> fieldKey2Name, Supplier<MainEntityType> getMainEntityTypeFunc) {
        MainEntityType mainEntityType = getMainEntityTypeFunc.get();
        EntityMetadata entityMetadata = this.getRuntimeMetadata(mainEntityType);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        fieldKey2Name.keySet().stream().filter(fieldKey -> !properties.containsKey(fieldKey)).forEach(fieldKey -> this.updateEntityTypeAndMetadata(mainEntityType, entityMetadata, (String)fieldKey));
    }

    public void addToFront(FlexPanelAp flexPanelAp, Map<String, Object> fieldKey2Name) {
        fieldKey2Name.forEach((key, name) -> {
            TextField textField = new TextField();
            textField.setEditStyle(0);
            textField.setId(key);
            textField.setKey(key);
            textField.setMustInput(true);
            FieldAp controlField = new FieldAp();
            controlField.setField((Field)textField);
            controlField.setFireUpdEvt(true);
            controlField.setName(new LocaleString(name.toString()));
            controlField.setKey(key);
            controlField.setId(key);
            controlField.setShowTitle(true);
            controlField.setLock(null);
            this.setDefaultStyle((ControlAp<?>)controlField);
            controlField.setFieldStyle(0);
            flexPanelAp.getItems().add(controlField);
        });
    }

    public void setDefaultStyle(ControlAp<?> f7Field) {
        f7Field.setTextAlign("left");
        f7Field.setHeight(new LocaleString("40px"));
        f7Field.setWidth(new LocaleString("210px"));
        if (f7Field.getHeight() != null) {
            f7Field.setHeight(null);
        } else {
            f7Field.setHeight(new LocaleString("40px"));
        }
        f7Field.setFontSize(12);
        f7Field.setStyle(this.getStyle());
    }

    private Style getStyle() {
        return new Style();
    }

    private EntityMetadata getRuntimeMetadata(MainEntityType mainEntityType) {
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
    }

    private void updateEntityTypeAndMetadata(MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey) {
        TextProp textProp = new TextProp();
        textProp.setName(fieldKey);
        textProp.setDbIgnore(false);
        targetEntity.addProperty((DynamicProperty)textProp);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        if (entityMeta != null) {
            textFiled.setEntityMetadata(entityMeta);
            entityMeta.getItems().add(textFiled);
        }
    }
}

