/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.voucher;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.SimpleDynamicTreeBuilder;
import kd.epm.epbs.common.tree.TreeSearchHelper;
import kd.epm.epbs.common.util.AppUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import kd.epm.epdm.common.util.LongUtil;

public class EPMDTreeBillListPlugin
extends AbstractBaseListPlugin {
    private static final String SEARCH = "searchap";
    private static final String CATALOG_ADD = "catalog_add";
    private static final String CATALOG_MODIFY = "catalog_modify";
    private static final String CATALOG_DELETE = "catalog_delete";
    private static final String CATALOG_DELETE_BACK = "catalog_delete_back";
    private static final String REFRESH = "refresh";
    private static final String CATEGORY = "category";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String LONG_NUMBER = "longnumber";
    private static final String CREATE_TIME = "createtime";
    public static final String FOCUS_NODE_ID = "FocusNodeId";
    private static final String IS_INCLUDE_SUB = "isincludesub";

    public void initialize() {
        super.initialize();
        final BillList billList = (BillList)this.getControl("billlistap");
        TreeView tv = (TreeView)this.getView().getControl("treeviewap");
        tv.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                billList.clearSelection();
                billList.refresh();
            }
        });
        billList.addSetFilterListener(event -> {
            List qFilters = event.getQFilters();
            String nodeId = (String)this.getFocusNode().item2;
            if (nodeId == null || "root".equals(nodeId)) {
                qFilters.add(new QFilter("1", "!=", (Object)1));
            } else {
                String entityName = this.getTreeBaseEntityId();
                List<Long> ids = this.queryAllSonOfFocusNode(entityName, nodeId);
                qFilters.add(new QFilter(CATEGORY, "in", ids));
            }
        });
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getControl("treeviewap");
        Search search = (Search)this.getControl(SEARCH);
        search.addEnterListener(event -> new TreeSearchHelper(tree, event.getText()).search());
        this.addClickListeners(new String[]{CATALOG_ADD, CATALOG_MODIFY, CATALOG_DELETE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refresh(null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if (IS_INCLUDE_SUB.equals(property.getName())) {
            this.refresh(null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (!(source instanceof Vector)) {
            return;
        }
        String appPkId = AppUtils.getAppPkId((IFormView)this.getView());
        EntityType billEntityType = this.getBillEntityType();
        String entityNum = billEntityType.getName();
        LocaleString displayName = billEntityType.getDisplayName();
        String key = ((Vector)source).getKey();
        if (CATALOG_ADD.equals(key)) {
            boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appPkId, (String)entityNum, (String)"4=9VGJB5WUSL");
            if (!permission) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u5206\u7c7b\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EPMDTreeBillListPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]), displayName.getLocaleValue()));
            }
            this.openCatalogPage(OperationStatus.ADDNEW);
        } else if (CATALOG_MODIFY.equals(key)) {
            boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appPkId, (String)entityNum, (String)"4=9VIG7M4KC1");
            if (!permission) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u5206\u7c7b\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EPMDTreeBillListPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]), displayName.getLocaleValue()));
            }
            this.openCatalogPage(OperationStatus.EDIT);
        } else if (CATALOG_DELETE.equals(key)) {
            boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appPkId, (String)entityNum, (String)"4=9VJG=V=9S+");
            if (!permission) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u5206\u7c7b\u201d\u7684\u201c\u5220\u9664\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EPMDTreeBillListPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]), displayName.getLocaleValue()));
            }
            TreeView tv = (TreeView)this.getView().getControl("treeviewap");
            Object nodeName = Optional.ofNullable(tv.getTreeState().getFocusNode()).filter(id -> !"root".equals(id.get(ID))).map(map -> map.get("text")).orElseThrow(() -> new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u5206\u7c7b\u8282\u70b9\u3002", (String)"EPMDTreeBillListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0])));
            if (this.isRoot()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664", (String)"EPMDTreeBillListPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            }
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u88ab\u5220\u9664\u6a21\u677f\u5206\u7c7b\u4e0b\u7684\u6a21\u677f\u5c06\u4f1a\u88ab\u79fb\u52a8\u5230\u5176\u76f4\u63a5\u4e0a\u7ea7\u6a21\u677f\u5206\u7c7b\u4e0a\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"EPMDTreeBillListPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]), nodeName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CATALOG_DELETE_BACK, (IFormPlugin)this));
        }
    }

    private boolean isRoot() {
        String nodeId = (String)this.getFocusNode().item2;
        String entityName = this.getTreeBaseEntityId();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)entityName, (String)LONG_NUMBER, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)LongUtil.toLong((String)nodeId))});
        return dynamicObject != null && "root".equals(dynamicObject.getString(LONG_NUMBER));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("refresh_back".equals(actionId)) {
            this.refresh(null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CATALOG_DELETE_BACK.equals(event.getCallBackId()) && MessageBoxResult.Yes == event.getResult()) {
            this.catalogDelete();
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (REFRESH.equals(evt.getOperationKey())) {
            this.refresh(null);
            evt.setCancel(true);
        }
    }

    public void refresh(String focusNodeId) {
        TreeView tv = (TreeView)this.getView().getControl("treeviewap");
        if (focusNodeId == null) {
            focusNodeId = tv.getTreeState().getFocusNodeId();
        }
        String baseEntityId = this.getTreeBaseEntityId();
        DynamicTreeContext context = new DynamicTreeContext(baseEntityId);
        context.setSelectFields(String.join((CharSequence)",", ID, NUMBER, NAME, "parent"));
        context.setOrderby(CREATE_TIME);
        context.setFocusTreeId(focusNodeId);
        context.setqFilters(new QFilter[]{new QFilter(LONG_NUMBER, "=", (Object)"root").or(LONG_NUMBER, "like", (Object)("root" + this.getLongNumberSplit() + "%"))});
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
        context.setRootName(dataEntityType.getDisplayName().getLocaleValue());
        AbstractTreeBuilder treeBuilder = new SimpleDynamicTreeBuilder(context).buildTree(tv);
        treeBuilder.nodeClick();
        this.getPageCache().put(FOCUS_NODE_ID, tv.getTreeState().getFocusNodeId());
    }

    private String getTreeBaseEntityId() {
        EntityType entityType = this.getBillEntityType();
        return Optional.ofNullable(entityType.getProperty(CATEGORY)).filter(BasedataProp.class::isInstance).map(BasedataProp.class::cast).map(BasedataProp::getBaseEntityId).orElseThrow(() -> new KDBizException(String.format(ResManager.loadKDString((String)"\u53f3\u8868\u5355\u636e\u9700\u8981\u5b58\u5728\u6807\u8bc6\u4e3a%1$s\u7684\u57fa\u7840\u8d44\u6599\u5206\u7c7b\u6811\u3002", (String)"EPMDTreeBillListPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), CATEGORY)));
    }

    private EntityType getBillEntityType() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getEntityType();
    }

    private void openCatalogPage(OperationStatus status) {
        TreeView tv = (TreeView)this.getView().getControl("treeviewap");
        Long focusNodeId = Optional.ofNullable(tv.getTreeState().getFocusNodeId()).filter(id -> !"root".equals(id)).map(Long::valueOf).orElseGet(() -> null);
        if (focusNodeId == null || focusNodeId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u5206\u7c7b\u8282\u70b9\u3002", (String)"EPMDTreeBillListPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityName = this.getTreeBaseEntityId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(entityName);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh_back"));
        showParameter.setCustomParam("parent", (Object)focusNodeId);
        if (status != OperationStatus.ADDNEW) {
            showParameter.setPkId((Object)focusNodeId);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void catalogDelete() {
        String entityName = this.getTreeBaseEntityId();
        Tuple<String, String> focusNode = this.getFocusNode();
        String focusNodeId = (String)focusNode.item2;
        DynamicObject dynamicObject1 = BusinessDataServiceHelper.loadSingle((Object)LongUtil.toLong((String)focusNodeId), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        List<Long> ids = this.queryAllSonOfFocusNode(entityName, focusNodeId);
        if (ids == null) {
            return;
        }
        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
        EntityType entityType = this.getBillEntityType();
        String billEntityName = entityType.getName();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)billEntityName, (String)CATEGORY, (QFilter[])new QFBuilder(CATEGORY, "in", ids).toArray());
        long pId = LongUtil.toLong((String)((String)focusNode.item1));
        for (DynamicObject dynamicObject : load) {
            dynamicObject.set(CATEGORY, (Object)pId);
        }
        SaveServiceHelper.save((DynamicObject[])load);
        this.refresh(null);
        OperationLogUtil.writeLog((String)AppUtils.getAppPkId((IFormView)this.getView()), (String)entityName, (IOperationTypeInfo)new OperationTypeInfo("deletecategory", new MultiLangEnumBridge("\u5220\u9664\u5206\u7c7b", "EPMDTreeBillListPlugin_9", "epm-epbs-formplugin")), (MultiLangEnumBridge)OperationMsgUtil.getDeleteSucWithNumber((String)dynamicObject1.getString(NUMBER)));
    }

    private Tuple<String, String> getFocusNode() {
        TreeView tv = (TreeView)this.getView().getControl("treeviewap");
        Map focusNode = tv.getTreeState().getFocusNode();
        if (focusNode != null && !focusNode.isEmpty()) {
            return new Tuple((Object)((String)focusNode.get("parentid")), (Object)((String)focusNode.get(ID)));
        }
        return new Tuple(null, (Object)this.getPageCache().get(FOCUS_NODE_ID));
    }

    private List<Long> queryAllSonOfFocusNode(String entityName, String focusNodeId) {
        Boolean isIncludeSub = (Boolean)this.getModel().getValue(IS_INCLUDE_SUB);
        if (Boolean.FALSE.equals(isIncludeSub)) {
            return Lists.newArrayList((Object[])new Long[]{LongUtil.toLong((String)focusNodeId)});
        }
        Long id = Long.valueOf(focusNodeId);
        QFBuilder qfBuilder = new QFBuilder(ID, "=", (Object)id).or("parent", "=", (Object)id);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)String.join((CharSequence)",", LONG_NUMBER, "parent"), (QFilter[])qfBuilder.toArray());
        List filters = query.stream().map(dynamicObject -> {
            String longNumber = dynamicObject.getString(LONG_NUMBER);
            return new QFilter(LONG_NUMBER, "=", (Object)longNumber).or(LONG_NUMBER, "like", (Object)(longNumber + this.getLongNumberSplit() + "%"));
        }).collect(Collectors.toList());
        if (filters.isEmpty()) {
            return null;
        }
        QFilter firstQF = (QFilter)filters.remove(0);
        for (QFilter filter : filters) {
            firstQF.or(filter);
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)ID, (QFilter[])new QFilter[]{firstQF});
        return dynamicObjects.stream().map(sy -> sy.getLong(ID)).collect(Collectors.toList());
    }

    private String getLongNumberSplit() {
        return ".";
    }
}

