/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.formplugin.voucher;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.util.AppUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epdm.business.voucher.EPMDVoucherHelper;
import kd.epm.epdm.business.voucher.EPMDVoucherServiceHelper;
import kd.epm.epdm.common.constant.EPMDVoucherConstant;
import kd.epm.epdm.common.constant.EPMDVoucherDescConstant;
import kd.epm.epdm.service.voucher.EPMDVoucherBaseService;

public class EPMDVoucherPlugin
extends AbstractBasePlugIn {
    private static final String STATUS_LABEL = "billstatuslabel";
    private static final String NUMBER_PANEL = "numberpanel";
    private static final String OTHER_PANEL = "otherfieldpanel";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_SUBMIT = "btn_submit";
    private static final String BTN_POSTING = "btn_posting";
    private static final String BTN_REJECT = "btn_reject";
    private static final String BTN_CONTINUOUS_ADD = "btn_continuousadd";
    private static final String ORG = "org";
    private static final String PERIOD = "period";
    private static final String COLLECTION_TASK = "collectiontask";
    private EPMDVoucherBaseService epmdVoucherBaseService;

    public void initialize() {
        super.initialize();
        this.epmdVoucherBaseService = new EPMDVoucherBaseService(this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.epmdVoucherBaseService.registerListener((IFormPlugin)this);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.setOperationStatus(status);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.epmdVoucherBaseService.closedCallBack(closedCallBackEvent);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String openTypeString = (String)parameter.getCustomParam("openType");
        EPMDVoucherConstant.OpenType openType = EPMDVoucherConstant.OpenType.valueOf((String)openTypeString);
        IDataModel dataModel = this.getModel();
        boolean dataChanged = false;
        if (EPMDVoucherConstant.OpenType.TEMPLATE == openType) {
            Object tempId = parameter.getCustomParam("tempId");
            if (tempId != null) {
                EPMDVoucherHelper.fillByTemplate((Object)tempId, (IDataModel)dataModel);
                dataModel.setValue("createdate", (Object)new Date());
                dataModel.setValue("creater", (Object)RequestContext.get().getCurrUserId());
                dataChanged = true;
            }
        } else if (EPMDVoucherConstant.OpenType.COPY == openType) {
            ThreeTuple uniqueKey = new ThreeTuple(parameter.getCustomParam("numberrow"), parameter.getCustomParam("sourcesysrow"), parameter.getCustomParam("sourcestyperow"));
            EPMDVoucherHelper.fillByQuery((ThreeTuple)uniqueKey, (IDataModel)dataModel);
            dataModel.setValue("billstatus", (Object)EPMDVoucherDescConstant.BillStatus.A.getCode());
            dataModel.setValue("sourcestype", (Object)EPMDVoucherDescConstant.SourcesType.B.getCode());
            dataModel.setValue("sourcesys", (Object)"epm".toUpperCase(Locale.ROOT));
            dataModel.setValue("number", null);
            dataModel.setValue(COLLECTION_TASK, null);
            dataModel.setValue("createdate", (Object)new Date());
            dataModel.setValue("creater", (Object)RequestContext.get().getCurrUserId());
            dataModel.setValue("createrstr", null);
            dataChanged = true;
        } else if (EPMDVoucherConstant.OpenType.HYPER_LINK == openType) {
            dataChanged = dataModel.getDataChanged();
            ThreeTuple uniqueKey = new ThreeTuple(parameter.getCustomParam("numberrow"), parameter.getCustomParam("sourcesysrow"), parameter.getCustomParam("sourcestyperow"));
            EPMDVoucherHelper.fillByQuery((ThreeTuple)uniqueKey, (IDataModel)dataModel);
        }
        this.epmdVoucherBaseService.afterBindData((Consumer<Integer>)((Consumer)rowNum -> {}));
        this.changeBillStatus();
        dataModel.setDataChanged(dataChanged);
        this.changeViewStatus();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.epmdVoucherBaseService.propertyChanged(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String itemKey = eventArgs.getOperateKey();
        if (BTN_SAVE.equals(itemKey)) {
            this.doSave((Consumer<DynamicObject>)((Consumer)dataEntity -> {}));
            this.getModel().setDataChanged(false);
            this.successTip(this.currentVoucher(), EPMDVoucherServiceHelper.ButtonEnum.SAVE);
        } else if (BTN_SUBMIT.equals(itemKey)) {
            DynamicObject[] save = this.doSave((Consumer<DynamicObject>)((Consumer)this::checkSubmit));
            Object billStatus = this.getModel().getValue("billstatus");
            EPMDVoucherDescConstant.BillStatus status = EPMDVoucherDescConstant.BillStatus.getBillStatusByCode((Object)billStatus);
            if (EPMDVoucherDescConstant.BillStatus.A != status && EPMDVoucherDescConstant.BillStatus.C != status && EPMDVoucherDescConstant.BillStatus.E != status) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u975e\u8349\u7a3f\u3001\u5df2\u9a73\u56de\u6216\u53cd\u8fc7\u8d26\u72b6\u6001,\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"EPMDVoucherPlugin_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            EPMDVoucherDescConstant.BillStatus targetStatus = EPMDVoucherDescConstant.BillStatus.B;
            Collection numberSys = Arrays.stream(save).map(dy -> new ThreeTuple((Object)dy.getString("number"), (Object)dy.getString("sourcesys"), (Object)dy.getString("sourcestype"))).collect(Collectors.toList());
            List result = EPMDVoucherHelper.changeStatus((Collection)numberSys, (EPMDVoucherDescConstant.BillStatus)status, (EPMDVoucherDescConstant.BillStatus)targetStatus, (boolean)false);
            if (!result.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"EPMDVoucherPlugin_2", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("billstatus", (Object)targetStatus.getCode());
            this.changeBillStatus();
            this.changeViewStatus();
            this.getModel().setDataChanged(false);
            this.successTip(numberSys, EPMDVoucherServiceHelper.ButtonEnum.SUBMIT);
        } else if (BTN_POSTING.equals(itemKey)) {
            EPMDVoucherDescConstant.BillStatus sourceStatus = EPMDVoucherDescConstant.BillStatus.B;
            EPMDVoucherDescConstant.BillStatus targetStatus = EPMDVoucherDescConstant.BillStatus.D;
            Collection<ThreeTuple<String, String, String>> numberSys = this.currentVoucher();
            List result = EPMDVoucherHelper.changeStatus(numberSys, (EPMDVoucherDescConstant.BillStatus)sourceStatus, (EPMDVoucherDescConstant.BillStatus)targetStatus, (boolean)false);
            if (!result.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fc7\u8d26\u5931\u8d25\u3002", (String)"EPMDVoucherPlugin_3", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("billstatus", (Object)targetStatus.getCode());
            this.changeBillStatus();
            this.changeViewStatus();
            this.getModel().setDataChanged(false);
            this.successTip(numberSys, EPMDVoucherServiceHelper.ButtonEnum.POSTING);
        } else if (BTN_REJECT.equals(itemKey)) {
            EPMDVoucherDescConstant.BillStatus sourceStatus = EPMDVoucherDescConstant.BillStatus.B;
            EPMDVoucherDescConstant.BillStatus targetStatus = EPMDVoucherDescConstant.BillStatus.C;
            Collection<ThreeTuple<String, String, String>> numberSys = this.currentVoucher();
            List result = EPMDVoucherHelper.changeStatus(numberSys, (EPMDVoucherDescConstant.BillStatus)sourceStatus, (EPMDVoucherDescConstant.BillStatus)targetStatus, (boolean)false);
            if (!result.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9a73\u56de\u5931\u8d25\u3002", (String)"EPMDVoucherPlugin_4", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("billstatus", (Object)targetStatus.getCode());
            this.changeBillStatus();
            this.changeViewStatus();
            this.getModel().setDataChanged(false);
            this.successTip(numberSys, EPMDVoucherServiceHelper.ButtonEnum.REJECT);
        } else if (BTN_CONTINUOUS_ADD.equals(itemKey)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("epdm_voucher");
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("openType", (Object)EPMDVoucherConstant.OpenType.TEMPLATE);
            showParameter.setCustomParam("openType", (Object)EPMDVoucherConstant.OpenType.NEW);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "epdm_voucher"));
            this.getView().showForm((FormShowParameter)showParameter);
            if (!this.getModel().getDataChanged()) {
                this.getView().close();
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        this.epmdVoucherBaseService.itemClick(evt);
    }

    private DynamicObject[] doSave(Consumer<DynamicObject> checkFun) {
        DynamicObject dynamicObject2;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String sys = dataEntity.getString("sourcesys");
        String number = dataEntity.getString("number");
        String sourceType = dataEntity.getString("sourcestype");
        QFilter qFilter = EPMDVoucherHelper.uniqueFilter((ThreeTuple)new ThreeTuple((Object)number, (Object)sys, (Object)sourceType));
        if (StringUtils.isNotEmpty((String)number) && QueryServiceHelper.exists((String)"epdm_voucherdesc", (QFilter[])new QFilter[]{qFilter})) {
            this.checkPermission("4715a0df000000ac", ResManager.loadKDString((String)"\u4fee\u6539", (String)"EPMDVoucherPlugin_5", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        } else {
            this.checkPermission("0=KX5+QVF5+R", OperationTypeEnum.SAVE.getNameString());
        }
        Object creator = this.getModel().getValue("creater");
        String creatorStr = (String)this.getModel().getValue("createrstr");
        if (StringUtils.isEmpty((String)creatorStr)) {
            this.getModel().setValue("createrstr", (Object)((DynamicObject)creator).getString("name"));
        }
        Object modifier = this.getModel().getValue("modifier");
        this.getModel().setValue("modifierstr", (Object)((DynamicObject)modifier).getString("name"));
        if (EPMDVoucherDescConstant.SourcesType.A.getCode().equals(sys)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u6765\u6e90\u7c7b\u578b\u4e3aEPM\u51ed\u8bc1\u91c7\u96c6\uff0c\u4e0d\u80fd\u6267\u884c\u64cd\u4f5c\u3002", (String)"EPMDVoucherPlugin_6", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("voucherrows");
        for (DynamicObject dynamicObject2 : dynamicObjectCollection) {
            dynamicObject2.set("currencystr", (Object)dynamicObject2.getString("currency.number"));
        }
        checkFun.accept((Object)dataEntity);
        DynamicObject[] save = EPMDVoucherHelper.saveNew((DynamicObject)dataEntity);
        dynamicObject2 = save[0];
        this.getModel().setValue("number", dynamicObject2.get("number"));
        this.getView().updateView("number");
        return save;
    }

    private void checkPermission(String permItemId, String permissionName) {
        String appPkId = AppUtils.getAppPkId((IFormView)this.getView());
        boolean permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appPkId, (String)"epdm_voucher", (String)permItemId);
        if (!permission) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u201c\u51ed\u8bc1\u201d\u7684\u201c%1$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EPMDVoucherPlugin_7", (String)"epm-epbs-formplugin", (Object[])new Object[0]), permissionName));
        }
    }

    private void checkSubmit(DynamicObject dataEntity) {
        String org = dataEntity.getString(ORG);
        if (org == null || StringUtils.isEmpty((String)org)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"EPMDVoucherPlugin_8", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (this.containsChinese(org)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u542b\u4e2d\u6587", (String)"EPMDVoucherPlugin_9", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        String period = dataEntity.getString(PERIOD);
        if (period == null || StringUtils.isEmpty((String)period)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (String)"EPMDVoucherPlugin_10", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        if (this.containsChinese(period)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u542b\u4e2d\u6587", (String)"EPMDVoucherPlugin_11", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynamicObjects = dataEntity.getDynamicObjectCollection("voucherrows");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            String account = dynamicObject.getString("account");
            if (account == null || StringUtils.isEmpty((String)account)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7b2c%1$s\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPMDVoucherPlugin_12", (String)"epm-epbs-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (this.containsChinese(account)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7b2c%1$s\u79d1\u76ee\u4e0d\u80fd\u542b\u4e2d\u6587\u3002", (String)"EPMDVoucherPlugin_13", (String)"epm-epbs-formplugin", (Object[])new Object[0]), i + 1));
            }
            DynamicObject currency = dynamicObject.getDynamicObject("currency");
            if (currency != null) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7b2c%1$s\u884c\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EPMDVoucherPlugin_14", (String)"epm-epbs-formplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private boolean containsChinese(String str) {
        Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private OperationStatus setOperationStatus(OperationStatus status) {
        IFormView view = this.getView();
        IClientViewProxy service = (IClientViewProxy)view.getService(IClientViewProxy.class);
        service.addAction("setFormStatus", (Object)status.getValue());
        this.getPageCache().put("OperationStatus", status.name());
        return status;
    }

    private Collection<ThreeTuple<String, String, String>> currentVoucher() {
        String number = (String)this.getModel().getValue("number");
        String sys = (String)this.getModel().getValue("sourcesys");
        String type = (String)this.getModel().getValue("sourcestype");
        return Lists.newArrayList((Object[])new ThreeTuple[]{new ThreeTuple((Object)number, (Object)sys, (Object)type)});
    }

    private void changeViewStatus() {
        IDataModel dataModel = this.getModel();
        Object billStatus = dataModel.getValue("billstatus");
        Object sys = dataModel.getValue("sourcestype");
        boolean isNotCollection = EPMDVoucherDescConstant.SourcesType.B.getCode().equals(sys) || EPMDVoucherDescConstant.SourcesType.C.getCode().equals(sys);
        EPMDVoucherDescConstant.BillStatus status = EPMDVoucherDescConstant.BillStatus.getBillStatusByCode((Object)billStatus);
        OperationStatus operationStatus = OperationStatus.VIEW;
        if (isNotCollection && (EPMDVoucherDescConstant.BillStatus.A == status || EPMDVoucherDescConstant.BillStatus.C == status || EPMDVoucherDescConstant.BillStatus.E == status)) {
            operationStatus = OperationStatus.ADDNEW;
        }
        this.setOperationStatus(operationStatus);
        boolean isViewStatus = OperationStatus.VIEW == operationStatus;
        this.getView().setVisible(Boolean.valueOf(isViewStatus), new String[]{STATUS_LABEL, OTHER_PANEL});
        boolean isOrgStr = this.getPageCache().get(ORG) != null || isViewStatus;
        this.getView().setVisible(Boolean.valueOf(isOrgStr), new String[]{ORG});
        this.getView().setVisible(Boolean.valueOf(!isOrgStr), new String[]{"orgbasedata"});
        boolean isPeriodStr = this.getPageCache().get(PERIOD) != null || isViewStatus;
        this.getView().setVisible(Boolean.valueOf(isPeriodStr), new String[]{PERIOD});
        this.getView().setVisible(Boolean.valueOf(!isPeriodStr), new String[]{"periodbasedata"});
        boolean isAccountBase = this.getPageCache().get("account") != null || isViewStatus;
        this.getView().setVisible(Boolean.valueOf(isAccountBase), new String[]{"account"});
        this.getView().setVisible(Boolean.valueOf(!isAccountBase), new String[]{"accountbasedata"});
        boolean isSubmit = isNotCollection && EPMDVoucherDescConstant.BillStatus.B == status;
        boolean isPosting = isNotCollection && EPMDVoucherDescConstant.BillStatus.D == status;
        this.getView().setEnable(Boolean.valueOf(isSubmit), new String[]{BTN_REJECT});
        this.getView().setEnable(Boolean.valueOf(isNotCollection && !isPosting), new String[]{BTN_POSTING});
        if (!isNotCollection) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{BTN_SUBMIT, BTN_SAVE});
        }
    }

    private void changeBillStatus() {
        Object billStatus = this.getModel().getValue("billstatus");
        Label billStatusControl = (Label)this.getControl(STATUS_LABEL);
        EPMDVoucherDescConstant.BillStatus status = EPMDVoucherDescConstant.BillStatus.getBillStatusByCode((Object)billStatus);
        billStatusControl.setText(status == null ? "" : status.getDes());
    }

    private void successTip(Collection<ThreeTuple<String, String, String>> dataUniqueKey, EPMDVoucherServiceHelper.ButtonEnum buttonEnum) {
        StringJoiner stringJoiner = new StringJoiner(";");
        dataUniqueKey.forEach(threeTuple -> stringJoiner.add((String)threeTuple.item1 + "\u3000" + (String)threeTuple.item2));
        MultiLangEnumBridge successTipLocale = buttonEnum.getSuccessTipLocale();
        MultiLangEnumBridge tip = new MultiLangEnumBridge(successTipLocale.getDescription(), successTipLocale.getResourceID(), successTipLocale.getSystemType(), new Object[]{stringJoiner.toString()});
        this.getView().showSuccessNotification(tip.loadKDString());
        OperationLogUtil.writeLog((String)this.getModel().getDataEntityType().getName(), (IOperationTypeInfo)new OperationTypeInfo(buttonEnum.name().toLowerCase(Locale.ENGLISH), buttonEnum.getButtonNameLocale()), (MultiLangEnumBridge)tip);
    }
}

