/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epdm.service.voucher;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.epdm.business.datamodel.helper.DataModelPresetHelper;
import kd.epm.epdm.common.entity.EPDMDataModelPreset;
import kd.epm.epdm.common.enums.DataModelPresetEnum;
import kd.epm.epdm.common.enums.DataModelRefTypeEnum;
import kd.epm.epdm.common.util.LongUtil;
import kd.epm.epdm.common.util.MetadataUtil;

public class EPMDVoucherBaseService {
    private static final String TOOL_BAR = "toolbarap";
    private static final String VOUCHER_ROWS_TOOL_BAR = "entitycontoolbar";
    private static final String ACCOUNTING = "accounting";
    private static final String ACCOUNT_NAME = "accountname";
    private static final String OPK_NEW_ENTRY = "newentry";
    private static final String OPK_INSERT_ENTRY = "insertentry";
    private static final String CURRENCY = "currency";
    private static final String ORG_BASE = "orgbasedata";
    private static final String PERIOD_BASE = "periodbasedata";
    private static final String ACCOUNT_BASE = "accountbasedata";
    private final IFormView view;

    public EPMDVoucherBaseService(IFormView view) {
        this.view = view;
    }

    public void registerListener(final IFormPlugin plugin) {
        String[] clickItem;
        for (String s : clickItem = new String[]{TOOL_BAR, VOUCHER_ROWS_TOOL_BAR}) {
            Control c = this.view.getControl(s);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addItemClickListener((ItemClickListener)plugin);
        }
        EntryGrid entry = (EntryGrid)this.view.getControl("voucherrows");
        entry.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent cellClickEvent) {
                String fieldKey = cellClickEvent.getFieldKey();
                if (EPMDVoucherBaseService.ACCOUNTING.equals(fieldKey)) {
                    int row = cellClickEvent.getRow();
                    EPMDVoucherBaseService.this.showAccountingConfig(row, plugin);
                }
            }

            public void cellDoubleClick(CellClickEvent cellClickEvent) {
            }
        });
        BeforeF7SelectListener f7SelectListener = e -> {
            BasedataProp property = (BasedataProp)e.getProperty();
            String name = property.getName();
            String baseEntityId = property.getBaseEntityId();
            if ("epdm_datamodelenumf7".equals(baseEntityId)) {
                e.addCustomQFilter(new QFilter("ref", "=", (Object)LongUtil.toLong((String)this.view.getPageCache().get(name))));
            } else if ("bos_assistantdata_detail".equals(baseEntityId)) {
                e.addCustomQFilter(new QFilter("group", "=", (Object)LongUtil.toLong((String)this.view.getPageCache().get(name))));
            }
        };
        BasedataEdit orgControl = (BasedataEdit)this.view.getControl(ORG_BASE);
        orgControl.addBeforeF7SelectListener(f7SelectListener);
        BasedataEdit periodControl = (BasedataEdit)this.view.getControl(PERIOD_BASE);
        periodControl.addBeforeF7SelectListener(f7SelectListener);
        BasedataEdit accountControl = (BasedataEdit)this.view.getControl(ACCOUNT_BASE);
        accountControl.addBeforeF7SelectListener(f7SelectListener);
        IDataModel dataModel = this.view.getModel();
        BasedataEdit currencyControl = (BasedataEdit)this.view.getControl(CURRENCY);
        currencyControl.addAfterF7SelectListener(event -> {
            ListSelectedRowCollection listSelectedRowCollection = event.getListSelectedRowCollection();
            Object inputValue = listSelectedRowCollection.isEmpty() ? event.getInputValue() : listSelectedRowCollection.get(0).getPrimaryKeyValue();
            int rowCount = dataModel.getEntryRowCount("voucherrows");
            for (int i = 0; i < rowCount; ++i) {
                Object value = dataModel.getValue(CURRENCY, i);
                if (value instanceof DynamicObject) continue;
                dataModel.setValue(CURRENCY, inputValue, i);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (name.endsWith("basedata")) {
            String replace = name.replace("basedata", "");
            if (newValue instanceof DynamicObject) {
                DynamicObject dy = (DynamicObject)newValue;
                BasedataEntityType dataEntityType = (BasedataEntityType)dy.getDataEntityType();
                String billNo = dataEntityType.getBillNo();
                if (StringUtils.isEmpty((String)billNo)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u7f16\u7801\uff0c\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u914d\u7f6e\u9519\u8bef\u3002", (String)"EPMDVoucherBaseService_1", (String)"epm-epbs-formplugin", (Object[])new Object[0]));
                }
                newValue = dy.get(billNo);
            }
            int rowIndex = changeData.getRowIndex();
            IDataModel model = this.view.getModel();
            if (rowIndex > -1) {
                model.setValue(replace, newValue, rowIndex);
            } else {
                model.setValue(replace, newValue);
            }
            this.removeBizChange(replace, rowIndex, model);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (OPK_NEW_ENTRY.equals(evt.getOperationKey()) || OPK_INSERT_ENTRY.equals(evt.getOperationKey())) {
            int[] selectRows;
            EntryGrid rows = (EntryGrid)this.view.getControl("voucherrows");
            for (int selectRow : selectRows = rows.getSelectRows()) {
                if (selectRow <= 0) continue;
                Object currency = this.view.getModel().getValue(CURRENCY, selectRow - 1);
                currency = currency == null ? this.view.getModel().getValue(CURRENCY, 0) : currency;
                this.view.getModel().setValue(CURRENCY, currency, selectRow);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if ("epdm_accountingconfig".equals(e.getActionId()) && returnData != null) {
            Map rsMap = (Map)returnData;
            Object startRow = rsMap.remove("row");
            Integer startRowInt = (Integer)startRow;
            for (int i = 1; i <= 100; ++i) {
                String presetPrefix = "dim";
                String dim = presetPrefix + i;
                Object value = rsMap.get(dim);
                this.view.getModel().setValue(dim, (Object)(value == null ? "" : value), startRowInt.intValue());
            }
            this.view.getModel().setValue(ACCOUNTING, rsMap.get(ACCOUNTING), startRowInt.intValue());
        }
    }

    public void afterBindData(Consumer<Integer> fillOtherFunc) {
        Map aliasToProperty = MetadataUtil.getAliasToProperty((String)"epdm_voucherbase");
        Multimap preset = DataModelPresetHelper.queryPresetByFilter(qFilter -> qFilter.and("datamodel.number", "=", (Object)DataModelPresetEnum.T_EPM_VOUCHER.getNumber()));
        this.changeBaseData((Multimap<String, EPDMDataModelPreset>)preset, aliasToProperty);
        this.fillBaseData(ORG_BASE);
        this.fillBaseData(PERIOD_BASE);
        this.fillEntryBaseData(ACCOUNT_BASE, "account");
        this.fillEntryBaseData(CURRENCY, "currencystr");
        DynamicObjectCollection rows = this.view.getModel().getEntryEntity("voucherrows");
        Map dimToConfig = DataModelPresetHelper.getDimToConfig((Multimap)preset, (Map)aliasToProperty);
        this.doFillField(rows, dimToConfig, fillOtherFunc);
    }

    private void doFillField(DynamicObjectCollection rows, Map<String, EPDMDataModelPreset> dimToConfig, Consumer<Integer> fillOtherFunc) {
        Set dimSetting = DataModelPresetHelper.getDimSetting();
        for (int i = 0; i < rows.size(); ++i) {
            StringJoiner joiner = new StringJoiner(",");
            for (String dim : dimSetting) {
                Object value;
                EPDMDataModelPreset preset = dimToConfig.get(dim);
                if (null == preset || StringUtils.isEmpty((String)((String)(value = this.view.getModel().getValue(dim, i))))) continue;
                String name = preset.getContent();
                joiner.add(name + ":" + value);
            }
            this.view.getModel().setValue(ACCOUNTING, (Object)joiner.toString(), i);
            if (this.view.getControl(ACCOUNT_NAME) == null) continue;
            fillOtherFunc.accept((Object)i);
        }
    }

    private void showAccountingConfig(int row, IFormPlugin plugin) {
        String operationStatus = this.view.getPageCache().get("OperationStatus");
        OperationStatus status = operationStatus == null ? this.view.getFormShowParameter().getStatus() : OperationStatus.valueOf((String)operationStatus);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("epdm_accountingconfig");
        showParameter.setCustomParam("row", (Object)row);
        showParameter.setStatus(status);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "epdm_accountingconfig"));
        this.dimSelected(showParameter, row);
        this.view.showForm(showParameter);
    }

    private void dimSelected(FormShowParameter showParameter, int row) {
        StringJoiner uds = new StringJoiner(",");
        Set dimSetting = DataModelPresetHelper.getDimSetting();
        for (String dim : dimSetting) {
            Object value = this.view.getModel().getValue(dim, row);
            if (!StringUtils.isNotEmpty((String)((String)value))) continue;
            uds.add(dim);
            showParameter.setCustomParam(dim, value);
        }
        showParameter.setCustomParam("dimselected", (Object)uds.toString());
    }

    private void changeBaseData(Multimap<String, EPDMDataModelPreset> preset, Map<String, IDataEntityProperty> aliasToProperty) {
        HashSet fields = Sets.newHashSet((Object[])new String[]{"fentity", "fperiod", "faccount"});
        preset.forEach((k, v) -> {
            String field = v.getField();
            if (!fields.contains(field.toLowerCase(Locale.ROOT))) {
                return;
            }
            IDataEntityProperty property = (IDataEntityProperty)aliasToProperty.get(field.toUpperCase(Locale.ROOT));
            String propertyName = property.getName();
            String refType = v.getRefType();
            String ref = v.getRef();
            if (DataModelRefTypeEnum.Entityobject.name().equals(refType)) {
                this.typeEntity(propertyName, ref);
            } else if (DataModelRefTypeEnum.Enum.name().equals(refType)) {
                this.typeEnum(propertyName, ref);
            } else if (DataModelRefTypeEnum.Assistantdata.name().equals(refType)) {
                this.typeAssistantData(propertyName, ref);
            } else {
                this.view.setVisible(Boolean.valueOf(true), new String[]{propertyName});
                this.view.setVisible(Boolean.valueOf(false), new String[]{propertyName.toLowerCase(Locale.ROOT) + "basedata"});
                this.view.getPageCache().put(propertyName, "strflag");
            }
        });
    }

    private void typeEntity(String textField, String ref) {
        String baseDataField = textField + "basedata";
        BasedataEdit control = (BasedataEdit)this.view.getControl(baseDataField);
        Boolean baseDataVisible = Optional.ofNullable(control).map(FieldEdit::getProperty).map(BasedataProp.class::cast).filter(property -> {
            IDataEntityType complexType = property.getComplexType();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ref);
            return complexType.getPrimaryKey().getPropertyType() == dataEntityType.getPrimaryKey().getPropertyType();
        }).map(property -> {
            property.setBaseEntityId(ref);
            property.setComplexType((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)ref));
            return true;
        }).orElseGet(() -> false);
        this.setVisible(textField, baseDataField, baseDataVisible);
    }

    private void typeEnum(String textField, String ref) {
        String f7EntityNumber = "epdm_datamodelenumf7";
        String baseDataField = textField + "basedata";
        BasedataEdit control = (BasedataEdit)this.view.getControl(baseDataField);
        Boolean baseDataVisible = Optional.ofNullable(control).map(FieldEdit::getProperty).map(BasedataProp.class::cast).filter(property -> {
            IDataEntityType complexType = property.getComplexType();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)f7EntityNumber);
            return complexType.getPrimaryKey().getPropertyType() == dataEntityType.getPrimaryKey().getPropertyType();
        }).map(property -> {
            property.setBaseEntityId(f7EntityNumber);
            property.setComplexType((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)f7EntityNumber));
            this.view.getPageCache().put(baseDataField, ref);
            return true;
        }).orElseGet(() -> false);
        this.setVisible(textField, baseDataField, baseDataVisible);
    }

    public void setVisible(String textField, String baseDataField, Boolean baseDataVisible) {
        boolean isNewAdd;
        OperationStatus status = this.view.getFormShowParameter().getStatus();
        boolean bl = isNewAdd = OperationStatus.ADDNEW == status;
        if (isNewAdd) {
            this.view.setVisible(baseDataVisible, new String[]{baseDataField});
            this.view.setVisible(Boolean.valueOf(baseDataVisible == false), new String[]{textField});
        } else {
            this.view.setVisible(Boolean.valueOf(false), new String[]{baseDataField});
            this.view.setVisible(Boolean.valueOf(true), new String[]{textField});
        }
    }

    private void typeAssistantData(String textField, String ref) {
        String f7EntityNumber = "bos_assistantdata_detail";
        String baseDataField = textField.toLowerCase(Locale.ROOT) + "basedata";
        BasedataEdit control = (BasedataEdit)this.view.getControl(baseDataField);
        Boolean baseDataVisible = Optional.ofNullable(control).map(FieldEdit::getProperty).map(BasedataProp.class::cast).filter(property -> {
            IDataEntityType complexType = property.getComplexType();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)f7EntityNumber);
            return complexType.getPrimaryKey().getPropertyType() == dataEntityType.getPrimaryKey().getPropertyType();
        }).map(property -> {
            property.setBaseEntityId(f7EntityNumber);
            property.setComplexType((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)f7EntityNumber));
            this.view.getPageCache().put(baseDataField, ref);
            return true;
        }).orElseGet(() -> false);
        this.setVisible(textField, baseDataField, baseDataVisible);
    }

    private void fillBaseData(String baseData) {
        BasedataEdit orgBaseData = (BasedataEdit)this.view.getControl(baseData);
        BasedataProp property = (BasedataProp)orgBaseData.getProperty();
        BasedataEntityType propertyType = (BasedataEntityType)property.getDynamicComplexPropertyType();
        String numberProp = propertyType.getBillNo();
        String pkey = propertyType.getPrimaryKey().getName();
        if (StringUtils.isEmpty((String)numberProp)) {
            return;
        }
        String textField = baseData.replace("basedata", "");
        IDataModel dataModel = this.view.getModel();
        Object value = dataModel.getValue(textField);
        DynamicObjectCollection id = QueryServiceHelper.query((String)property.getBaseEntityId(), (String)pkey, (QFilter[])new QFilter[]{new QFilter(numberProp, "=", value)});
        if (!id.isEmpty()) {
            dataModel.setValue(baseData, ((DynamicObject)id.get(0)).get(pkey));
        }
    }

    private void fillEntryBaseData(String baseData, String textField) {
        BasedataEdit orgBaseData = (BasedataEdit)this.view.getControl(baseData);
        BasedataProp property = (BasedataProp)orgBaseData.getProperty();
        BasedataEntityType propertyType = (BasedataEntityType)property.getDynamicComplexPropertyType();
        String numberProp = propertyType.getBillNo();
        String pkey = propertyType.getPrimaryKey().getName();
        if (StringUtils.isEmpty((String)numberProp)) {
            return;
        }
        IDataModel dataModel = this.view.getModel();
        HashMap<Integer, Object> rowValueMap = new HashMap<Integer, Object>(16);
        DynamicObjectCollection dynamicObjectCollection = dataModel.getDataEntity().getDynamicObjectCollection("voucherrows");
        DataEntityPropertyCollection properties = dynamicObjectCollection.getDynamicObjectType().getProperties();
        Optional<String> textPresent = properties.stream().map(IMetadata::getName).filter(p -> p.equals(textField)).findAny();
        if (!textPresent.isPresent()) {
            return;
        }
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            Object value = dynamicObject.get(textField);
            rowValueMap.put(i, value);
        }
        Map<Object, Object> valueIdMap = QueryServiceHelper.query((String)property.getBaseEntityId(), (String)String.join((CharSequence)",", pkey, numberProp), (QFilter[])new QFilter[]{new QFilter(numberProp, "in", rowValueMap.values())}).stream().collect(Collectors.toMap(dy -> dy.get(numberProp), dy -> dy.get(pkey), (v1, v2) -> v1));
        if (!valueIdMap.isEmpty()) {
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                Object oldValue = rowValueMap.get(i);
                Object newValue = valueIdMap.get(oldValue);
                rowValueMap.replace(i, newValue);
                dataModel.setValue(baseData, newValue, i);
            }
        }
    }

    private void removeBizChange(String propertyName, int rowIndex, IDataModel model) {
        MainEntityType dataEntityType = model.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)propertyName);
        if (property != null) {
            int ordinal = property.getOrdinal();
            DynamicObject dataEntity = model.getDataEntity();
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            dataEntityState.setBizChanged(ordinal, false);
        } else {
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("voucherrows");
            if (dynamicObjectCollection.size() > rowIndex) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(rowIndex);
                DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
                int ordinal = ((IDataEntityProperty)dynamicObjectType.getProperties().get((Object)propertyName)).getOrdinal();
                dynamicObject.getDataEntityState().setBizChanged(ordinal, false);
            }
        }
    }
}

