/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.apitest.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.epbs.common.apitest.ApiTest;
import kd.epm.epbs.common.apitest.ApiTestMethod;
import kd.epm.epbs.common.apitest.ApiTestModel;
import kd.epm.epbs.common.apitest.ApiTestParam;
import kd.epm.epbs.common.apitest.enums.ApiTestFeatureEnum;
import kd.epm.epbs.common.apitest.vo.BaseVO;
import kd.epm.epbs.common.apitest.vo.ClassVO;
import kd.epm.epbs.common.apitest.vo.MethodVO;
import kd.epm.epbs.common.apitest.vo.ParameterVO;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

public class ApiInfoUtils {
    private static final String BUSINESS_PACKAGE = "kd.epm.epbs.business";
    private static final String COMMON_PACKAGE = "kd.epm.epbs.common";
    private static final LocalVariableTableParameterNameDiscoverer LOCAL_VARIABLE_TABLE_PARAMETER_NAME_DISCOVERER = new LocalVariableTableParameterNameDiscoverer();

    private ApiInfoUtils() {
    }

    public static Map<ApiTestFeatureEnum, List<ClassVO>> scanBusinessPackageClassWithApiTestAnnotation() {
        Map<ApiTestFeatureEnum, List<ClassVO>> all = ApiInfoUtils.scanAllClassWithApiTestAnnotation(BUSINESS_PACKAGE);
        for (Map.Entry<ApiTestFeatureEnum, List<ClassVO>> e : ApiInfoUtils.scanAllClassWithApiTestAnnotation(COMMON_PACKAGE).entrySet()) {
            if (all.containsKey((Object)e.getKey())) {
                all.get((Object)e.getKey()).addAll((Collection<ClassVO>)e.getValue());
                continue;
            }
            all.put(e.getKey(), e.getValue());
        }
        return all;
    }

    public static Map<ApiTestFeatureEnum, List<ClassVO>> scanAllClassWithApiTestAnnotation(String packageName) {
        EnumMap<ApiTestFeatureEnum, List<ClassVO>> classVOListMap = new EnumMap<ApiTestFeatureEnum, List<ClassVO>>(ApiTestFeatureEnum.class);
        Set<Class<?>> classes = ApiInfoUtils.scanPackageClass(packageName, ApiTest.class);
        for (Class<?> clazz : classes) {
            Method[] methods;
            ArrayList<MethodVO> methodVOS = new ArrayList<MethodVO>();
            for (Method method : methods = clazz.getMethods()) {
                if (!method.isAnnotationPresent(ApiTestMethod.class)) continue;
                ApiTestMethod apiTestMethod = method.getAnnotation(ApiTestMethod.class);
                Class<?> returnType = method.getReturnType();
                MethodVO methodVO = new MethodVO(method.getName(), apiTestMethod.value(), apiTestMethod.test());
                ParameterVO returnModelVO = new ParameterVO(returnType.getName(), null, returnType.getSimpleName(), returnType.getName());
                if (returnType.isAnnotationPresent(ApiTestModel.class)) {
                    ApiTestModel apiTestModel = returnType.getAnnotation(ApiTestModel.class);
                    List<ParameterVO> returnModelParams = ApiInfoUtils.scanApiModelClassFields(returnType);
                    returnModelVO.setDescription(apiTestModel.value());
                    returnModelVO.setModel(true);
                    returnModelVO.setModelFields(returnModelParams);
                    methodVO.setReturnParameter(returnModelVO);
                }
                methodVO.setReturnParameter(returnModelVO);
                methodVO.setDetails(apiTestMethod.details());
                methodVO.setFullMethodInfo(method.toString());
                methodVOS.add(methodVO);
                List<String> methodParameterNames = ApiInfoUtils.findMethodParameterNames(method);
                Parameter[] parameters = method.getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    Parameter parameter = parameters[i];
                    if (!parameter.isAnnotationPresent(ApiTestParam.class)) {
                        throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u4f7f\u7528@ApiTestParam\u6ce8\u89e3");
                    }
                    ApiTestParam apiTestParam = parameter.getAnnotation(ApiTestParam.class);
                    ParameterVO parameterVO = new ParameterVO(methodParameterNames.get(i), apiTestParam.value(), apiTestParam.example(), parameter.getType().getSimpleName(), parameter.getType().getName());
                    if (Date.class.isAssignableFrom(parameter.getType())) {
                        parameterVO.setDateTimeFormat(apiTestParam.dateTimeFormat());
                    }
                    methodVO.getParameterNames().add(parameterVO);
                    if (!parameter.getType().isAnnotationPresent(ApiTestModel.class)) continue;
                    parameterVO.setModel(true);
                    parameterVO.getModelFields().addAll(ApiInfoUtils.scanApiModelClassFields(parameter.getType()));
                }
            }
            ApiTest apiTest = clazz.getAnnotation(ApiTest.class);
            ClassVO classVO = new ClassVO(clazz.getName(), apiTest.value(), apiTest.feature());
            classVO.setMethods(methodVOS.stream().sorted(Comparator.comparing(BaseVO::getName)).collect(Collectors.toList()));
            classVOListMap.computeIfAbsent(apiTest.feature(), k -> new ArrayList()).add(classVO);
        }
        return classVOListMap;
    }

    private static Set<Class<?>> scanPackageClass(String packageName, Class<? extends Annotation> annotation) {
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        return reflections.getTypesAnnotatedWith(annotation);
    }

    private static List<ParameterVO> scanApiModelClassFields(Class<?> apiModel) {
        Field[] declaredFields;
        ArrayList<ParameterVO> parameterVOS = new ArrayList<ParameterVO>();
        for (Field field : declaredFields = apiModel.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ApiTestParam.class)) continue;
            ApiTestParam apiTestParam = field.getAnnotation(ApiTestParam.class);
            ParameterVO parameterVO = new ParameterVO(field.getName(), apiTestParam.value(), apiTestParam.example(), field.getType().getSimpleName(), field.getType().getName());
            if (Date.class.isAssignableFrom(field.getType())) {
                parameterVO.setDateTimeFormat(apiTestParam.dateTimeFormat());
            }
            if (!field.getType().isAssignableFrom(apiModel) && field.getType().isAnnotationPresent(ApiTestModel.class)) {
                parameterVO.setModel(true);
                parameterVO.getModelFields().addAll(ApiInfoUtils.scanApiModelClassFields(field.getType()));
            }
            parameterVOS.add(parameterVO);
        }
        return parameterVOS;
    }

    private static List<String> findMethodParameterNames(Method method) {
        String[] parameterNames = LOCAL_VARIABLE_TABLE_PARAMETER_NAME_DISCOVERER.getParameterNames(method);
        if (parameterNames == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(parameterNames);
    }
}

