/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.bean;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.model.bean.BaseBean;
import org.apache.commons.collections4.CollectionUtils;

public class ModelBean
extends BaseBean {
    private String showNumber;
    private long dataSource;
    private String srcAppNum;
    private List<String> appNums = Collections.emptyList();

    public String getSrcAppNum() {
        return this.srcAppNum;
    }

    public List<String> getAppNums() {
        return this.appNums;
    }

    public String getShowNumber() {
        return this.showNumber;
    }

    public long getDataSource() {
        return this.dataSource;
    }

    protected void setShowNumber(String showNumber) {
        this.showNumber = showNumber;
    }

    protected void setDataSource(long dataSource) {
        this.dataSource = dataSource;
    }

    protected void setSrcAppNum(String srcAppNum) {
        this.srcAppNum = srcAppNum;
    }

    private void setAppNums(String appNums) {
        this.appNums = Collections.unmodifiableList(Arrays.stream(appNums.split(",")).filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList()));
    }

    public void fillData(DynamicObject dy) {
        this.setName(dy.getLocaleString("name"));
        this.setNumber(dy.getString("number"));
        this.setShowNumber(dy.getString("shownumber"));
        this.setDataSource(dy.getLong("datasource_id"));
        if (dy.getDataEntityType().getProperties().stream().anyMatch(e -> e.getName().equals("appnums"))) {
            this.setAppNums(dy.getString("appnums"));
            this.setSrcAppNum(dy.getString("srcappnum"));
            if (CollectionUtils.isEmpty(this.getAppNums())) {
                this.setAppNums(this.getSrcAppNum());
            }
        }
        this.setId(dy.getLong("id"));
    }
}

