/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.bean.tab;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.metadata.form.container.TabAp;
import kd.epm.epbs.common.bean.tab.TabInfo;
import kd.epm.epbs.common.util.ObjectSerialUtil;

public class TabManager<T extends TabInfo>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_TAB_MANAGER_CACHE = "key_tab_manager_cache";
    public static final Map<String, Object> TAB_CLOSE = new HashMap<String, Object>(16);
    private List<T> tabs = new ArrayList<T>(16);

    public boolean addTabInfo(T tab) {
        if (this.tabs.contains(tab)) {
            return false;
        }
        this.tabs.add(tab);
        return true;
    }

    public void releaseAll() {
        this.tabs.clear();
    }

    public void releaseByKey(String tabkey) {
        this.tabs.removeIf(e -> e.getTabKey().equals(tabkey));
    }

    public T getTabInfo(String tabKey) {
        return (T)this.tabs.stream().filter(e -> e.getTabKey().equalsIgnoreCase(tabKey)).findFirst().orElseGet(() -> null);
    }

    public T getSelectedTabInfo() {
        return (T)this.tabs.stream().filter(e -> e.isSelected()).findFirst().orElseGet(() -> null);
    }

    public void selectTabInfo(String tabkey) {
        this.tabs.forEach(e -> e.setSelected(e.getTabKey().equals(tabkey)));
    }

    public List<T> getTabs() {
        return this.tabs;
    }

    public TabAp createTabAp(String tabApKey) {
        TabAp tabAp = new TabAp();
        tabAp.setCanSlide(true);
        tabAp.setScrollToTopFixed(true);
        tabAp.setGrow(0);
        tabAp.setKey(tabApKey);
        this.getTabs().forEach(e -> tabAp.getItems().add(e.createTabPageAp()));
        return tabAp;
    }

    public void activeTab(Tab tab) {
        if (this.getSelectedTabInfo() == null) {
            return;
        }
        tab.activeTab(((TabInfo)this.getSelectedTabInfo()).getTabKey());
    }

    public int getTabCount() {
        return this.getTabs().size();
    }

    public void cacheTabManager(IPageCache pageCache, String key) {
        pageCache.put(key, ObjectSerialUtil.toByteSerialized(this));
    }

    static {
        TAB_CLOSE.put("closable", true);
    }
}

