/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache;

import com.google.common.cache.Cache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.common.cache.ICache;
import kd.epm.epbs.common.cache.ILoader;

public abstract class AbstractCache
implements ICache {
    private final Cache<String, Object> _cache;
    private static final Log log = LogFactory.getLog(AbstractCache.class);

    public AbstractCache(Cache<String, Object> cache) {
        Objects.requireNonNull(cache);
        this._cache = cache;
    }

    @Override
    public <T> T getOrLoad(String key, ILoader<T> loader) {
        try {
            return (T)this._cache.get((Object)key, loader::load);
        }
        catch (ExecutionException e) {
            log.error((Throwable)e);
            throw new RuntimeException(String.format("getOrLoad key[%s] fail!", key), e);
        }
    }

    @Override
    public void invalidateStartsWithKey(String key) {
        ArrayList cacheKeylist = new ArrayList();
        this._cache.asMap().keySet().forEach(cacheKey -> {
            if (cacheKey.startsWith(key)) {
                cacheKeylist.add(cacheKey);
            }
        });
        this._cache.invalidateAll(cacheKeylist);
    }

    @Override
    public void invalidateByKey(String key) {
        this._cache.invalidate((Object)key);
    }

    @Override
    public void invalidateAll() {
        this._cache.invalidateAll();
    }

    @Override
    public <T> T getIfPresent(String key) {
        return (T)this._cache.getIfPresent((Object)key);
    }

    @Override
    public void replaceCache(String key, Object v) {
        this._cache.put((Object)key, v);
    }

    @Override
    public void put(String key, Object v) {
        this._cache.put((Object)key, v);
    }

    @Override
    public void invalidateByKeys(String ... keys) {
        this._cache.invalidateAll(Arrays.asList(keys));
    }
}

