/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.LRUCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.common.cache.ICache;
import kd.epm.epbs.common.cache.ILoader;
import kd.epm.epbs.common.cache.IOperation;
import kd.epm.epbs.common.util.SyncCacheUtil;

public abstract class AbstractLocalMemoryCache
implements ICache {
    private final LocalMemoryCache cache;
    private Set<String> cacheKey = new HashSet<String>();
    private ReentrantLock lock = new ReentrantLock();
    protected static Log log = LogFactory.getLog(AbstractLocalMemoryCache.class);
    private int maxLruSize = 50;

    protected AbstractLocalMemoryCache(LocalMemoryCache cache) {
        this.cache = cache;
    }

    @Override
    public <T> T getOrLoad(String key, ILoader<T> loader) {
        Object lruValue = this.getLocalLRUCache().get((Object)key);
        if (lruValue != null) {
            return (T)lruValue;
        }
        Object value = this.cache.get(key);
        if (value == null || this.checkNotLatest(key)) {
            value = loader.load();
            this.cache.put(key, value);
            SyncCacheUtil.updateLocalCacheTime(this.cache, key);
            log.info(String.format("load key:%s data", key));
        }
        this.lockOperation(() -> this.cacheKey.add(key));
        this.getLocalLRUCache().put((Object)key, value);
        return (T)value;
    }

    public boolean checkNotLatest(String key) {
        return SyncCacheUtil.getTimeFromLocalCache(this.cache, key) < SyncCacheUtil.getTimeFromAppCache(key);
    }

    @Override
    public <T> T getIfPresent(String key) {
        return (T)this.cache.get(key);
    }

    @Override
    public void replaceCache(String key, Object v) {
        this.cache.remove(new String[]{key});
        this.cache.put(key, v);
        this.lockOperation(() -> this.cacheKey.add(key));
        this.getLocalLRUCache().put((Object)key, v);
        SyncCacheUtil.updateAppCacheTime(key);
        SyncCacheUtil.updateLocalCacheTime(this.cache, key);
    }

    @Override
    public void invalidateStartsWithKey(String key) {
        this.lockOperation(() -> {
            ArrayList<String> removeKeys = new ArrayList<String>();
            removeKeys.add(key);
            this.cacheKey.forEach(k -> {
                if (k.startsWith(key)) {
                    removeKeys.add((String)k);
                    SyncCacheUtil.updateAppCacheTime(k);
                }
            });
            if (!removeKeys.isEmpty()) {
                this.cache.remove(removeKeys.toArray(new String[0]));
                removeKeys.forEach(this.cacheKey::remove);
            }
        });
    }

    @Override
    public void invalidateByKey(String key) {
        this.lockOperation(() -> this.cacheKey.remove(key));
        this.cache.remove(new String[]{key});
        SyncCacheUtil.updateAppCacheTime(key);
        this.getLocalLRUCache().remove((Object)key);
    }

    @Override
    public void invalidateAll() {
        ArrayList<String> keys = new ArrayList<String>(this.cacheKey);
        this.lockOperation(() -> this.cacheKey.clear());
        this.cache.clear();
        this.getLocalLRUCache().evictAll();
        keys.forEach(SyncCacheUtil::updateAppCacheTime);
    }

    @Override
    public void put(String key, Object v) {
        this.cache.put(key, v);
        SyncCacheUtil.updateLocalCacheTime(this.cache, key);
        this.lockOperation(() -> this.cacheKey.add(key));
        this.getLocalLRUCache().put((Object)key, v);
    }

    @Override
    public void invalidateByKeys(String ... keys) {
        this.cache.remove(keys);
        this.lockOperation(() -> Arrays.asList(keys).forEach(this.cacheKey::remove));
        for (String key : keys) {
            this.getLocalLRUCache().remove((Object)key);
            SyncCacheUtil.updateAppCacheTime(key);
        }
    }

    public int getMaxLruSize() {
        return this.maxLruSize;
    }

    public void setMaxLruSize(int maxLruSize) {
        this.maxLruSize = maxLruSize;
    }

    private void lockOperation(IOperation opt) {
        try {
            this.lock.lock();
            opt.operateEvent();
        }
        finally {
            this.lock.unlock();
        }
    }

    private LRUCache<String, Object> getLocalLRUCache() {
        return (LRUCache)ThreadCache.get((Object)"local-cache-epbs", () -> new LRUCache(this.getMaxLruSize()));
    }
}

