/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheLoader;
import kd.bos.util.ThreadLocals;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;

public class EpbsThreadCache
implements AutoCloseable {
    private static final ThreadLocal<EpbsThreadCache> etc = ThreadLocals.create(EpbsThreadCache::new);
    private Map<Long, Map<String, Map<String, Map<String, MemberBean>>>> memMap = new HashMap<Long, Map<String, Map<String, Map<String, MemberBean>>>>();
    private Map<Long, Map<String, Map<Long, MemberBean>>> idToMemMap = new HashMap<Long, Map<String, Map<Long, MemberBean>>>();
    private Map<Long, Map<String, Map<String, ViewBean>>> viewMap = new HashMap<Long, Map<String, Map<String, ViewBean>>>();
    private Map<Long, Map<Long, ViewBean>> idToViewMap = new HashMap<Long, Map<Long, ViewBean>>();
    private Map<Object, Map<Object, Map<Object, Object>>> threeLevelMap = new HashMap<Object, Map<Object, Map<Object, Object>>>();
    private Map<Object, Map<Object, Map<Object, Map<Object, Object>>>> fourLevelMap = new HashMap<Object, Map<Object, Map<Object, Map<Object, Object>>>>();
    private Map<Object, Map<Object, Map<Object, Map<Object, Map<Object, Object>>>>> fiveLevelMap = new HashMap<Object, Map<Object, Map<Object, Map<Object, Map<Object, Object>>>>>();

    public static EpbsThreadCache getInstance() {
        return etc.get();
    }

    @Override
    public void close() throws Exception {
        this.memMap = null;
        this.idToMemMap = null;
        this.viewMap = null;
        this.idToViewMap = null;
        this.threeLevelMap = null;
        this.fourLevelMap = null;
        this.fiveLevelMap = null;
    }

    public static ViewBean findViewBeanByNum(long modelId, String dimNum, String viewNum) {
        Map map1 = EpbsThreadCache.getInstance().viewMap.computeIfAbsent(modelId, k -> new HashMap());
        Map map2 = map1.computeIfAbsent(dimNum, k -> new HashMap());
        return map2.computeIfAbsent(viewNum, k -> EpbsModelCacheHelper.get(modelId).getView(dimNum, viewNum));
    }

    public static ViewBean findViewBeanById(long modelId, long viewId) {
        Map map1 = EpbsThreadCache.getInstance().idToViewMap.computeIfAbsent(modelId, k -> new HashMap());
        return map1.computeIfAbsent(viewId, k -> EpbsModelCacheHelper.get(modelId).getViewById(viewId));
    }

    public static MemberBean findMemberBeanByNum(long modelId, String dimNum, long viewId, String memNum) {
        Map map1 = EpbsThreadCache.getInstance().memMap.computeIfAbsent(modelId, k -> new HashMap());
        Map map2 = map1.computeIfAbsent(dimNum, k -> new HashMap());
        ViewBean viewBean = EpbsThreadCache.findViewBeanById(modelId, viewId);
        if (viewBean == null) {
            return null;
        }
        Map map3 = map2.computeIfAbsent(viewBean.getNumber(), k -> new HashMap());
        return map3.computeIfAbsent(memNum, k -> ((EpbsMemberCache)EpbsMemberCacheHelper.get(modelId, dimNum)).getMember(viewBean.getNumber(), memNum));
    }

    public static MemberBean findMemberBeanByNum(long modelId, String dimNum, String viewNum, String memNum) {
        Map map1 = EpbsThreadCache.getInstance().memMap.computeIfAbsent(modelId, k -> new HashMap());
        Map map2 = map1.computeIfAbsent(dimNum, k -> new HashMap());
        Map map3 = map2.computeIfAbsent(viewNum, k -> new HashMap());
        return map3.computeIfAbsent(memNum, k -> ((EpbsMemberCache)EpbsMemberCacheHelper.get(modelId, dimNum)).getMember(viewNum, memNum));
    }

    public static MemberBean findMemberBeanById(long modelId, String dimNum, long memberId) {
        Map map1 = EpbsThreadCache.getInstance().idToMemMap.computeIfAbsent(modelId, k -> new HashMap());
        Map map2 = map1.computeIfAbsent(dimNum, k -> new HashMap());
        return map2.computeIfAbsent(memberId, k -> ((EpbsMemberCache)EpbsMemberCacheHelper.get(modelId, dimNum)).getMember(memberId));
    }

    public static <T> T get(Object key1, Object key2, Object key3, CacheLoader<T> loader) {
        Map map2 = EpbsThreadCache.getInstance().threeLevelMap.computeIfAbsent(key1, k -> new HashMap());
        Map map1 = map2.computeIfAbsent(key2, k -> new HashMap());
        return (T)map1.computeIfAbsent(key3, k -> loader.load());
    }

    public static <T> T get(Object key1, Object key2, Object key3, Object key4, CacheLoader<T> loader) {
        Map map3 = EpbsThreadCache.getInstance().fourLevelMap.computeIfAbsent(key1, k -> new HashMap());
        Map map2 = map3.computeIfAbsent(key2, k -> new HashMap());
        Map map1 = map2.computeIfAbsent(key3, k -> new HashMap());
        return (T)map1.computeIfAbsent(key4, k -> loader.load());
    }

    public static <T> T get(Object key1, Object key2, Object key3, Object key4, Object key5, CacheLoader<T> loader) {
        Map map4 = EpbsThreadCache.getInstance().fiveLevelMap.computeIfAbsent(key1, k -> new HashMap());
        Map map3 = map4.computeIfAbsent(key2, k -> new HashMap());
        Map map2 = map3.computeIfAbsent(key3, k -> new HashMap());
        Map map1 = map2.computeIfAbsent(key4, k -> new HashMap());
        return (T)map1.computeIfAbsent(key5, k -> loader.load());
    }

    public static String getMemberTreeModelByDimNum(long modelId, String dimNum) {
        return (String)EpbsThreadCache.get(dimNum, modelId, "getMemberTreeModelByDimNum", () -> EpbsModelCacheHelper.get(modelId).getMemberTreeModelByDimensionNumber(dimNum));
    }
}

