/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.epm.epbs.common.cache.CommonLocalMemoryCache;
import kd.epm.epbs.common.cache.ICache;
import kd.epm.epbs.common.cache.MembreLocalMemoryCache;
import kd.epm.epbs.common.cache.ModelLocalMemoryCache;
import kd.epm.epbs.common.cache.TemporaryCache;

public class CacheGenFactory {
    private static final Map<String, ICache> commonCacheFactory = new ConcurrentHashMap<String, ICache>();
    private static final Map<String, ICache> temporaryCacheFactory = new ConcurrentHashMap<String, ICache>();
    private static final Map<String, ICache> modelCacheFactory = new ConcurrentHashMap<String, ICache>();
    private static final Map<String, ICache> membreCacheFactory = new ConcurrentHashMap<String, ICache>();

    public static ICache getCommonCache() {
        return commonCacheFactory.computeIfAbsent(CacheKeyUtil.getAcctId(), key -> new CommonLocalMemoryCache());
    }

    public static ICache getTemporaryCache() {
        return temporaryCacheFactory.computeIfAbsent(CacheKeyUtil.getAcctId(), key -> new TemporaryCache());
    }

    public static ICache getModelCache() {
        return modelCacheFactory.computeIfAbsent(CacheKeyUtil.getAcctId(), key -> new ModelLocalMemoryCache());
    }

    public static ICache getMemberCache() {
        return membreCacheFactory.computeIfAbsent(CacheKeyUtil.getAcctId(), key -> new MembreLocalMemoryCache());
    }
}

