/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.helper;

import java.util.Locale;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.epbs.common.cache.ICache;
import kd.epm.epbs.common.cache.ILoader;
import kd.epm.epbs.common.cache.factory.CacheGenFactory;
import kd.epm.epbs.common.enums.CacheTypeEnum;

public class GlobalCacheServiceHelper {
    private static final DistributeSessionlessCache REDIS_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static Log log = LogFactory.getLog(GlobalCacheServiceHelper.class);

    public static String getOrCreateCacheKey() {
        return (String)ThreadCache.get((Object)"cache_node_prefix", () -> DBServiceHelper.genStringId());
    }

    private static String packKey(String prefix, String key) {
        return prefix + "|" + key;
    }

    public static <T> T getOrLoadFromCommonCache(String key, ILoader<T> loader) {
        return CacheGenFactory.getCommonCache().getOrLoad(key, loader);
    }

    public static String getEncoderKey(String key) {
        return key;
    }

    public static <T> T getOrLoadNode(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemporaryCache().getOrLoad(GlobalCacheServiceHelper.packKey(GlobalCacheServiceHelper.getOrCreateCacheKey(), key.toLowerCase(Locale.ENGLISH)), loader);
    }

    public static <T> T getOrLoadNodeFixKey(String key, ILoader<T> loader) {
        return CacheGenFactory.getTemporaryCache().getOrLoad(key.toLowerCase(Locale.ENGLISH), loader);
    }

    public static <T> T getIfPresent(String key) {
        return CacheGenFactory.getTemporaryCache().getIfPresent(GlobalCacheServiceHelper.packKey(GlobalCacheServiceHelper.getOrCreateCacheKey(), key.toLowerCase(Locale.ENGLISH)));
    }

    public static void invalidateCacheByKey(String key) {
        CacheGenFactory.getTemporaryCache().invalidateByKey(key);
    }

    public static void invalidateCommonCacheByKey(String key) {
        CacheGenFactory.getCommonCache().invalidateByKey(key);
    }

    public static void replaceCache(CacheTypeEnum cacheType, String cacheKey, Object value) {
        if (CacheTypeEnum.CommonCache == cacheType) {
            CacheGenFactory.getCommonCache().replaceCache(cacheKey, value);
        }
        if (CacheTypeEnum.TemporaryCache == cacheType) {
            CacheGenFactory.getTemporaryCache().replaceCache(cacheKey, value);
        }
    }

    public static ICache getCache(CacheTypeEnum cacheType) {
        if (CacheTypeEnum.CommonCache == cacheType) {
            return CacheGenFactory.getCommonCache();
        }
        if (CacheTypeEnum.TemporaryCache == cacheType) {
            return CacheGenFactory.getTemporaryCache();
        }
        throw new RuntimeException(String.format("not support cache type %s", cacheType == null ? "null" : cacheType.toString()));
    }

    public static ICache getCommonCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.CommonCache);
    }

    public static ICache getTemporaryCache() {
        return GlobalCacheServiceHelper.getCache(CacheTypeEnum.TemporaryCache);
    }
}

