/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.helper;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;

public class LocalMemoryCacheHelper {
    private static final LocalCacheNullValue NULL = new LocalCacheNullValue();
    private static final CacheConfigInfo cacheConfig = new CacheConfigInfo();

    public static void put(String key, Object content) {
        if (content != null) {
            CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "epbs", cacheConfig).put(key, content);
        }
    }

    public static <T> T get(String key) {
        return (T)CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "epbs", cacheConfig).get(key);
    }

    public static <T> T get(String key, CacheLoader<T> loader) {
        return (T)ThreadCache.get((Object)key, () -> {
            LocalMemoryCache localMemoryCache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "epbs", cacheConfig);
            Object value = localMemoryCache.get(key);
            if (value == null) {
                value = loader.load();
                LocalMemoryCacheHelper.put(key, value == null ? NULL : value);
            } else if (NULL == value) {
                value = null;
            }
            return value;
        });
    }

    public static void clear() {
        CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "epbs", cacheConfig).clear();
    }

    static {
        cacheConfig.setTimeout(30);
        cacheConfig.setMaxItemSize(100000);
        cacheConfig.setTimeToLive(false);
    }

    static class LocalCacheNullValue {
        LocalCacheNullValue() {
        }

        public String toString() {
            return "NULL";
        }
    }
}

