/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.model;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.factory.CacheGenFactory;
import kd.epm.epbs.common.cache.model.ModelCache;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.factory.ConfigurationContext;
import kd.epm.epbs.common.log.EpbsLogFactory;
import kd.epm.epbs.common.log.WatchLogger;
import kd.epm.epbs.common.util.ReflectUtils;

public class ModelCacheHelper {
    private static WatchLogger log = EpbsLogFactory.getWatchLogInstance(ModelCacheHelper.class);
    protected static final ModelBean EMPTY_MODEL = new ModelBean();
    protected static final String ID_CACHE_PREFIX = "id&";

    public static <R extends ModelCache> R get(long id) {
        return (R)CacheGenFactory.getModelCache().getOrLoad(ID_CACHE_PREFIX + id, () -> {
            DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"epbs_model");
            if (dy != null) {
                String clazz = ConfigurationContext.INSTANCE.loadProp(dy.getString("srcappnum"), AppConfigPropEnum.MODEL_CACHE_CLASS);
                ModelCache o = (ModelCache)ReflectUtils.newInstance(clazz);
                o.init(dy);
                return o;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u4f53\u7cfb\u6216\u4f53\u7cfb\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"ModelCacheHelper_1", (String)"epm-epbs-common", (Object[])new Object[0]));
        });
    }

    public static String getModelName(long modelId) {
        Object model = ModelCacheHelper.getModel(modelId);
        if (model == null) {
            return null;
        }
        return model.getNameString();
    }

    public static String getShowNumber(long modelId) {
        Object model = ModelCacheHelper.getModel(modelId);
        if (model == null) {
            return null;
        }
        return ((ModelBean)model).getShowNumber();
    }

    public static <R extends ModelBean> R getModel(long modelId) {
        ModelCache modelCache = null;
        try {
            modelCache = (ModelCache)ModelCacheHelper.get(modelId);
        }
        catch (KDBizException kDBizException) {
            // empty catch block
        }
        if (modelCache == null) {
            return (R)EMPTY_MODEL;
        }
        return (R)modelCache.getModel();
    }

    public static void invalidateModelKey(Collection<DynamicObject> dys) {
        dys.forEach(o -> ModelCacheHelper.invalidateModelKeyById(o.getLong("id")));
    }

    public static void invalidateModelKeyById(Long modelId) {
        CacheGenFactory.getModelCache().invalidateByKeys(ID_CACHE_PREFIX + modelId);
    }
}

