/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.permset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.epbs.common.cache.permset.bean.MatchPermSetItem;
import kd.epm.epbs.common.cache.permset.bean.PermBizGroupItem;
import kd.epm.epbs.common.cache.permset.bean.PermDimGroupItem;
import kd.epm.epbs.common.cache.permset.bean.PermDimItem;
import kd.epm.epbs.common.cache.permset.bean.SinglePermDimItem;
import org.apache.commons.lang3.StringUtils;

public class AuthSetBeanCache {
    public static final String EXPIRE_TIME_CACHE = "datapermset_cache";
    public Map<String, SinglePermDimItem> singleDimMap = new HashMap<String, SinglePermDimItem>(6);
    protected List<PermDimGroupItem> multiDim = new ArrayList<PermDimGroupItem>();
    protected Map<String, List<MatchPermSetItem>> bizMap = new HashMap<String, List<MatchPermSetItem>>(16);
    protected Map<String, MatchPermSetItem> adminBizMap = new HashMap<String, MatchPermSetItem>(16);
    protected Map<String, MatchPermSetItem> adminDimMap = new HashMap<String, MatchPermSetItem>(16);

    protected void addAdminDim(String dim, Long groupId) {
        this.adminDimMap.put(dim, new MatchPermSetItem<PermDimItem>(0, new PermDimItem(groupId, new String[]{dim}, this.singleDimMap.get(dim).getBinaryPos())));
    }

    protected void addAdminBiz(String bizNumber, Long groupId) {
        this.adminBizMap.put(bizNumber, new MatchPermSetItem<PermDimItem>(0, new PermDimItem(groupId, new String[0], 0)));
    }

    protected void addSingleDim(String dim, String entitynumber, Long groupId, boolean hasPerm) {
        if (StringUtils.isNotEmpty((CharSequence)dim)) {
            Integer binaryPostion = 1 << this.singleDimMap.size();
            this.singleDimMap.put(dim, new SinglePermDimItem(groupId, new String[]{dim}, entitynumber, binaryPostion, hasPerm));
        }
    }

    protected void addMultiDim(Long groupId, String[] arrayDim) {
        PermDimGroupItem permDimGroupBean = new PermDimGroupItem(groupId, arrayDim, 0);
        int sum = 0;
        for (int i = 0; i < arrayDim.length; ++i) {
            SinglePermDimItem singlePermDimItem = this.singleDimMap.get(arrayDim[i]);
            singlePermDimItem.addDimGroup(i, permDimGroupBean);
            sum += permDimGroupBean.getBinaryPos();
        }
        permDimGroupBean.setBinaryPos(sum);
        this.multiDim.add(permDimGroupBean);
    }

    protected void addBiz(Long groupId, List<String> dims) {
        ArrayList<String> tmpDims = new ArrayList<String>(dims);
        String biznumber = tmpDims.remove(0);
        String[] arrayDim = tmpDims.toArray(new String[0]);
        PermBizGroupItem permDimGroupBean = new PermBizGroupItem(biznumber, groupId, arrayDim, 0);
        int sum = 0;
        for (int i = 0; i < arrayDim.length; ++i) {
            SinglePermDimItem singlePermDimItem = this.singleDimMap.get(arrayDim[i]);
            singlePermDimItem.addBizGroup(i, permDimGroupBean);
            sum += permDimGroupBean.getBinaryPos();
        }
        permDimGroupBean.setBinaryPos(sum);
        this.bizMap.computeIfAbsent(biznumber, k -> new ArrayList(2)).add(new MatchPermSetItem<PermBizGroupItem>(0, permDimGroupBean));
    }

    public Collection<String> getUsefulPermDim() {
        return this.singleDimMap.keySet();
    }

    public SinglePermDimItem hitSingleDim(String dim) {
        if (this.singleDimMap == null) {
            return null;
        }
        return this.singleDimMap.get(dim);
    }

    public List<MatchPermSetItem> hitDim(String dim) {
        return this.hit(null, Collections.singleton(dim));
    }

    public MatchPermSetItem hitAdmin(String dimnumber, boolean isDim) {
        if (isDim) {
            return this.adminDimMap.get(dimnumber);
        }
        return this.adminBizMap.get(dimnumber);
    }

    public List<MatchPermSetItem> hit(String bizNum, Collection<String> dims) {
        ArrayList<MatchPermSetItem> asList = new ArrayList<MatchPermSetItem>(10);
        if (StringUtils.isNotEmpty((CharSequence)bizNum)) {
            this.hitBiz(bizNum).stream().filter(e -> ((PermDimItem)e.getItem()).getDimNums().length == 0).forEach(e -> asList.add((MatchPermSetItem)e));
        }
        for (String dim : dims) {
            SinglePermDimItem permDimItem = this.hitSingleDim(dim);
            if (permDimItem == null) continue;
            if (StringUtils.isNotEmpty((CharSequence)bizNum)) {
                for (MatchPermSetItem group : permDimItem.getBizGroups(bizNum)) {
                    asList.add(group);
                }
            }
            asList.add(new MatchPermSetItem<SinglePermDimItem>(0, permDimItem));
            if (permDimItem.getDimGroups() == null) continue;
            for (MatchPermSetItem group : permDimItem.getDimGroups()) {
                asList.add(group);
            }
        }
        return asList;
    }

    public List<MatchPermSetItem> hitBiz(String bizNum) {
        return this.bizMap.get(bizNum);
    }
}

