/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.permset;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.epbs.common.cache.permset.AuthSetBeanCache;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeTabEnum;
import org.apache.commons.lang3.StringUtils;

public class AuthSetServiceHelper {
    public static AuthSetBeanCache createAuthSetCache(long modelId, String appNum) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        qf.and("appnum", "=", (Object)appNum);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"epbs_auth_set", (String)"authtype,authbiz,entryentity.group,entryentity.dimnumber,entryentity.entitynumber,entryentity.hasperm", (QFilter[])qf.toArray(), (String)"authtype,authbiz,entryentity.group,entryentity.seq");
        if (dys.isEmpty() && modelId != 0L) {
            return AuthSetServiceHelper.createAuthSetCache(0L, appNum);
        }
        AuthSetBeanCache authSetBean = new AuthSetBeanCache();
        LinkedHashMap<Long, List> dimmap = new LinkedHashMap<Long, List>(16);
        LinkedHashMap<Long, List> bizMap = new LinkedHashMap<Long, List>(16);
        for (DynamicObject e : dys) {
            long authbiz = e.getLong("authbiz");
            int authtype = e.getInt("authtype");
            String dimnumber = e.getString("entryentity.dimnumber");
            if (!StringUtils.isNotEmpty((CharSequence)dimnumber)) continue;
            if (authbiz == AuthTypeTabEnum.SINGLE_DIM.getBizId()) {
                authSetBean.addSingleDim(dimnumber, e.getString("entryentity.entitynumber"), e.getLong("entryentity.group"), e.getBoolean("entryentity.hasperm"));
                continue;
            }
            if (authbiz == AuthTypeTabEnum.ADMIN_BIZ.getBizId()) {
                authSetBean.addAdminBiz(dimnumber, e.getLong("entryentity.group"));
                continue;
            }
            if (authbiz == AuthTypeTabEnum.ADMIN_DIM.getBizId()) {
                authSetBean.addAdminDim(dimnumber, e.getLong("entryentity.group"));
                continue;
            }
            if (authtype == AuthTypeEnum.BIZ.getType()) {
                bizMap.computeIfAbsent(e.getLong("entryentity.group"), a -> new ArrayList(10)).add(dimnumber);
                continue;
            }
            dimmap.computeIfAbsent(e.getLong("entryentity.group"), a -> new ArrayList(10)).add(dimnumber);
        }
        dimmap.forEach((group, dims) -> authSetBean.addMultiDim((Long)group, dims.toArray(new String[0])));
        bizMap.forEach((group, dims) -> authSetBean.addBiz((Long)group, (List<String>)dims));
        return authSetBean;
    }
}

