/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.permset.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.epm.epbs.common.cache.permset.bean.MatchPermSetItem;
import kd.epm.epbs.common.cache.permset.bean.PermBizGroupItem;
import kd.epm.epbs.common.cache.permset.bean.PermDimGroupItem;
import kd.epm.epbs.common.cache.permset.bean.PermDimItem;

public class SinglePermDimItem
extends PermDimItem {
    private String entityNumber;
    private boolean hasPerm;
    private List<MatchPermSetItem> dimGroups;
    private Map<String, List<MatchPermSetItem>> bizGroups;

    public SinglePermDimItem(Long groupSetId, String[] dimNums, String entityNumber, int binaryPos, boolean hasPerm) {
        super(groupSetId, dimNums, binaryPos);
        this.hasPerm = hasPerm;
        this.entityNumber = entityNumber;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public boolean isHasPerm() {
        return this.hasPerm;
    }

    @Override
    public int indexof(String dimnumstr) {
        return 0;
    }

    public List<MatchPermSetItem> getDimGroups() {
        return this.dimGroups;
    }

    public void addDimGroup(int index, PermDimGroupItem group) {
        if (this.dimGroups == null) {
            this.dimGroups = new ArrayList<MatchPermSetItem>(2);
        }
        this.dimGroups.add(new MatchPermSetItem<PermDimGroupItem>(index, group));
    }

    public List<MatchPermSetItem> getBizGroups(String bizNumber) {
        return this.bizGroups.getOrDefault(bizNumber, Collections.emptyList());
    }

    public void addBizGroup(int index, PermBizGroupItem group) {
        if (group.getDimNums() != null && group.getDimNums().length > 0) {
            if (this.bizGroups == null) {
                this.bizGroups = new HashMap<String, List<MatchPermSetItem>>(10);
            }
            this.bizGroups.computeIfAbsent(group.getBizNum(), k -> new ArrayList(2)).add(new MatchPermSetItem<PermBizGroupItem>(index, group, true));
        }
    }

    public String getDimNum() {
        return this.getDimNums()[0];
    }
}

