/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.cache.permset.bean;

import java.util.ArrayList;
import java.util.List;
import kd.epm.epbs.common.cache.permset.bean.BizDataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.DataPermValueItem;
import kd.epm.epbs.common.cache.permset.bean.DimDataPermTreeItem;
import kd.epm.epbs.common.cache.permset.bean.ManagerPermTreeItem;
import kd.epm.epbs.common.enums.DataPermTypeEnum;

public class UserDataPerm {
    private boolean hasData;
    private List<DataPermValueItem> write = new ArrayList<DataPermValueItem>(16);
    private List<DataPermValueItem> read = new ArrayList<DataPermValueItem>(16);
    private List<DataPermValueItem> no = new ArrayList<DataPermValueItem>(16);
    private List<DataPermValueItem> give = new ArrayList<DataPermValueItem>(16);
    private List<DataPermValueItem> manager = new ArrayList<DataPermValueItem>(16);
    private List<DataPermValueItem> except = new ArrayList<DataPermValueItem>(16);

    public void add(int permVal, DataPermValueItem dataPermValueItem) {
        this.hasData = true;
        if (permVal == 0) {
            this.except.add(dataPermValueItem);
            return;
        }
        if ((DataPermTypeEnum.WRITE.getVal() & permVal) > 0) {
            this.write.add(dataPermValueItem);
        } else if ((DataPermTypeEnum.ONLY_READ.getVal() & permVal) > 0) {
            this.read.add(dataPermValueItem);
        } else if ((DataPermTypeEnum.NO.getVal() & permVal) > 0) {
            this.no.add(dataPermValueItem);
        } else if ((DataPermTypeEnum.MANAGE.getVal() & permVal) > 0) {
            this.manager.add(dataPermValueItem);
        }
        if ((DataPermTypeEnum.GIVE.getVal() & permVal) > 0) {
            this.give.add(dataPermValueItem);
        }
    }

    public DataPermTreeItem gen(long curVersion) {
        if (this.hasData) {
            DataPermTreeItem bizDataPermItem = null;
            DataPermValueItem[] dataPermValueItems = new DataPermValueItem[]{};
            if (!this.except.isEmpty()) {
                bizDataPermItem = new BizDataPermTreeItem();
                bizDataPermItem.setExcept(this.except.toArray(dataPermValueItems));
                this.except.clear();
            } else if (!this.manager.isEmpty()) {
                bizDataPermItem = new ManagerPermTreeItem();
                bizDataPermItem.setManager(this.manager.toArray(dataPermValueItems));
                this.manager.clear();
            } else {
                bizDataPermItem = new DimDataPermTreeItem();
            }
            if (!this.write.isEmpty()) {
                bizDataPermItem.setWrite(this.write.toArray(dataPermValueItems));
                this.write.clear();
            }
            if (!this.no.isEmpty()) {
                bizDataPermItem.setNo(this.no.toArray(dataPermValueItems));
                this.no.clear();
            }
            if (!this.read.isEmpty()) {
                bizDataPermItem.setRead(this.read.toArray(dataPermValueItems));
                this.read.clear();
            }
            if (!this.give.isEmpty()) {
                bizDataPermItem.setGive(this.give.toArray(dataPermValueItems));
                this.give.clear();
            }
            if (bizDataPermItem != null) {
                bizDataPermItem.setVersion(curVersion);
            }
            return bizDataPermItem;
        }
        return null;
    }
}

