/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.configuration.factory;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.epbs.common.bean.AppConfigPropBean;
import kd.epm.epbs.common.bean.EpbsAppContext;
import kd.epm.epbs.common.configuration.enums.AppConfigPropEnum;
import kd.epm.epbs.common.configuration.enums.IAppConfigProp;
import kd.epm.epbs.common.configuration.factory.ConfigurationFactory;
import kd.epm.epbs.common.configuration.factory.IConfigurationFactory;
import kd.epm.epbs.common.enums.AppTypeEnum;
import kd.epm.epbs.common.util.EpbsOperationResult;

public class ConfigurationContext {
    private static final Log LOG = LogFactory.getLog(ConfigurationContext.class);
    private Map<String, Map<String, String>> CONFIG_CACHE = new ConcurrentHashMap<String, Map<String, String>>(16);
    public static final ConfigurationContext INSTANCE = new ConfigurationContext();
    public IConfigurationFactory factory = ConfigurationFactory.INSTANCE;

    private ConfigurationContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String loadProp(String appNum, IAppConfigProp prop) {
        Map<String, String> init = this.CONFIG_CACHE.get(appNum);
        if (init == null) {
            Class<ConfigurationFactory> clazz = ConfigurationFactory.class;
            // MONITORENTER : kd.epm.epbs.common.configuration.factory.ConfigurationFactory.class
            init = this.CONFIG_CACHE.get(appNum);
            if (init == null) {
                String realAppNum;
                init = this.factory.init(appNum);
                if (init.isEmpty() && !appNum.equals(realAppNum = ConfigurationContext.findAdaptiveAppNum(appNum))) {
                    init = this.CONFIG_CACHE.computeIfAbsent(appNum, k -> this.factory.init(realAppNum));
                }
                this.CONFIG_CACHE.putIfAbsent(appNum, init);
            }
            // MONITOREXIT : clazz
        }
        if (!init.isEmpty()) return init.getOrDefault(prop.getKey(), prop.getDefaultValue());
        if (!prop.isRemote()) return init.getOrDefault(prop.getKey(), prop.getDefaultValue());
        return this.loadProp2Remote(appNum, prop);
    }

    public static String findAdaptiveAppNum(String appNum) {
        String[] split;
        AppTypeEnum realAppnum = null;
        String s = INSTANCE.loadProp(AppTypeEnum.EPBS.getAppNum(), AppConfigPropEnum.APP_CONFIGFILE_MAPPING);
        for (String t : split = s.split(";")) {
            String[] t2 = t.split(":");
            if (t2.length != 2 || !t2[0].trim().equalsIgnoreCase(appNum) || (realAppnum = AppTypeEnum.getEnumByAppnum(t2[1])) == null) continue;
            return realAppnum.getAppNum();
        }
        return appNum;
    }

    private String loadProp2Remote(String appNum, IAppConfigProp prop) {
        try {
            AppTypeEnum realAppnum = AppTypeEnum.getEnumByAppnum(ConfigurationContext.findAdaptiveAppNum(appNum));
            if (AppTypeEnum.EPBS != realAppnum) {
                AppConfigPropBean appConfigPropBean = new AppConfigPropBean(prop.getKey(), prop.getDefaultValue());
                EpbsAppContext<AppConfigPropBean> _ctx = new EpbsAppContext<AppConfigPropBean>(realAppnum, appConfigPropBean);
                EpbsOperationResult res = (EpbsOperationResult)DispatchServiceHelper.invokeBizService((String)realAppnum.getColudNum(), (String)realAppnum.getMserivceAppId(), (String)"EpbsBizCommonMsService", (String)"syncConfigProp", (Object[])new Object[]{_ctx});
                return (String)res.getData();
            }
            return null;
        }
        catch (Exception e) {
            LOG.error(appNum + "[" + prop.getKey() + "] loading prop fail:" + e.getMessage());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fdc\u7a0b\u52a0\u8f7d\u5e94\u7528\u3010%1$s\u3011\u914d\u7f6e\u5c5e\u6027\u7f16\u7801:%2$s \u5931\u8d25\u3002", (String)"ConfigurationContext_1", (String)"epm-epbs-common", (Object[])new Object[0]), appNum, prop.getKey()));
        }
    }

    public Map<String, String> loadByAppNum(String appNum) {
        Map<String, String> res = this.CONFIG_CACHE.get(appNum);
        if (res == null) {
            this.loadProp(appNum, AppConfigPropEnum.ALL);
            res = this.CONFIG_CACHE.get(appNum);
        }
        return Collections.unmodifiableMap(res);
    }
}

