/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.configuration.factory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.common.configuration.factory.IConfigurationFactory;

public class ConfigurationFactory
implements IConfigurationFactory {
    private static final Log LOG = LogFactory.getLog(ConfigurationFactory.class);
    protected static final ConfigurationFactory INSTANCE = new ConfigurationFactory();

    private ConfigurationFactory() {
    }

    @Override
    public Map<String, String> init(String appNum) {
        Map<String, String> map = ConfigurationFactory.readFileProps(appNum + "/" + "epbs.properties");
        Map<String, String> sdkMap = ConfigurationFactory.readFileProps(appNum + "/" + "epbs_sdk.properties");
        map.putAll(sdkMap);
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> readFileProps(String path) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        try (InputStream in = ConfigurationFactory.class.getClassLoader().getResourceAsStream(path);){
            if (in != null) {
                Properties props = new Properties();
                props.load(new InputStreamReader(in, StandardCharsets.UTF_8));
                props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString().trim(), v.toString().trim())));
            }
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
        return map;
    }
}

