/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.configuration.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.bean.PermItemBean;
import kd.epm.epbs.common.util.ThrowableHelper;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PermItemFactory {
    private static final Log log = LogFactory.getLog(PermItemFactory.class);

    public static Map<String, Map<String, PermItemBean>> genPermItems(String filePath) {
        String[] filePaths;
        HashMap<String, Map<String, PermItemBean>> map = new HashMap<String, Map<String, PermItemBean>>(16);
        for (String path : filePaths = filePath.split(";")) {
            if (!StringUtils.isNotEmpty((String)path)) continue;
            if (path.toLowerCase(Locale.ENGLISH).endsWith(".csv")) {
                map.putAll(PermItemFactory.readCSV(path));
                continue;
            }
            map.putAll(PermItemFactory.readEXCEL(path));
        }
        return map;
    }

    public static Map<String, Map<String, PermItemBean>> readCSV(String filePath) {
        HashMap<String, Map<String, PermItemBean>> map = new HashMap<String, Map<String, PermItemBean>>();
        try (InputStream in = PermItemFactory.class.getClassLoader().getResourceAsStream(filePath);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String DELIMITER = ",";
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] columns = line.split(DELIMITER);
                if (columns.length < 4 || StringUtils.isEmpty((String)columns[2]) || StringUtils.isEmpty((String)columns[3])) continue;
                if (StringUtils.isEmpty((String)columns[0])) {
                    columns[0] = columns[2];
                }
                if (StringUtils.isEmpty((String)columns[1])) {
                    columns[1] = columns[3];
                }
                map.computeIfAbsent(columns[0], k -> new HashMap(4)).put(columns[1], new PermItemBean(columns[2], columns[3]));
            }
        }
        catch (Exception e) {
            log.error("load added permission error:", (Object)filePath);
            throw new KDBizException(ThrowableHelper.toString(e));
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Map<String, PermItemBean>> readEXCEL(String filePath) {
        HashMap<String, Map<String, PermItemBean>> map = new HashMap<String, Map<String, PermItemBean>>();
        try (InputStream in = PermItemFactory.class.getClassLoader().getResourceAsStream(filePath);){
            if (in == null) {
                log.error("load added permission error:", (Object)filePath);
                Map<String, Map<String, PermItemBean>> map2 = Collections.emptyMap();
                return map2;
            }
            try (XSSFWorkbook book = new XSSFWorkbook(in);){
                XSSFSheet sheet = book.getSheetAt(0);
                XSSFRow row = null;
                int rowIndex = 1;
                int rowCount = sheet.getLastRowNum();
                while (rowIndex <= rowCount) {
                    row = sheet.getRow(rowIndex);
                    if (row != null) {
                        String srcFormId = PermItemFactory.getValue(row.getCell(0));
                        String operationKey = PermItemFactory.getValue(row.getCell(1));
                        String targetFormId = PermItemFactory.getValue(row.getCell(2));
                        String permItem = PermItemFactory.getValue(row.getCell(3));
                        if (!(StringUtils.isEmpty((String)srcFormId) || StringUtils.isEmpty((String)targetFormId) || StringUtils.isEmpty((String)permItem))) {
                            map.computeIfAbsent(srcFormId, k -> new HashMap(4)).put(operationKey, new PermItemBean(targetFormId, permItem));
                        }
                    }
                    ++rowIndex;
                }
                return map;
            }
        }
        catch (IOException ex) {
            log.error("load budget permission error:", (Throwable)ex);
        }
        return map;
    }

    private static String getValue(XSSFCell cell) {
        String value = "";
        if (cell != null) {
            value = cell.getStringCellValue();
        }
        return StringUtils.isNotEmpty((String)value) ? value.trim() : value;
    }
}

