/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.ds;

import java.util.Collection;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.epbs.common.cache.helper.AppCacheServiceHelper;
import kd.epm.epbs.common.cache.helper.GlobalCacheServiceHelper;
import kd.epm.epbs.common.ds.DatasourceModel;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ModelUtil;
import org.apache.commons.beanutils.MethodUtils;

public class DataConnectCacheUtil {
    private static Log LOG = LogFactory.getLog(DataConnectCacheUtil.class);

    public static DatasourceModel getDataSourceCache(String modelCatalog, Long modelId) {
        return GlobalCacheServiceHelper.getOrLoadFromCommonCache("_conn_adr_" + modelCatalog, () -> DataConnectCacheUtil.getDataSource(modelCatalog, modelId));
    }

    public static void clearDataSourceCache(Collection<Object> dataSourceIds) {
        if (CollectionUtils.isNotEmpty(dataSourceIds)) {
            DynamicObjectCollection dys = ModelUtil.queryEpbsModel(new QFilter("datasource", "in", dataSourceIds));
            dys.forEach(e -> GlobalCacheServiceHelper.getCommonCache().invalidateByKey("_conn_adr_" + e.getString("number")));
            return;
        }
        GlobalCacheServiceHelper.getCommonCache().invalidateStartsWithKey("_conn_adr_");
    }

    public static DatasourceModel getDataSource(String modelCatalog, Long modelId) {
        DynamicObjectCollection dys;
        if (StringUtils.isEmpty((String)modelCatalog)) {
            throw new KDBizException("modelCatalog is null.");
        }
        QFilter filter = new QFilter("number", "=", (Object)modelCatalog);
        if (IDUtils.isNotNull(modelId)) {
            filter = new QFilter("id", "=", (Object)modelId);
        }
        if (!(dys = ModelUtil.queryEpbsModel(filter)).isEmpty()) {
            return DataConnectCacheUtil.getDataSource((DynamicObject)dys.get(0));
        }
        throw new KDBizException("not found olap connection info.");
    }

    private static DatasourceModel getDataSource(DynamicObject modelDyn) {
        QFilter filter = new QFilter("id", "=", (Object)modelDyn.getLong("datasource"));
        DynamicObject dataSource = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"username,password,accountid,dataconnect", (QFilter[])filter.toArray());
        DataConnectCacheUtil.checkDataSource(dataSource);
        DatasourceModel connect = new DatasourceModel(dataSource.getString("dataconnect"), dataSource.getString("username"), dataSource.getString("password"));
        if (StringUtils.isEmpty((String)connect.getPassword()) || StringUtils.isEmpty((String)connect.getUsername())) {
            throw new RuntimeException("olap connection password or user name is empty,please check olap connection info is correct.");
        }
        return connect;
    }

    public static void checkDataSource(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject dataSource = QueryServiceHelper.queryOne((String)"epbs_datasource", (String)"username,password,accountid", (QFilter[])filter.toArray());
        if (dataSource != null) {
            DataConnectCacheUtil.checkDataSource(dataSource);
        }
    }

    public static void checkDataSource(DynamicObject dy) {
        boolean isSkipDataSourceCheck = false;
        try {
            isSkipDataSourceCheck = (Boolean)MethodUtils.invokeStaticMethod(Class.forName("kd.epm.epbs.business.paramsetting.ParamSettingService"), (String)"queryParamSetting", (Object)"isSkipDataSourceCheck");
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u53c2\u6570\u3010isSkipDataSourceCheck\u3011\u5f02\u5e38", (Throwable)e);
        }
        if (isSkipDataSourceCheck) {
            return;
        }
        if (dy != null) {
            String accountId = dy.getString("accountid");
            if (!DataConnectCacheUtil.isUnittest() && StringUtils.isNotEmpty((String)accountId) && !accountId.equals(RequestContext.get().getAccountId())) {
                StringBuilder errorMsg = new StringBuilder(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u7ed1\u5b9a\u7684\u6570\u636e\u8d26\u5957[ID:%1$s]\u4e0e\u5f53\u524d\u8fd0\u884c\u7684\u6570\u636e\u8d26\u5957[ID:%2$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"DataConnectCacheUtil_1", (String)"epm-epbs-common", (Object[])new Object[0]), accountId, RequestContext.get().getAccountId())).append("\n");
                errorMsg.append(ResManager.loadKDString((String)"\u5982\u662f\u624b\u5de5\u6062\u590d\u7684\u8d26\u5957\uff0c\u53ef\u4ee5\u901a\u8fc7\u4e0b\u9762\u65b9\u6cd5\u89e3\u51b3\uff1a", (String)"DataConnectCacheUtil_2", (String)"epm-epbs-common", (Object[])new Object[0])).append("\n");
                errorMsg.append(ResManager.loadKDString((String)"1\uff09\u65b0\u589e\u5bf9\u5e94\u591a\u7ef4\u5e93\u6570\u636e\u6e90\uff1b", (String)"DataConnectCacheUtil_3", (String)"epm-epbs-common", (Object[])new Object[0])).append("\n");
                errorMsg.append(ResManager.loadKDString((String)"2\uff09\u5df2\u6709\u4f53\u7cfb\u91cd\u65b0\u7ed1\u5b9a\u65b0\u6570\u636e\u6e90\uff1b", (String)"DataConnectCacheUtil_4", (String)"epm-epbs-common", (Object[])new Object[0])).append("\n");
                errorMsg.append(ResManager.loadKDString((String)"3\uff09\u65b0\u5bfc\u5165\u4f53\u7cfb\u8bf7\u9009\u62e9\u65b0\u6570\u636e\u6e90\u5728\u64cd\u4f5c\uff1b", (String)"DataConnectCacheUtil_5", (String)"epm-epbs-common", (Object[])new Object[0]));
                throw new KDBizException(errorMsg.toString());
            }
        }
    }

    public static void setUnittestFlag() {
        AppCacheServiceHelper.put("DataConnectCacheUtil_unittest_" + RequestContext.get().getAccountId(), Boolean.TRUE.toString(), 3600);
    }

    public static boolean isUnittest() {
        String flag = AppCacheServiceHelper.getString("DataConnectCacheUtil_unittest_" + RequestContext.get().getAccountId());
        return Objects.equals(Boolean.TRUE.toString(), flag);
    }
}

