/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.elasticsearch;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.extension.ConcurrentHashSet;
import kd.epm.epbs.common.elasticsearch.ElasticSearchService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ESUtils {
    private static final Set<String> EXISTING_INDICES = new ConcurrentHashSet(10);
    private static final SimpleDateFormat ES_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String TIME_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static String formatUTCDateFormat(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(TIME_FORMAT_ISO8601));
    }

    public static String formatUTCDateFormat(Date date, String datePattern) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.of("UTC")).format(DateTimeFormatter.ofPattern(datePattern));
    }

    public static Date parseUTCDate(String date) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)date), (Object)"param date is empty");
        try {
            Pattern pattern = Pattern.compile("[0-9]*");
            if (pattern.matcher(date).matches()) {
                date = ES_DATE_FORMAT.format(Long.parseLong(date));
            }
            return ES_DATE_FORMAT.parse(date);
        }
        catch (ParseException e) {
            throw new KDBizException("string:" + date + " can not be parsed to date");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndCreateIndex(String indexName, String indexMap) {
        if (ESUtils.isIndexNotExists(indexName)) {
            ErrorCode errorCode = ElasticSearchService.AUDIT_ERROR_CODE;
            synchronized (errorCode) {
                if (ESUtils.isIndexNotExists(indexName)) {
                    Map<String, Integer> settingsMap = ElasticSearchService.getInstance().getDefaultIndexSettings();
                    ElasticSearchService.getInstance().createIndex(indexName, "_doc", settingsMap, indexMap);
                    EXISTING_INDICES.add(indexName);
                }
            }
        }
    }

    private static boolean isIndexNotExists(String indexName) {
        return !EXISTING_INDICES.contains(indexName) && !ElasticSearchService.getInstance().isIndexExist(indexName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceFileAsString(String resourceFilePath) {
        try (InputStream summaryInputStream = ESUtils.class.getClassLoader().getResourceAsStream(resourceFilePath);){
            String string = IOUtils.toString((InputStream)summaryInputStream);
            return string;
        }
        catch (IOException var15) {
            throw new KDBizException(ElasticSearchService.AUDIT_ERROR_CODE, new Object[]{"resource file:" + resourceFilePath + " read error."});
        }
    }

    public static String toEn(String ipStr) {
        return ipStr.trim().toLowerCase(Locale.ENGLISH);
    }

    static {
        ES_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

