/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.epbs.common.elasticsearch.ESUtils;
import kd.epm.epbs.common.util.JSONUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class ElasticSearchService {
    private static final Log log = LogFactory.getLog(ElasticSearchService.class);
    private static Method timeoutMethod;
    private static Constructor timeValueConstructor;
    public static final ErrorCode AUDIT_ERROR_CODE;
    private static final Map<String, RestHighLevelClient> CLIENT_CACHE_MAP;
    protected static RequestOptions defaultRequestOptions;

    public static ElasticSearchService getInstance() {
        return InnerClass.instance;
    }

    public static String getEsConfigError() {
        return ResManager.loadKDString((String)"\u8fde\u63a5\u4e0d\u4e0aes\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5mc\u53c2\u6570(elasticsearch.server.audit)\u662f\u5426\u6b63\u786e", (String)"ElasticSearchService_1", (String)"epm-epbs-common", (Object[])new Object[0]);
    }

    public boolean checkEsAlive() {
        GetIndexRequest req = new GetIndexRequest(new String[]{"test"});
        try {
            this.getESClient().indices().exists(req, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public SearchHits search(String indexName, SearchSourceBuilder sourceBuilder) {
        try {
            SearchRequest request = new SearchRequest(new String[]{indexName});
            if (sourceBuilder != null) {
                request.source(sourceBuilder);
            }
            request.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
            return this.getESClient().search(request, defaultRequestOptions).getHits();
        }
        catch (IOException e) {
            log.error(String.format("failed to execute ES query,indexName:%s,sourceBuilder,%s", indexName, sourceBuilder), (Throwable)e);
            throw new KDBizException(AUDIT_ERROR_CODE, new Object[]{e});
        }
    }

    public void delete(String indexName) {
        DeleteRequest deleteRequest = new DeleteRequest(indexName);
        try {
            this.getESClient().delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error(String.format("failed to execute ES delete,indeName:%s", indexName), (Throwable)e);
            throw new KDBizException(AUDIT_ERROR_CODE, new Object[]{e});
        }
    }

    public void createIndex(String index, String indexType, Map<String, Integer> indexSetting, String indexMapping) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        try {
            this.getESClient().indices().create(createIndexRequest.settings(indexSetting), RequestOptions.DEFAULT);
            if (StringUtils.isNotEmpty((CharSequence)indexMapping)) {
                PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{index});
                putMappingRequest.type(indexType);
                putMappingRequest.source(indexMapping, XContentType.JSON);
                AcknowledgedResponse acknowledgedResponse = this.getESClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
                if (!acknowledgedResponse.isAcknowledged()) {
                    throw new KDException(BosErrorCode.fulltextException, new Object[]{"Failed to create index:" + index + acknowledgedResponse});
                }
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new KDException((Throwable)ex, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public boolean isIndexExist(String index) {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        try {
            return this.getESClient().indices().exists(req, RequestOptions.DEFAULT);
        }
        catch (IOException var4) {
            throw new KDException((Throwable)var4, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public GetIndexResponse getIndex(String index) {
        GetIndexRequest req = new GetIndexRequest(new String[]{index});
        try {
            return this.getESClient().indices().get(req, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public void deleteIndex(String index) {
        try {
            this.getESClient().indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.fulltextException, new Object[0]);
        }
    }

    public void insertDoc(String businessIndex, Map<String, Object> doc) {
        try {
            this.getESClient().index(new IndexRequest(businessIndex).type("_doc").source(doc, XContentType.JSON), RequestOptions.DEFAULT);
        }
        catch (Exception var4) {
            throw new KDException(AUDIT_ERROR_CODE, "failed to insert data to es: " + var4.getMessage(), (Throwable)var4);
        }
    }

    public void insertDoc(String businessIndex, String docJson) {
        try {
            this.getESClient().index(new IndexRequest(businessIndex).type("_doc").source(docJson, XContentType.JSON), RequestOptions.DEFAULT);
        }
        catch (Exception var4) {
            throw new KDException(AUDIT_ERROR_CODE, "failed to insert data to es: " + var4.getMessage(), (Throwable)var4);
        }
    }

    public void insertDoc(String businessIndex, String docJson, String id) {
        try {
            this.getESClient().index(new IndexRequest(businessIndex).type("_doc").id(id).source(docJson, XContentType.JSON), RequestOptions.DEFAULT);
        }
        catch (Exception var5) {
            throw new KDException(AUDIT_ERROR_CODE, "failed to insert data to es: " + var5.getMessage(), (Throwable)var5);
        }
    }

    private RestHighLevelClient getESClient() {
        Map<String, String> configMap = this.getServerConfig("audit");
        String httpport = configMap.get("httpport");
        String port = httpport == null ? configMap.get("port") : httpport;
        String userName = configMap.get("username");
        String pwd = configMap.get("password");
        String ip = configMap.get("ip");
        return CLIENT_CACHE_MAP.computeIfAbsent(ip + port, i -> {
            if (userName != null && pwd != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                String password = Encrypters.decode((String)pwd);
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, Integer.parseInt(port))});
                builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        httpClientBuilder.disableAuthCaching();
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
                return new RestHighLevelClient(builder);
            }
            return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(ip, Integer.parseInt(port), "http")}));
        });
    }

    public Map<String, Integer> getDefaultIndexSettings() {
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        Map<String, String> configMap = this.getServerConfig("audit");
        result.put("index.mapping.total_fields.limit", Integer.valueOf(configMap.get("totalfields")));
        result.put("number_of_replicas", Integer.valueOf(configMap.get("replicasnumber")));
        result.put("number_of_shards", Integer.valueOf(configMap.get("shardsnumber")));
        return result;
    }

    public <T> List<T> convertHits(SearchHit[] hits, TypeReference<T> typeReference) {
        if (ArrayUtils.isEmpty((Object[])hits)) {
            return Collections.emptyList();
        }
        return Arrays.stream(hits).map(hit -> JSONUtils.parse(hit.getSourceAsString(), typeReference)).collect(Collectors.toList());
    }

    public Map<String, String> getServerConfig(String region) {
        String password;
        String username;
        String key = "elasticsearch.server." + region;
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"mc\u4e2d\u672a\u914d\u7f6e\u53c2\u6570:%1", (String)"ElasticSearchService_2", (String)"epm-epbs-common", (Object[])new Object[0]), (String)"ElasticSearchService_0", (String)"epm-epbs-common", (Object[])new Object[]{key}));
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException var17) {
            log.error((Throwable)var17);
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u53c2\u6570(%1)\u89e3\u6790\u9519\u8bef", (String)"ElasticSearchService_3", (String)"epm-epbs-common", (Object[])new Object[0]), (String)"ElasticSearchService_1", (String)"epm-epbs-common", (Object[])new Object[]{key}));
        }
        String ipStr = prop.getProperty("ip");
        if (StringUtils.isEmpty((CharSequence)ipStr)) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u53c2\u6570(%1)\u6ca1\u6709\u914d\u7f6eip", (String)"ElasticSearchService_4", (String)"epm-epbs-common", (Object[])new Object[0]), (String)"ElasticSearchService_2", (String)"epm-epbs-common", (Object[])new Object[]{key}));
        }
        result.put("ip", ESUtils.toEn(ipStr));
        String portStr = prop.getProperty("port");
        if (StringUtils.isEmpty((CharSequence)portStr)) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u53c2\u6570(%1)\u6ca1\u6709\u914d\u7f6eport", (String)"ElasticSearchService_5", (String)"epm-epbs-common", (Object[])new Object[0]), (String)"ElasticSearchService_3", (String)"epm-epbs-common", (Object[])new Object[]{key}));
        }
        result.put("port", ESUtils.toEn(portStr));
        String httpPortStr = prop.getProperty("httpport");
        if (!StringUtils.isEmpty((CharSequence)httpPortStr)) {
            result.put("httpport", ESUtils.toEn(httpPortStr));
        }
        if ((username = prop.getProperty("username")) != null) {
            result.put("username", username);
        }
        if ((password = prop.getProperty("password")) != null) {
            result.put("password", password);
        }
        String enableStr = prop.getProperty("enable", "true");
        result.put("enable", ESUtils.toEn(enableStr));
        String indexStr = prop.getProperty("index", region);
        result.put("index", ESUtils.toEn(indexStr));
        String clusterNameStr = prop.getProperty("clustername", "elasticsearch");
        result.put("clustername", clusterNameStr);
        String totalFieldsStr = prop.getProperty("totalfields", String.valueOf(8000));
        result.put("totalfields", totalFieldsStr);
        String shardsNumberStr = prop.getProperty("shardsnumber", String.valueOf(2));
        result.put("shardsnumber", shardsNumberStr);
        String perlicasNumverStr = prop.getProperty("replicasnumber", String.valueOf(1));
        result.put("replicasnumber", perlicasNumverStr);
        String batchSize = prop.getProperty("batchSize", String.valueOf(1000));
        result.put("batchSize", batchSize);
        return result;
    }

    public void timeoutSeconds(SearchSourceBuilder builder, long seconds) {
        try {
            timeoutMethod.invoke((Object)builder, timeValueConstructor.newInstance(new Object[]{seconds, TimeUnit.SECONDS}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Class<?> timeValueClazz = null;
        try {
            timeValueClazz = Class.forName("org.elasticsearch.common.unit.TimeValue");
        }
        catch (Exception e) {
            log.error("org.elasticsearch.common.unit.TimeValue not found", (Throwable)e);
            try {
                timeValueClazz = Class.forName("org.elasticsearch.core.TimeValue");
            }
            catch (Exception e1) {
                log.error("init TimeValue error", (Throwable)e1);
            }
        }
        if (null != timeValueClazz) {
            try {
                Class<?> searchSourceBuilderClazz = Class.forName(SearchSourceBuilder.class.getName());
                timeoutMethod = searchSourceBuilderClazz.getMethod("timeout", timeValueClazz);
                timeValueConstructor = timeValueClazz.getConstructor(Long.TYPE, TimeUnit.class);
            }
            catch (Exception e) {
                log.error("init timeoutMethod error", (Throwable)e);
            }
        }
        AUDIT_ERROR_CODE = new ErrorCode("epm.audit", ElasticSearchService.getEsConfigError());
        CLIENT_CACHE_MAP = new HashMap<String, RestHighLevelClient>(8);
        defaultRequestOptions = null;
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(0x40000000));
        defaultRequestOptions = builder.build();
    }

    private static class InnerClass {
        private static ElasticSearchService instance = new ElasticSearchService();

        private InnerClass() {
        }
    }
}

