/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.epbs.common.enums;

import kd.epm.epbs.common.annotation.AppMark;
import kd.epm.epbs.common.enums.AppTypeEnum;

@AppMark
public enum AppDatasetEnum {
    CM(AppTypeEnum.CM, null),
    BGMD(AppTypeEnum.BGMD, "eb_dataset"),
    EPBS(AppTypeEnum.EPBS, null);

    private AppTypeEnum appType;
    private String datasetEntity;

    private AppDatasetEnum(AppTypeEnum appType, String datasetEntity) {
        this.appType = appType;
        this.datasetEntity = datasetEntity;
    }

    public AppTypeEnum getAppType() {
        return this.appType;
    }

    public String getDatasetEntity() {
        return this.datasetEntity;
    }

    public static AppDatasetEnum getByNumber(String appNumber) {
        AppDatasetEnum appModel = EPBS;
        for (AppDatasetEnum e : AppDatasetEnum.values()) {
            if (!e.getAppType().getAppNum().equalsIgnoreCase(appNumber)) continue;
            appModel = e;
        }
        return appModel;
    }

    public static String getDatasetEntity(String appNumber) {
        return AppDatasetEnum.getByNumber(appNumber).getDatasetEntity();
    }
}

